FullCalendar.globalLocales.push(function () {
  'use strict';

  var en = {
    code: "en",
    week: {
      dow: 0,
      doy: 4
    },
    buttonText: {
      prev: "Prev",
      next: "Next",
      today: "Today",
      year: "Year",
      month: "Month",
      week: "Week",
      day: "Day",
      list: "List"
    },
    weekText: "W",  
    weekTextLong: "Week",
    allDayText: "All Day",
    moreLinkText: function(n) {
      return "+ more " + n;
    },
    noEventsText: "No events to display",
    buttonHints: {
      prev: function(buttonText) {
        return "Previous ".concat(buttonText);
      },
      next: function(buttonText) {
        return "Next ".concat(buttonText);
      },
      today: function(buttonText) {
        return "This ".concat(buttonText);
      }
    },
    viewHint: function(buttonText) {
      return "View ".concat(buttonText);
    },
    navLinkHint: "Go to $0",
    moreLinkHint: function(eventCnt) {
      return "Show ".concat(eventCnt === 1 ? "one more event" : eventCnt + " more events");
    },
    closeHint: "Close",
    timeHint: "Time",
    eventHint: "Event"
  };

  return en;

}());
