FullCalendar.globalLocales.push(function () {
  'use strict';

  function affix(buttonText) {
    return buttonText === "Tag" || buttonText === "Monat" ? "r" : buttonText === "Jahr" ? "s" : "";
  }
  var de = {
    code: "de",
    week: {
      dow: 1,
      doy: 4
    },
    buttonText: {
      prev: "Zurück",
      next: "Vor",
      today: "Heute",
      year: "Jahr",
      month: "Monat",
      week: "Woche",
      day: "Tag",
      list: "Terminübersicht"
    },
    weekText: "KW",
    weekTextLong: "Woche",
    allDayText: "Ganztägig",
    moreLinkText: function(n) {
      return "+ weitere " + n;
    },
    noEventsText: "Keine Ereignisse anzuzeigen",
    buttonHints: {
      prev: function(buttonText) {
        return "Vorherige".concat(affix(buttonText), " ").concat(buttonText);
      },
      next: function(buttonText) {
        return "Nächste".concat(affix(buttonText), " ").concat(buttonText);
      },
      today: function(buttonText) {
        if (buttonText === "Tag") {
          return "Heute";
        }
        return "Diese".concat(affix(buttonText), " ").concat(buttonText);
      }
    },
    viewHint: function(buttonText) {
      var glue = buttonText === "Woche" ? "n" : buttonText === "Monat" ? "s" : "es";
      return buttonText + glue + "ansicht";
    },
    navLinkHint: "Gehe zu $0",
    moreLinkHint: function(eventCnt) {
      return "Zeige " + (eventCnt === 1 ? "ein weiteres Ereignis" : eventCnt + " weitere Ereignisse");
    },
    closeHint: "Schließen",
    timeHint: "Uhrzeit",
    eventHint: "Ereignis"
  };

  return de;

}());
