jQuery(document).ready(function($) {
    // Quick Filter Buttons
    $('.simpbook-quick-filter').on('click', function() {
        var range = $(this).data('range');
        var today = new Date();
        var startDate, endDate;
        
        // Berechne Datumsbereich basierend auf Range
        switch(range) {
            case 'last-month':
                // Letzter Monat: Von vor 30 Tagen bis heute
                startDate = new Date(today);
                startDate.setDate(today.getDate() - 30);
                endDate = today;
                break;
            case 'last-3-months':
                // Letzte 3 Monate: Von vor 90 Tagen bis heute
                startDate = new Date(today);
                startDate.setDate(today.getDate() - 90);
                endDate = today;
                break;
            case 'last-6-months':
                // Letzte 6 Monate: Von vor 180 Tagen bis heute
                startDate = new Date(today);
                startDate.setDate(today.getDate() - 180);
                endDate = today;
                break;
        }
        
        // Formatiere Datum als YYYY-MM-DD
        var formatDate = function(date) {
            var year = date.getFullYear();
            var month = String(date.getMonth() + 1).padStart(2, '0');
            var day = String(date.getDate()).padStart(2, '0');
            return year + '-' + month + '-' + day;
        };
        
        // Setze Datums-Felder
        $('#simpbook_filter_start').val(formatDate(startDate));
        $('#simpbook_filter_end').val(formatDate(endDate));
        
        // Submit das Formular
        $(this).closest('form').submit();
    });

    // Daten aus wp_localize_script
    var data = simpbookStatistikenData;

    // Buchungen pro Tag Chart
    if (document.getElementById('bookingsPerDayChart') && data.bookingsPerDay) {
        new Chart(document.getElementById('bookingsPerDayChart'), {
            type: 'line',
            data: {
                labels: data.bookingsPerDay.labels,
                datasets: [{
                    label: data.bookingsPerDay.label,
                    data: data.bookingsPerDay.values,
                    backgroundColor: 'rgba(34, 113, 177, 0.2)',
                    borderColor: 'rgba(34, 113, 177, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
    }

    // Buchungen pro Dienstleistung Chart
    if (document.getElementById('bookingsPerServiceChart') && data.bookingsPerService) {
        new Chart(document.getElementById('bookingsPerServiceChart'), {
            type: 'bar',
            data: {
                labels: data.bookingsPerService.labels,
                datasets: [{
                    label: data.bookingsPerService.label,
                    data: data.bookingsPerService.values,
                    backgroundColor: [
                        'rgba(34, 113, 177, 0.8)',
                        'rgba(52, 152, 219, 0.8)',
                        'rgba(155, 89, 182, 0.8)',
                        'rgba(46, 204, 113, 0.8)',
                        'rgba(241, 196, 15, 0.8)',
                        'rgba(230, 126, 34, 0.8)',
                        'rgba(231, 76, 60, 0.8)',
                        'rgba(149, 165, 166, 0.8)',
                        'rgba(52, 73, 94, 0.8)',
                        'rgba(26, 188, 156, 0.8)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
    }

    // Buchungen pro Mitarbeiter Chart
    if (document.getElementById('bookingsPerEmployeeChart') && data.bookingsPerEmployee) {
        new Chart(document.getElementById('bookingsPerEmployeeChart'), {
            type: 'bar',
            data: {
                labels: data.bookingsPerEmployee.labels,
                datasets: [{
                    label: data.bookingsPerEmployee.label,
                    data: data.bookingsPerEmployee.values,
                    backgroundColor: [
                        'rgba(34, 113, 177, 0.8)',
                        'rgba(52, 152, 219, 0.8)',
                        'rgba(155, 89, 182, 0.8)',
                        'rgba(46, 204, 113, 0.8)',
                        'rgba(241, 196, 15, 0.8)',
                        'rgba(230, 126, 34, 0.8)',
                        'rgba(231, 76, 60, 0.8)',
                        'rgba(149, 165, 166, 0.8)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            stepSize: 1
                        }
                    }
                }
            }
        });
    }
    
    // ============================================
    // Mobile & Tablet Filter Toggle für Statistik
    // ============================================
    var statsFilterToggle = $('#simpbook-stats-filter-toggle');
    var statsFilterPanel = $('#simpbook-stats-filter-panel');
    
    if (statsFilterToggle.length && statsFilterPanel.length) {
        statsFilterToggle.on('click', function(e) {
            e.preventDefault();
            var isExpanded = $(this).attr('aria-expanded') === 'true';
            $(this).attr('aria-expanded', !isExpanded);
            statsFilterPanel.toggleClass('show');
        });
        
        $(document).on('click', function(e) {
            if (window.innerWidth <= 1200) {
                if (!$(e.target).closest('.simpbook-stats-filters').length) {
                    statsFilterPanel.removeClass('show');
                    statsFilterToggle.attr('aria-expanded', 'false');
                }
            }
        });
        
        statsFilterPanel.on('click', function(e) {
            e.stopPropagation();
        });
    }
});

