jQuery(document).ready(function($) {
    // Daten aus wp_localize_script
    var data = simpbookSetupWizardData;

    // Zeige Erfolgsmeldung nach Reset
    if (data.showResetSuccess) {
        $('<div class="notice notice-success is-dismissible" style="margin-top: 20px;"><p>' + data.translations.resetSuccess + '</p></div>')
            .insertAfter('.simpbook-wizard-header');

        // Entferne Reset-Parameter aus URL
        if (window.history && window.history.replaceState) {
            var newUrl = window.location.href.replace(/[?&]reset=success/, '');
            window.history.replaceState({}, '', newUrl);
        }
    }

    // Reset-Button Funktionalität für Schritt 1
    $('#simpbook-wizard-reset-step1').on('click', function(e) {
        e.preventDefault();

        var confirmMessage = data.translations.confirmResetMessage;
        var confirmTitle = data.translations.confirmResetTitle;

        if (typeof window.simpbookConfirm === 'function') {
            window.simpbookConfirm(confirmMessage, confirmTitle).then(function(confirmed) {
                if (confirmed) {
                    window.location.href = data.resetUrl;
                }
            });
        } else {
            // Fallback zu Browser confirm
            if (confirm(confirmMessage)) {
                window.location.href = data.resetUrl;
            }
        }
    });

    // AM/PM Zeit-Konvertierung für English AM/PM Sprache
    if (data.currentLanguage === 'en_US_AMPM') {
        // Helper-Funktionen für Zeit-Konvertierung
        function convert24to12(time24) {
            if (!time24) return '';
            var parts = time24.split(':');
            if (parts.length < 2) return time24;
            var h = parseInt(parts[0], 10);
            var m = parts[1];
            var ampm = h >= 12 ? 'PM' : 'AM';
            h = h % 12;
            if (h === 0) h = 12;
            return (h < 10 ? '0' : '') + h + ':' + m + ' ' + ampm;
        }
        
        function convert12to24(time12) {
            if (!time12) return '';
            var match = time12.match(/^(\d{1,2}):(\d{2})\s*(AM|PM)?$/i);
            if (!match) return time12;
            var h = parseInt(match[1], 10);
            var m = match[2];
            var ampm = (match[3] || 'AM').toUpperCase();
            if (ampm === 'PM' && h < 12) h += 12;
            if (ampm === 'AM' && h === 12) h = 0;
            return (h < 10 ? '0' : '') + h + ':' + m;
        }
        
        function ensureAmPmToggle($input, ampm) {
            var $existing = $input.next('.ampm-toggle');
            if (!$existing.length) {
                var $wrap = $('<div class="ampm-toggle" role="group" aria-label="AM/PM">' +
                              '<button type="button" class="ampm-btn" data-ampm="AM" aria-pressed="false">AM</button>' +
                              '<button type="button" class="ampm-btn" data-ampm="PM" aria-pressed="false">PM</button>' +
                              '</div>');
                $input.after($wrap);
                $wrap.on('click', '.ampm-btn', function() {
                    var $btn = $(this);
                    $wrap.find('.ampm-btn').removeClass('active').attr('aria-pressed', 'false');
                    $btn.addClass('active').attr('aria-pressed', 'true');
                    var val = $btn.data('ampm') || 'AM';
                    $input.data('ampm', val.toUpperCase());
                    $input.attr('data-ampm', val.toUpperCase());
                });
                $existing = $wrap;
            }
            var selected = (ampm || 'AM').toUpperCase();
            $existing.find('.ampm-btn').removeClass('active').attr('aria-pressed', 'false')
                     .filter('[data-ampm="' + selected + '"]').addClass('active').attr('aria-pressed', 'true');
            $input.data('ampm', selected);
            $input.attr('data-ampm', selected);
        }
        
        // Konvertiere alle Zeit-Inputs im Wizard zu AM/PM
        $('.simpbook-wizard-opening-hours .time-input').each(function() {
            var $input = $(this);
            var time24 = $input.val() || $input.attr('value') || '';
            
            // Speichere den originalen 24h Wert
            $input.data('original-24h-time', time24);
            
            // Konvertiere zu text-input
            $input.attr('type', 'text');
            $input.attr('placeholder', '--:-- AM/PM');
            
            if (time24) {
                var time12Parts = convert24to12(time24).split(' ');
                var hhmm = time12Parts[0];
                var ampm = time12Parts[1] || 'AM';
                $input.val(hhmm);
                $input.attr('value', hhmm);
                ensureAmPmToggle($input, ampm);
            } else {
                $input.val('--:--');
                ensureAmPmToggle($input, 'AM');
            }
        });
        
        // Vor dem Absenden zurück zu 24h konvertieren
        $('.simpbook-wizard-form').on('submit', function(e) {
            $('.simpbook-wizard-opening-hours .time-input').each(function() {
                var $input = $(this);
                var $toggle = $input.next('.ampm-toggle');
                
                if ($toggle.length) {
                    var time12 = $input.val();
                    var ampm = 'AM';
                    
                    // AM/PM aus Toggle lesen
                    var $activeBtn = $toggle.find('.ampm-btn.active');
                    if ($activeBtn.length) {
                        ampm = ($activeBtn.data('ampm') || 'AM').toUpperCase();
                    } else if ($input.data('ampm')) {
                        ampm = String($input.data('ampm')).toUpperCase();
                    }
                    
                    // Zu 24h konvertieren
                    if (time12 && /^\d{1,2}:\d{2}$/.test(time12)) {
                        var time24 = convert12to24(time12 + ' ' + ampm);
                        $input.val(time24);
                        $input.attr('value', time24);
                    }
                    
                    // Toggle entfernen
                    $toggle.remove();
                }
                
                // Zurück zu time-input für korrekte Formular-Verarbeitung
                $input.attr('type', 'time');
            });
        });
    }
});

