jQuery(document).ready(function($) {
    // ==========================================
    // Einträge pro Seite Dropdown
    // ==========================================
    $('#simpbook-per-page-select').on('change', function() {
        var perPage = $(this).val();
        var currentUrl = new URL(window.location.href);
        currentUrl.searchParams.set('simpbook_per_page', perPage);
        currentUrl.searchParams.delete('simpbook_seite_nr'); // Zurück zu Seite 1
        window.location.href = currentUrl.toString();
    });

    // ==========================================
    // View Toggle Funktionalität (nur Desktop)
    // ==========================================
    var storedView = localStorage.getItem('simpbook_reservierungen_view');
    var isCardView = storedView === 'card'; // Default: Tabellenansicht (false)
    
    console.log('Reservierungen View Load:', {
        storedView: storedView,
        isCardView: isCardView,
        windowWidth: $(window).width(),
        tabellExists: $('.desktop-reservierungen-tabelle').length,
        kartenExists: $('.mobile-reservierungen-karten').length
    });
    
    // Initial view setzen (nur Desktop)
    if ($(window).width() > 782) {
        if (isCardView) {
            console.log('Applying card view on load');
            switchToCardView();
        } else {
            console.log('Applying table view on load');
            switchToTableView();
        }
    }
    
    $('#toggle-reservierungen-view-btn').on('click', function() {
        isCardView = !isCardView;
        localStorage.setItem('simpbook_reservierungen_view', isCardView ? 'card' : 'table');
        
        if (isCardView) {
            switchToCardView();
        } else {
            switchToTableView();
        }
        
        // Suche erneut anwenden nach View-Wechsel
        if ($searchInput.val().trim().length > 0) {
            performSearch();
        }
    });
    
    function switchToTableView() {
        $('.desktop-reservierungen-tabelle').css('display', 'block');
        $('.mobile-reservierungen-karten').css('display', 'none');
        $('#toggle-reservierungen-view-text').text(simpbookReservierungenListe.translations.cardView || 'Kartenansicht');
        $('.dashicons', '#toggle-reservierungen-view-btn').removeClass('dashicons-list-view').addClass('dashicons-grid-view');
    }
    
    function switchToCardView() {
        $('.desktop-reservierungen-tabelle').css('display', 'none');
        $('.mobile-reservierungen-karten').css('display', 'grid');
        $('#toggle-reservierungen-view-text').text(simpbookReservierungenListe.translations.tableView || 'Tabellenansicht');
        $('.dashicons', '#toggle-reservierungen-view-btn').removeClass('dashicons-grid-view').addClass('dashicons-list-view');
    }

    // Bei Resize prüfen (Mobile immer Karten, keine Toggle-Wirkung)
    $(window).on('resize', function() {
        if ($(window).width() <= 782) {
            // Mobile: Erzwinge Kartenansicht, ignoriere Toggle
            $('.desktop-reservierungen-tabelle').css('display', 'none');
            $('.mobile-reservierungen-karten').css('display', 'grid');
        } else {
            // Desktop: Wende gespeicherte Ansicht an
            if (isCardView) {
                switchToCardView();
            } else {
                switchToTableView();
            }
        }
    });

    // ==========================================
    // Rest des bestehenden Codes
    // ==========================================

    // Modal-Funktionalität
    var currentReservierungId = null;
    var baseUrl = simpbookReservierungenListe.baseUrl;
    var currentPage = simpbookReservierungenListe.currentPage;
    var currentOrder = simpbookReservierungenListe.currentOrder;
    var currentDirection = simpbookReservierungenListe.currentDirection;
    var currentFilter = simpbookReservierungenListe.currentFilter;

    // Zeile klickbar machen
    $(document).on('click', '.reservierung-row-clickable', function(e) {
        // Verhindere Klick wenn auf Link, Button oder Checkbox geklickt wird
        if ($(e.target).is('a') || $(e.target).closest('a').length ||
            $(e.target).is('button') || $(e.target).closest('button').length ||
            $(e.target).is('input[type="checkbox"]') || $(e.target).closest('input[type="checkbox"]').length) {
            return;
        }

        e.preventDefault();
        e.stopPropagation();

        var $row = $(this);
        var reservierungDataStr = $row.attr('data-reservierung-data');
        if (!reservierungDataStr) {
            console.error('Keine Reservierungsdaten gefunden');
            return;
        }

        var reservierungData = JSON.parse(reservierungDataStr);
        currentReservierungId = reservierungData.id;

        // Modal mit Daten füllen
        $('#modal-name').text(reservierungData.name || '-');
        $('#modal-email').text(reservierungData.email || '-');
        $('#modal-telefon').text(reservierungData.telefon || '-');
        $('#modal-datum').text(reservierungData.datum || '-');
        // Uhrzeit im richtigen Format anzeigen
        var pluginLang = simpbookReservierungenListe.currentLanguage;
        var displayTime = reservierungData.uhrzeit || '-';
        if (displayTime && displayTime !== '-') {
            var timeParts = displayTime.split(':');
            if (timeParts.length >= 2) {
                var hour = parseInt(timeParts[0], 10);
                var minute = timeParts[1];
                if (pluginLang === 'en_US_AMPM') {
                    var ampm = hour >= 12 ? 'PM' : 'AM';
                    var hour12 = hour % 12;
                    if (hour12 === 0) hour12 = 12;
                    displayTime = hour12 + ':' + minute + ' ' + ampm;
                } else {
                    displayTime = hour.toString().padStart(2, '0') + ':' + minute;
                }
            }
        }
        $('#modal-uhrzeit').text(displayTime);
        $('#modal-dienstleistung').text(reservierungData.dienstleistung || '-');
        
        // Mitarbeiter-Dropdown befüllen
        var mitarbeiterId = reservierungData.mitarbeiter_id || '0';
        var $mitarbeiterSelect = $('#modal-mitarbeiter-select');
        $mitarbeiterSelect.empty();
        
        // Standard-Option "Kein bestimmter Mitarbeiter"
        var defaultText = simpbookReservierungenListe.translations.noSpecificEmployee || 'Kein bestimmter Mitarbeiter';
        $mitarbeiterSelect.append('<option value="0">' + defaultText + '</option>');
        
        var currentMitarbeiterFound = false;
        
        // Verfügbare Mitarbeiter hinzufügen
        if (reservierungData.verfuegbare_mitarbeiter && Array.isArray(reservierungData.verfuegbare_mitarbeiter)) {
            $.each(reservierungData.verfuegbare_mitarbeiter, function(index, ma) {
                var isSelected = (ma.id == mitarbeiterId);
                if (isSelected) currentMitarbeiterFound = true;
                $mitarbeiterSelect.append('<option value="' + ma.id + '"' + (isSelected ? ' selected' : '') + '>' + ma.name + '</option>');
            });
        }
        
        // Wenn der aktuelle Mitarbeiter nicht in der Liste ist (z.B. weil geblockt), trotzdem anzeigen
        if (!currentMitarbeiterFound && mitarbeiterId != '0' && reservierungData.mitarbeiter && reservierungData.mitarbeiter !== '-') {
             $mitarbeiterSelect.append('<option value="' + mitarbeiterId + '" selected>' + reservierungData.mitarbeiter + '</option>');
        } else if (!currentMitarbeiterFound && mitarbeiterId == '0') {
            $mitarbeiterSelect.val('0');
        }
        
        $mitarbeiterSelect.attr('data-reservierung-id', reservierungData.id);
        
        $('#modal-nachricht').text(reservierungData.nachricht || '-');

        // Status-Badge
        var statusClass = 'status-ausstehend';
        var statusText = simpbookReservierungenListe.translations.ausstehend;
        if (reservierungData.status === 'BESTÄTIGT') {
            statusClass = 'status-bestätigt';
            statusText = simpbookReservierungenListe.translations.bestaetigt;
        } else if (reservierungData.status === 'ABGELEHNT' || reservierungData.status === 'STORNIERT') {
            statusClass = 'status-abgelehnt';
            statusText = reservierungData.status === 'STORNIERT' ? simpbookReservierungenListe.translations.storniert : simpbookReservierungenListe.translations.abgelehnt;
        }
        $('#modal-status-badge').html('<span class="status-badge ' + statusClass + '">' + statusText + '</span>');

        // Status-Datum anzeigen
        var statusDateLabel = '';
        var statusDateValue = '';
        var statusDate = reservierungData.status_geaendert_datum || reservierungData.erstellungsdatum || reservierungData.datum;

        if (statusDate && reservierungData.status && reservierungData.status !== 'AUSSTEHEND') {
            var statusTranslated = '';
            if (reservierungData.status === 'BESTÄTIGT') {
                statusTranslated = simpbookReservierungenListe.translations.bestaetigt;
            } else if (reservierungData.status === 'ABGELEHNT') {
                statusTranslated = simpbookReservierungenListe.translations.abgelehnt;
            } else if (reservierungData.status === 'STORNIERT' || reservierungData.storniert == 1) {
                statusTranslated = simpbookReservierungenListe.translations.storniert;
            }

            if (statusTranslated) {
                statusDateLabel = simpbookReservierungenListe.translations.am;
                // Datum und Uhrzeit formatieren
                var dateObj = new Date(statusDate);
                if (!isNaN(dateObj.getTime())) {
                    var day = String(dateObj.getDate()).padStart(2, '0');
                    var month = String(dateObj.getMonth() + 1).padStart(2, '0');
                    var year = dateObj.getFullYear();
                    var hours = String(dateObj.getHours()).padStart(2, '0');
                    var minutes = String(dateObj.getMinutes()).padStart(2, '0');
                    var displayTime = hours + ':' + minutes;
                    var pluginLang = simpbookReservierungenListe.currentLanguage;
                    if (pluginLang === 'en_US_AMPM') {
                        var hour = parseInt(hours, 10);
                        var ampm = hour >= 12 ? 'PM' : 'AM';
                        var hour12 = hour % 12;
                        if (hour12 === 0) hour12 = 12;
                        displayTime = hour12 + ':' + minutes + ' ' + ampm;
                    }
                    var displayDate = day + '.' + month + '.' + year;
                    var pluginLang = simpbookReservierungenListe.currentLanguage;
                    if (pluginLang === 'en_US_AMPM') {
                        var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
                        displayDate = monthNames[dateObj.getMonth()] + ' ' + day + ', ' + year;
                    }
                    statusDateValue = displayDate + ' ' + simpbookReservierungenListe.translations.at + ' ' + displayTime;
                } else {
                    // Falls Datum nicht als Date geparst werden kann, direkt anzeigen
                    statusDateValue = statusDate;
                }
                $('#modal-status-date-label').text(statusDateLabel);
                $('#modal-status-date-value').text(statusDateValue);
                $('#modal-status-date').show();
            } else {
                $('#modal-status-date').hide();
            }
        } else {
            $('#modal-status-date').hide();
        }

        // Aktionen generieren
        var actionsHtml = '';
        if (reservierungData.storniert == 0) {
            actionsHtml += '<a href="' + buildActionUrl('simpbook_status_aendern', 'BESTÄTIGT') + '" onclick="return statusAendern(this.href, \'' + simpbookReservierungenListe.translations.confirmBooking + '\')" class="button button-primary button-bestaetigen">';
            actionsHtml += '<span class="dashicons dashicons-yes-alt"></span>' + simpbookReservierungenListe.translations.bestaetigen + '</a>';

            actionsHtml += '<a href="' + buildActionUrl('simpbook_status_aendern', 'ABGELEHNT') + '" onclick="return statusAendern(this.href, \'' + simpbookReservierungenListe.translations.rejectBooking + '\')" class="button button-ablehnen">';
            actionsHtml += '<span class="dashicons dashicons-dismiss"></span>' + simpbookReservierungenListe.translations.ablehnen + '</a>';
        }

        actionsHtml += '<a href="' + buildActionUrl('bearbeiten', null) + '" class="button">';
        actionsHtml += '<span class="dashicons dashicons-edit"></span>' + simpbookReservierungenListe.translations.bearbeiten + '</a>';

        actionsHtml += '<button class="button nachricht-senden-btn-modal" data-email="' + reservierungData.email + '" data-name="' + reservierungData.name + '">';
        actionsHtml += '<span class="dashicons dashicons-email"></span>' + simpbookReservierungenListe.translations.sendMessage + '</button>';

        actionsHtml += '<a href="' + buildActionUrl('loeschen', null) + '" class="button button-link-delete modal-loeschen-btn" data-confirm-message="' + simpbookReservierungenListe.translations.confirmDelete + '">';
        actionsHtml += '<span class="dashicons dashicons-trash"></span>' + simpbookReservierungenListe.translations.loeschen + '</a>';

        $('#modal-actions').html(actionsHtml);

        // Modal anzeigen
        if ($('#reservierung-detail-modal').length === 0) {
            console.error('Modal-Element nicht gefunden!');
            var errorMsg = simpbookReservierungenListe.translations.modalNotFound;
            if (typeof window.simpbookAlert === 'function') {
                window.simpbookAlert(errorMsg, simpbookReservierungenListe.translations.error);
            } else {
                alert(errorMsg);
            }
            return;
        }
        $('#reservierung-detail-modal').fadeIn(200);
    });

    // Mobile Karte klickbar machen
    $(document).on('click', '.reservierung-karte-clickable', function(e) {
        e.preventDefault();
        e.stopPropagation();

        var $card = $(this);
        var reservierungDataStr = $card.attr('data-reservierung-data');
        if (!reservierungDataStr) {
            console.error('Keine Reservierungsdaten gefunden');
            return;
        }

        var reservierungData = JSON.parse(reservierungDataStr);
        currentReservierungId = reservierungData.id;

        // Modal mit Daten füllen
        $('#modal-name').text(reservierungData.name || '-');
        $('#modal-email').text(reservierungData.email || '-');
        $('#modal-telefon').text(reservierungData.telefon || '-');
        $('#modal-datum').text(reservierungData.datum || '-');
        $('#modal-uhrzeit').text(reservierungData.uhrzeit || '-');
        $('#modal-dienstleistung').text(reservierungData.dienstleistung || '-');
        
        // Mitarbeiter-Dropdown befüllen
        var mitarbeiterId = reservierungData.mitarbeiter_id || '0';
        var $mitarbeiterSelect = $('#modal-mitarbeiter-select');
        $mitarbeiterSelect.empty();
        
        // Standard-Option "Kein bestimmter Mitarbeiter"
        var defaultText = simpbookReservierungenListe.translations.noSpecificEmployee || 'Kein bestimmter Mitarbeiter';
        $mitarbeiterSelect.append('<option value="0">' + defaultText + '</option>');
        
        var currentMitarbeiterFound = false;
        
        // Verfügbare Mitarbeiter hinzufügen
        if (reservierungData.verfuegbare_mitarbeiter && Array.isArray(reservierungData.verfuegbare_mitarbeiter)) {
            $.each(reservierungData.verfuegbare_mitarbeiter, function(index, ma) {
                var isSelected = (ma.id == mitarbeiterId);
                if (isSelected) currentMitarbeiterFound = true;
                $mitarbeiterSelect.append('<option value="' + ma.id + '"' + (isSelected ? ' selected' : '') + '>' + ma.name + '</option>');
            });
        }
        
        // Wenn der aktuelle Mitarbeiter nicht in der Liste ist (z.B. weil geblockt), trotzdem anzeigen
        if (!currentMitarbeiterFound && mitarbeiterId != '0' && reservierungData.mitarbeiter && reservierungData.mitarbeiter !== '-') {
             $mitarbeiterSelect.append('<option value="' + mitarbeiterId + '" selected>' + reservierungData.mitarbeiter + '</option>');
        } else if (!currentMitarbeiterFound && mitarbeiterId == '0') {
            $mitarbeiterSelect.val('0');
        }
        
        $mitarbeiterSelect.attr('data-reservierung-id', reservierungData.id);
        
        $('#modal-nachricht').text(reservierungData.nachricht || '-');

        // Status-Badge
        var statusClass = 'status-ausstehend';
        var statusText = simpbookReservierungenListe.translations.ausstehend;
        if (reservierungData.status === 'BESTÄTIGT') {
            statusClass = 'status-bestätigt';
            statusText = simpbookReservierungenListe.translations.bestaetigt;
        } else if (reservierungData.status === 'ABGELEHNT' || reservierungData.status === 'STORNIERT') {
            statusClass = 'status-abgelehnt';
            statusText = reservierungData.status === 'STORNIERT' ? simpbookReservierungenListe.translations.storniert : simpbookReservierungenListe.translations.abgelehnt;
        }
        $('#modal-status-badge').html('<span class="status-badge ' + statusClass + '">' + statusText + '</span>');

        // Status-Datum anzeigen
        var statusDateLabel = '';
        var statusDateValue = '';
        var statusDate = reservierungData.status_geaendert_datum || reservierungData.erstellungsdatum || reservierungData.datum;

        if (statusDate && reservierungData.status && reservierungData.status !== 'AUSSTEHEND') {
            var statusTranslated = '';
            if (reservierungData.status === 'BESTÄTIGT') {
                statusTranslated = simpbookReservierungenListe.translations.bestaetigt;
            } else if (reservierungData.status === 'ABGELEHNT') {
                statusTranslated = simpbookReservierungenListe.translations.abgelehnt;
            } else if (reservierungData.status === 'STORNIERT' || reservierungData.storniert == 1) {
                statusTranslated = simpbookReservierungenListe.translations.storniert;
            }

            if (statusTranslated) {
                statusDateLabel = simpbookReservierungenListe.translations.am;
                // Datum und Uhrzeit formatieren
                var dateObj = new Date(statusDate);
                if (!isNaN(dateObj.getTime())) {
                    var day = String(dateObj.getDate()).padStart(2, '0');
                    var month = String(dateObj.getMonth() + 1).padStart(2, '0');
                    var year = dateObj.getFullYear();
                    var hours = String(dateObj.getHours()).padStart(2, '0');
                    var minutes = String(dateObj.getMinutes()).padStart(2, '0');
                    statusDateValue = day + '.' + month + '.' + year + ' ' + simpbookReservierungenListe.translations.um + ' ' + hours + ':' + minutes;
                } else {
                    // Falls Datum nicht als Date geparst werden kann, direkt anzeigen
                    statusDateValue = statusDate;
                }
                $('#modal-status-date-label').text(statusDateLabel);
                $('#modal-status-date-value').text(statusDateValue);
                $('#modal-status-date').show();
            } else {
                $('#modal-status-date').hide();
            }
        } else {
            $('#modal-status-date').hide();
        }

        // Aktionen generieren
        var actionsHtml = '';
        if (reservierungData.storniert == 0) {
            actionsHtml += '<a href="' + buildActionUrl('simpbook_status_aendern', 'BESTÄTIGT') + '" onclick="return statusAendern(this.href, \'' + simpbookReservierungenListe.translations.confirmBooking + '\')" class="button button-primary button-bestaetigen">';
            actionsHtml += '<span class="dashicons dashicons-yes-alt"></span>' + simpbookReservierungenListe.translations.bestaetigen + '</a>';

            actionsHtml += '<a href="' + buildActionUrl('simpbook_status_aendern', 'ABGELEHNT') + '" onclick="return statusAendern(this.href, \'' + simpbookReservierungenListe.translations.rejectBooking + '\')" class="button button-ablehnen">';
            actionsHtml += '<span class="dashicons dashicons-dismiss"></span>' + simpbookReservierungenListe.translations.ablehnen + '</a>';
        }

        actionsHtml += '<a href="' + buildActionUrl('bearbeiten', null) + '" class="button">';
        actionsHtml += '<span class="dashicons dashicons-edit"></span>' + simpbookReservierungenListe.translations.bearbeiten + '</a>';

        actionsHtml += '<button class="button nachricht-senden-btn-modal" data-email="' + reservierungData.email + '" data-name="' + reservierungData.name + '">';
        actionsHtml += '<span class="dashicons dashicons-email"></span>' + simpbookReservierungenListe.translations.sendMessage + '</button>';

        actionsHtml += '<a href="' + buildActionUrl('loeschen', null) + '" class="button button-link-delete modal-loeschen-btn" data-confirm-message="' + simpbookReservierungenListe.translations.confirmDelete + '">';
        actionsHtml += '<span class="dashicons dashicons-trash"></span>' + simpbookReservierungenListe.translations.loeschen + '</a>';

        $('#modal-actions').html(actionsHtml);

        // Modal anzeigen
        $('#reservierung-detail-modal').fadeIn(200);
    });

    // URL für Aktionen bauen
    function buildActionUrl(action, status) {
        var $row = $('.reservierung-row-clickable[data-reservierung-id="' + currentReservierungId + '"]');
        var $card = $('.reservierung-karte-clickable[data-reservierung-id="' + currentReservierungId + '"]');
        var $element = $row.length > 0 ? $row : $card;
        var url = baseUrl;
        var params = {
            'simpbook_aktion': action,
            'simpbook_id': currentReservierungId,
            'simpbook_seite_nr': currentPage,
            'simpbook_order': currentOrder,
            'simpbook_direction': currentDirection,
            'simpbook_filter': currentFilter
        };

        if (status) {
            params.simpbook_status = status;
        }

        // Nonce aus data-Attribut holen (für Desktop oder Mobile)
        if (action === 'simpbook_status_aendern') {
            params.simpbook_nonce = $element.attr('data-status-nonce') || $element.data('status-nonce');
        } else if (action === 'stornieren') {
            params.simpbook_nonce = $element.attr('data-stornieren-nonce') || $element.data('stornieren-nonce');
        } else if (action === 'bearbeiten') {
            params.simpbook_nonce = $element.attr('data-bearbeiten-nonce') || $element.data('bearbeiten-nonce');
        } else if (action === 'loeschen') {
            params.simpbook_nonce = $element.attr('data-loeschen-nonce') || $element.data('loeschen-nonce');
        }

        // Falls keine Nonce gefunden, kann die Aktion nicht ausgeführt werden
        if (!params.simpbook_nonce) {
            console.warn('Keine Nonce für Aktion gefunden:', action);
            return false;
        }

        return url + '&' + $.param(params);
    }

    // Modal schließen
    $('.reservierung-modal-close, .reservierung-modal-overlay').on('click', function() {
        $('#reservierung-detail-modal').fadeOut(200);
    });

    // ESC-Taste zum Schließen
    $(document).on('keydown', function(e) {
        if (e.key === 'Escape' && $('#reservierung-detail-modal').is(':visible')) {
            $('#reservierung-detail-modal').fadeOut(200);
        }
    });

    // Event-Handler für Löschen-Button im Modal (mit simpbookConfirm)
    $(document).on('click', '.modal-loeschen-btn', function(e) {
        e.preventDefault();
        var $btn = $(this);
        var deleteUrl = $btn.attr('href');
        var confirmMessage = $btn.attr('data-confirm-message') || simpbookReservierungenListe.translations.confirmDelete;
        var confirmTitle = simpbookReservierungenListe.translations.confirmation;

        if (typeof window.simpbookConfirm === 'function') {
            window.simpbookConfirm(confirmMessage, confirmTitle).then(function(confirmed) {
                if (confirmed) {
                    fetch(deleteUrl)
                        .then(response => {
                            if (response.ok) window.location.reload();
                            else {
                                var errorMsg = simpbookReservierungenListe.translations.deleteError;
                                if (typeof window.simpbookAlert === 'function') {
                                    window.simpbookAlert(errorMsg, simpbookReservierungenListe.translations.error);
                                } else {
                                    alert(errorMsg);
                                }
                            }
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            var errorMsg = simpbookReservierungenListe.translations.generalError;
                            if (typeof window.simpbookAlert === 'function') {
                                window.simpbookAlert(errorMsg, simpbookReservierungenListe.translations.error);
                            } else {
                                alert(errorMsg);
                            }
                        });
                }
            });
        } else {
            // Fallback zu Browser confirm
            if (confirm(confirmMessage)) {
                fetch(deleteUrl)
                    .then(response => {
                        if (response.ok) window.location.reload();
                        else alert(simpbookReservierungenListe.translations.deleteError);
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        alert(simpbookReservierungenListe.translations.generalError);
                    });
            }
        }
    });

    // Nachricht senden Button im Modal
    $(document).on('click', '.nachricht-senden-btn-modal', function(e) {
        e.preventDefault();
        e.stopPropagation();
        var email = $(this).data('email');
        var name = $(this).data('name');
        $('#empfaenger-email').val(email);
        $('#empfaenger-name').text(name);
        $('#reservierung-detail-modal').fadeOut(200);
        setTimeout(function() {
            $('#nachrichten-modal').show();
        }, 250);
    });

    $('.nachricht-senden-btn').click(function() {
        var email = $(this).data('email');
        var name = $(this).data('name');
        $('#empfaenger-email').val(email);
        $('#empfaenger-name').text(name);
        $('#nachrichten-modal').show();
    });
    
    // Close button für Nachrichtenmodal (spezifisch für #nachrichten-modal)
    $('#nachrichten-modal').on('click', '.close', function() { 
        $('#nachrichten-modal').hide(); 
    });
    
    $(window).click(function(event) { 
        if (event.target.id === 'nachrichten-modal') { 
            $('#nachrichten-modal').hide(); 
        } 
    });
    $('#nachrichten-form').submit(function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        $.ajax({
            url: simpbookReservierungenListe.ajaxUrl, type: 'POST',
            data: { action: 'simpbook_sende_nachricht_an_gast', simpbook_form_data: formData, simpbook_nonce: $('#nachricht_nonce').val() },
            beforeSend: function() { $('#nachrichten-form button').prop('disabled', true).text(simpbookReservierungenListe.translations.sending); },
            success: function(response) {
                if (response.success) {
                    var successMsg = simpbookReservierungenListe.translations.messageSent;
                    if (typeof window.simpbookAlert === 'function') {
                        window.simpbookAlert(successMsg, simpbookReservierungenListe.translations.success);
                    } else {
                        alert(successMsg);
                    }
                    $('#nachrichten-modal').hide();
                    $('#nachrichten-form')[0].reset();
                } else {
                    var errorMsg = simpbookReservierungenListe.translations.errorColon + response.data;
                    if (typeof window.simpbookAlert === 'function') {
                        window.simpbookAlert(errorMsg, simpbookReservierungenListe.translations.error);
                    } else {
                        alert(errorMsg);
                    }
                }
            },
            error: function() {
                var errorMsg = simpbookReservierungenListe.translations.generalErrorRetry;
                if (typeof window.simpbookAlert === 'function') {
                    window.simpbookAlert(errorMsg, simpbookReservierungenListe.translations.error);
                } else {
                    alert(errorMsg);
                }
            },
            complete: function() { $('#nachrichten-form button').prop('disabled', false).text(simpbookReservierungenListe.translations.sendMessage); }
        });
    });
    
    // ALTE checkScreenSize() Funktion entfernt - wird jetzt von View Toggle System gehandhabt
    // Die View-Umschaltung erfolgt über den Toggle-Button und localStorage am Anfang der Datei

    // Bulk Selection Funktionalität - Nur wenn Checkboxen vorhanden sind
    console.log('Bulk Actions Check:', simpbookReservierungenListe.hasBulkActions);
    console.log('Select-All Checkbox gefunden:', $('#select-all-checkbox').length);
    console.log('Reservation Checkboxes gefunden:', $('.reservation-checkbox').length);
    
    if (simpbookReservierungenListe.hasBulkActions) {
        console.log('Bulk Actions werden initialisiert...');
        
        function updateSelectedCount() {
            const selectedCount = $('.reservation-checkbox:checked').length;
            console.log('Selected count:', selectedCount);
            $('#selected-count').text(selectedCount + ' ' + (selectedCount === 1 ? simpbookReservierungenListe.translations.selectedSingular : simpbookReservierungenListe.translations.selectedPlural));

            if (selectedCount > 0) {
                $('#bulk-actions-container').show();
            } else {
                $('#bulk-actions-container').hide();
            }
        }

        // Select All Checkbox
        $('#select-all-checkbox').on('change', function() {
            console.log('Select-All Checkbox geklickt');
            const isChecked = $(this).prop('checked');
            console.log('Checked Status:', isChecked);
            $('.reservation-checkbox').prop('checked', isChecked);
            updateSelectedCount();
        });

        // Individual Checkboxes
        $(document).on('change', '.reservation-checkbox', function(e) {
            console.log('Individual Checkbox geändert');
            updateSelectedCount();

            // Update Select All Checkbox
            const allChecked = $('.reservation-checkbox').length === $('.reservation-checkbox:checked').length;
            $('#select-all-checkbox').prop('checked', allChecked);
        });
        
        console.log('Bulk Actions Event Handler registriert');
        
        // Initial Count setzen
        updateSelectedCount();

        // Bulk Delete
        console.log('Bulk Delete Button gefunden:', $('#bulk-delete-btn').length);
        $('#bulk-delete-btn').on('click', function() {
            console.log('Bulk Delete Button geklickt');
            const selectedIds = [];
            $('.reservation-checkbox:checked').each(function() {
                selectedIds.push($(this).data('id'));
            });
            
            console.log('Ausgewählte IDs:', selectedIds);

            if (selectedIds.length === 0) {
                if (typeof window.simpbookAlert === 'function') {
                    window.simpbookAlert(simpbookReservierungenListe.translations.selectAtLeastOne, simpbookReservierungenListe.translations.hint);
                } else {
                    alert(simpbookReservierungenListe.translations.selectAtLeastOne);
                }
                return;
            }

            var deleteMessage = simpbookReservierungenListe.translations.confirmBulkDelete;
            var deleteTitle = simpbookReservierungenListe.translations.deleteBookings;

            if (typeof window.simpbookConfirm === 'function') {
                window.simpbookConfirm(deleteMessage, deleteTitle).then(function(confirmed) {
                    if (confirmed) {
                        performBulkDelete(selectedIds);
                    }
                });
            } else {
                if (confirm(deleteMessage)) {
                    performBulkDelete(selectedIds);
                }
            }
        });

        function performBulkDelete(selectedIds) {
            // AJAX Request zum Löschen
            $.ajax({
                url: simpbookReservierungenListe.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'simpbook_delete_multiple_reservierungen',
                    simpbook_ids: selectedIds,
                    simpbook_nonce: simpbookReservierungenListe.bulkDeleteNonce
                },
                success: function(response) {
                    if (response.success) {
                        // Seite neu laden
                        location.reload();
                    } else {
                        var errorMsg = simpbookReservierungenListe.translations.deleteErrorPrefix + (response.data || '');
                        if (typeof window.simpbookAlert === 'function') {
                            window.simpbookAlert(errorMsg, simpbookReservierungenListe.translations.error);
                        } else {
                            alert(errorMsg);
                        }
                    }
                },
                error: function() {
                    var errorMsg = simpbookReservierungenListe.translations.generalError;
                    if (typeof window.simpbookAlert === 'function') {
                        window.simpbookAlert(errorMsg, simpbookReservierungenListe.translations.error);
                    } else {
                        alert(errorMsg);
                    }
                }
            });
        }

    }
});

// Globale Funktionen für Status-Änderungen
function statusAendern(url, nachricht) {
    var confirmTitle = simpbookReservierungenListe.translations.confirmation;

    // Prüfe ob es sich um eine Bestätigung handelt (positive Aktion)
    // URL decodieren und nach BESTÄTIGT suchen
    var decodedUrl = decodeURIComponent(url);
    var isPositiveAction = decodedUrl.indexOf('BESTÄTIGT') !== -1;
    var confirmFunction = isPositiveAction ? window.simpbookConfirmPositive : window.simpbookConfirm;

    if (typeof confirmFunction === 'function') {
        confirmFunction(nachricht, confirmTitle).then(function(confirmed) {
            if (confirmed) {
                window.location.href = url;
            }
        });
    } else {
        // Fallback zu Browser confirm
        if (confirm(nachricht)) {
            window.location.href = url;
        }
    }
    return false;
}

function stornierenAendern(url, nachricht) {
    var confirmTitle = simpbookReservierungenListe.translations.confirmation;

    if (typeof window.simpbookConfirm === 'function') {
        window.simpbookConfirm(nachricht, confirmTitle).then(function(confirmed) {
            if (confirmed) {
                window.location.href = url;
            }
        });
    } else {
        // Fallback zu Browser confirm
        if (confirm(nachricht)) {
            window.location.href = url;
        }
    }
    return false;
}

// ============================================
// Mobile & Tablet Filter Toggle
// ============================================
jQuery(document).ready(function($) {
    var filterToggle = $('#simpbook-filter-toggle');
    var filterPanel = $('#simpbook-filter-panel');
    
    if (filterToggle.length && filterPanel.length) {
        // Toggle Filter Panel
        filterToggle.on('click', function(e) {
            e.preventDefault();
            
            var isExpanded = $(this).attr('aria-expanded') === 'true';
            
            // Toggle aria-expanded
            $(this).attr('aria-expanded', !isExpanded);
            
            // Toggle panel visibility
            filterPanel.toggleClass('show');
        });
        
        // Schließe Filter wenn außerhalb geklickt wird (nur auf Mobile)
        $(document).on('click', function(e) {
            if (window.innerWidth <= 782) {
                if (!$(e.target).closest('.reservierungen-filter-container').length) {
                    filterPanel.removeClass('show');
                    filterToggle.attr('aria-expanded', 'false');
                }
            }
        });
        
        // Verhindere Schließen wenn innerhalb des Panels geklickt wird
        filterPanel.on('click', function(e) {
            e.stopPropagation();
        });
    }
    
    // Mitarbeiter-Dropdown Änderung speichern
    $(document).on('change', '#modal-mitarbeiter-select', function() {
        var $select = $(this);
        var reservierungId = $select.attr('data-reservierung-id');
        var mitarbeiterId = $select.val();
        var $indicator = $('.simpbook-save-indicator');
        
        if (!reservierungId) {
            return;
        }
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'simpbook_update_reservierung_mitarbeiter',
                reservierung_id: reservierungId,
                mitarbeiter_id: mitarbeiterId,
                simpbook_nonce: simpbookReservierungenListe.updateMitarbeiterNonce
            },
            success: function(response) {
                if (response.success) {
                    // Zeige Speicher-Indikator
                    $indicator.fadeIn(200);
                    setTimeout(function() {
                        $indicator.fadeOut(400);
                    }, 2000);
                    
                    // Aktualisiere Tabelle
                    loadReservierungen();
                } else {
                    alert(response.data || 'Fehler beim Speichern des Mitarbeiters.');
                }
            },
            error: function() {
                alert('Fehler beim Speichern des Mitarbeiters.');
            }
        });
    });
});

