jQuery(document).ready(function($) {
    // Daten aus wp_localize_script
    var data = simpbookReservierungBearbeitenData;

    // AJAX-Konfiguration für Verfügbarkeitsprüfung
    var reservierungAjax = {
        ajax_url: data.ajaxUrl,
        times_nonce: data.timesNonce,
        simpbook_reservierung_id: data.reservierungId
    };

    // Wochentage-Konfiguration
    var wochentagZeiten = data.wochentagZeiten;
    var wochentagKeys = ['sonntag', 'montag', 'dienstag', 'mittwoch', 'donnerstag', 'freitag', 'samstag'];
    var zeitIntervall = data.zeitIntervall;

    // Array mit ausgeschlossenen Tagen
    var ausgeschlosseneTage = data.ausgeschlosseneTage;

    // Spezielle Tage-Konfiguration
    var spezielleTageKonfiguration = data.spezielleTageKonfiguration;

    // Datepicker-Übersetzungen
    var simpbookDatepickerTranslations = data.datepickerTranslations;

    // Übersetzungen
    var simpbookTranslations = data.translations;

    // Überprüfung, ob ein Wochentag für Reservierungen deaktiviert ist
    function isWochentagDeaktiviert(date) {
        var wochentag = wochentagKeys[date.getDay()]; // getDay() gibt 0 für Sonntag zurück
        return !wochentagZeiten[wochentag] || wochentagZeiten[wochentag]['aktiv'] !== '1';
    }

    // Funktion zum Formatieren des Datums für die Anzeige
    function formatDateForDisplay(date) {
        if (!date) return '';
        var day = date.getDate();
        var monthIndex = date.getMonth();
        var year = date.getFullYear();
        var monthName = simpbookDatepickerTranslations.monthNames[monthIndex];
        return day + '. ' + monthName + ' ' + year;
    }

    // Funktion zum Konvertieren des Anzeigeformats zurück zu dd.mm.yyyy
    function convertDisplayToDbFormat(displayText) {
        if (!displayText) return '';

        if (displayText.indexOf('.') !== -1 && displayText.indexOf('-') === -1) {
            var hasMonthName = false;
            for (var i = 0; i < simpbookDatepickerTranslations.monthNames.length; i++) {
                if (displayText.indexOf(simpbookDatepickerTranslations.monthNames[i]) !== -1) {
                    hasMonthName = true;
                    break;
                }
            }
            if (!hasMonthName) {
                return displayText;
            }
        }

        var parts = displayText.split('. ');
        if (parts.length >= 2) {
            var day = parts[0];
            var monthYear = parts[1].split(' ');
            if (monthYear.length >= 2) {
                var monthName = monthYear[0];
                var year = monthYear[1];

                var monthIndex = simpbookDatepickerTranslations.monthNames.indexOf(monthName);
                if (monthIndex === -1) {
                    monthIndex = simpbookDatepickerTranslations.monthNamesShort.indexOf(monthName);
                }
                if (monthIndex !== -1) {
                    var month = (monthIndex + 1).toString().padStart(2, '0');
                    return day.padStart(2, '0') + '.' + month + '.' + year;
                }
            }
        }
        return displayText;
    }

    // Datepicker konfigurieren
    var $datepicker = $(".datepicker");
    var savedDisplayFormat = null;
    var datepickerIsOpening = false;

    var dateFormat = 'dd.mm.yy';
    var firstDay = 1; // Montag
    if (simpbookDatepickerTranslations.currentLanguage === 'en_US_AMPM') {
        dateFormat = 'mm/dd/yy';
        firstDay = 0; // Sonntag
    }

    $datepicker.datepicker({
        dateFormat: dateFormat,
        minDate: null,
        firstDay: firstDay,
        monthNames: simpbookDatepickerTranslations.monthNames,
        monthNamesShort: simpbookDatepickerTranslations.monthNamesShort,
        dayNames: simpbookDatepickerTranslations.dayNames,
        dayNamesShort: simpbookDatepickerTranslations.dayNamesShort,
        dayNamesMin: simpbookDatepickerTranslations.dayNamesMin,
        beforeShow: function(input, inst) {
            datepickerIsOpening = true;
            var displayValue = $(input).val();
            if (displayValue && displayValue.indexOf('. ') !== -1) {
                savedDisplayFormat = displayValue;
                var dbFormat = convertDisplayToDbFormat(displayValue);
                if (dbFormat && dbFormat !== displayValue) {
                    var dateObj = $.datepicker.parseDate('dd.mm.yy', dbFormat);
                    if (dateObj) {
                        $(input).datepicker('setDate', dateObj);
                        $(input).val(dbFormat);
                    }
                }
            } else {
                savedDisplayFormat = null;
            }
            setTimeout(function() {
                datepickerIsOpening = false;
            }, 100);
        },
        onClose: function(dateText, inst) {
            var selectedDate = $(this).datepicker('getDate');
            if (selectedDate) {
                var displayFormat = formatDateForDisplay(selectedDate);
                $(this).val(displayFormat);
            } else if (savedDisplayFormat) {
                $(this).val(savedDisplayFormat);
            }
            savedDisplayFormat = null;
        },
        beforeShowDay: function(date) {
            var dateString = $.datepicker.formatDate('yy-mm-dd', date);
            var isExcluded = ($.inArray(dateString, ausgeschlosseneTage) != -1);
            var isDeaktiviert = isWochentagDeaktiviert(date);
            var cssClass = '';
            if (isExcluded) cssClass = 'ausgeschlossener-tag';
            if (isDeaktiviert) cssClass = 'deaktivierter-wochentag';
            return [!isExcluded && !isDeaktiviert, cssClass];
        },
        onSelect: function(dateText, inst) {
            var selectedDate = $(this).datepicker('getDate');
            if (!selectedDate) return;

            var dateStringYMD = $.datepicker.formatDate('yy-mm-dd', selectedDate);
            var wochentag = wochentagKeys[selectedDate.getDay()];

            var $input = $(this);
            setTimeout(function() {
                var displayFormat = formatDateForDisplay(selectedDate);
                $input.val(displayFormat);
            }, 10);

            generiereUhrzeiten(wochentag, dateStringYMD);
        }
    });

    $datepicker.on('change blur', function() {
        if (datepickerIsOpening) {
            return;
        }
        var currentValue = $(this).val();
        if (currentValue && currentValue.indexOf('.') !== -1 && currentValue.indexOf('. ') === -1) {
            var parts = currentValue.split('.');
            if (parts.length === 3) {
                var day = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10) - 1;
                var yearStr = parts[2];
                var year = (yearStr.length === 2) ? parseInt('20' + yearStr, 10) : parseInt(yearStr, 10);
                var date = new Date(year, month, day);
                if (date && !isNaN(date.getTime())) {
                    var displayFormat = formatDateForDisplay(date);
                    $(this).val(displayFormat);
                }
            }
        }
    });

    var initialValue = $datepicker.val();
    if (initialValue && initialValue.indexOf('.') !== -1) {
        var parts = initialValue.split('.');
        if (parts.length === 3) {
            var day = parseInt(parts[0], 10);
            var month = parseInt(parts[1], 10) - 1;
            var yearStr = parts[2];
            var year = (yearStr.length === 2) ? parseInt('20' + yearStr, 10) : parseInt(yearStr, 10);
            var initialDate = new Date(year, month, day);
            if (initialDate && !isNaN(initialDate.getTime())) {
                var displayFormat = formatDateForDisplay(initialDate);
                $datepicker.datepicker('setDate', initialDate);
                $datepicker.val(displayFormat);
            }
        }
    }

    $('form').on('submit', function(e) {
        var displayValue = $datepicker.val();
        if (!displayValue) return;
        var dbFormat = convertDisplayToDbFormat(displayValue);
        if (dbFormat) {
            var hasMonthName = false;
            for (var i = 0; i < simpbookDatepickerTranslations.monthNames.length; i++) {
                if (dbFormat.indexOf(simpbookDatepickerTranslations.monthNames[i]) !== -1) {
                    hasMonthName = true;
                    break;
                }
            }
            if (hasMonthName) {
                dbFormat = convertDisplayToDbFormat(dbFormat);
            }
        }
        if (dbFormat) {
            $datepicker.val(dbFormat);
        }
    });

    function normalizeTime(timeStr) {
        if (!timeStr) return '';
        if (timeStr.length > 5) {
            return timeStr.substring(0, 5);
        }
        return timeStr;
    }

    function generiereUhrzeiten(wochentag, dateStringYMD) {
        var $uhrzeit = $('#simpbook_uhrzeit');
        var currentUhrzeit = normalizeTime($uhrzeit.data('current-value') || '');
        var dienstleistungId = $('#simpbook_dienstleistung_id').val() || 0;
        var mitarbeiterId = $('#simpbook_mitarbeiter_id').val() || 0;

        $uhrzeit.empty();
        $uhrzeit.append('<option value="">-- ' + simpbookTranslations.lade_zeiten + ' --</option>');

        var dateInput = $('#simpbook_datum').val();
        var dateForAjax = dateInput;

        if (dateInput && dateInput.indexOf('. ') !== -1) {
            dateInput = convertDisplayToDbFormat(dateInput);
        }

        if (dateInput && dateInput.indexOf('.') !== -1) {
            var parts = dateInput.split('.');
            if (parts.length === 3) {
                var day = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10);
                var yearStr = parts[2];
                var year = (yearStr.length === 2) ? parseInt('20' + yearStr, 10) : parseInt(yearStr, 10);
                dateForAjax = day + '.' + month + '.' + year;
            }
        }

        if (dienstleistungId <= 0) {
            $uhrzeit.empty();
            $uhrzeit.append('<option value="">-- ' + simpbookTranslations.bitte_zuerst_dienstleistung + ' --</option>');
            return;
        }

        $.ajax({
            url: reservierungAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_available_times',
                simpbook_datum: dateForAjax,
                simpbook_dienstleistung_id: dienstleistungId,
                simpbook_mitarbeiter_id: mitarbeiterId,
                simpbook_exclude_simpbook_reservierung_id: reservierungAjax.simpbook_reservierung_id,
                simpbook_nonce: reservierungAjax.times_nonce
            },
            success: function(response) {
                if (response.success) {
                    var $options = $(response.data);
                    $uhrzeit.empty();
                    $options.each(function() {
                        var $option = $(this);
                        var optionValue = $option.val();
                        var optionText = $option.text();
                        var isDisabled = $option.is(':disabled');
                        var isSelected = (!isDisabled && normalizeTime(optionValue) === currentUhrzeit) ? 'selected' : '';

                        if (optionValue) {
                            $uhrzeit.append('<option value="' + optionValue + '" ' + (isDisabled ? 'disabled' : '') + ' ' + isSelected + '>' + optionText + '</option>');
                        } else {
                            $uhrzeit.append('<option value="">' + optionText + '</option>');
                        }
                    });
                    if (currentUhrzeit && !$uhrzeit.find('option[value="' + currentUhrzeit + '"]').length) {
                        $uhrzeit.append('<option value="' + currentUhrzeit + '" selected>' + currentUhrzeit + '</option>');
                    }
                } else {
                    $uhrzeit.empty();
                    $uhrzeit.append('<option value="">-- ' + (response.data || simpbookTranslations.fehler_beim_laden) + ' --</option>');
                    if (currentUhrzeit) {
                        $uhrzeit.append('<option value="' + currentUhrzeit + '" selected>' + currentUhrzeit + '</option>');
                    }
                }
            },
            error: function() {
                $uhrzeit.empty();
                $uhrzeit.append('<option value="">-- ' + simpbookTranslations.fehler_beim_laden + ' --</option>');
                if (currentUhrzeit) {
                    $uhrzeit.append('<option value="' + currentUhrzeit + '" selected>' + currentUhrzeit + '</option>');
                }
            }
        });
    }

    $('#simpbook_dienstleistung_id').change(function() {
        var dienstleistungId = $(this).val();
        var $mitarbeiterSelect = $('#simpbook_mitarbeiter_id');
        var $uhrzeitSelect = $('#simpbook_uhrzeit');

        $mitarbeiterSelect.empty();
        $mitarbeiterSelect.append('<option value="0">-- ' + simpbookTranslations.kein_bestimmter_mitarbeiter + ' --</option>');

        if (!dienstleistungId || dienstleistungId <= 0) {
            $mitarbeiterSelect.append('<option value="" disabled>' + simpbookTranslations.bitte_zuerst_dienstleistung + '</option>');
            $uhrzeitSelect.empty();
            $uhrzeitSelect.append('<option value="">-- ' + simpbookTranslations.bitte_zuerst_dienstleistung + ' --</option>');
            return;
        }

        $.ajax({
            url: reservierungAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_mitarbeiter_fuer_dienstleistung',
                simpbook_dienstleistung_id: dienstleistungId,
                simpbook_nonce: data.mitarbeiterNonce
            },
            success: function(response) {
                if (response.success && response.data && response.data.mitarbeiter && response.data.mitarbeiter.length > 0) {
                    $.each(response.data.mitarbeiter, function(index, mitarbeiter) {
                        var selected = '';
                        if (data.initialData.mitarbeiterId > 0 && mitarbeiter.id == data.initialData.mitarbeiterId) {
                            selected = ' selected';
                        }
                        $mitarbeiterSelect.append('<option value="' + mitarbeiter.id + '"' + selected + '>' + mitarbeiter.name + '</option>');
                    });
                } else {
                    $mitarbeiterSelect.append('<option value="0" selected>' + simpbookTranslations.kein_bestimmter_mitarbeiter + '</option>');
                }

                if ($('#simpbook_datum').val()) {
                    var selectedDate = $('.datepicker').datepicker('getDate');
                    if (selectedDate) {
                        var dateStringYMD = $.datepicker.formatDate('yy-mm-dd', selectedDate);
                        var wochentag = wochentagKeys[selectedDate.getDay()];
                        generiereUhrzeiten(wochentag, dateStringYMD);
                    }
                }
            },
            error: function() {
                $mitarbeiterSelect.append('<option value="0">' + simpbookTranslations.fehler_beim_laden + '</option>');
            }
        });
    });

    $('#simpbook_mitarbeiter_id').change(function() {
        if ($('#simpbook_datum').val() && $('#simpbook_dienstleistung_id').val()) {
            var selectedDate = $('.datepicker').datepicker('getDate');
            if (selectedDate) {
                var dateStringYMD = $.datepicker.formatDate('yy-mm-dd', selectedDate);
                var wochentag = wochentagKeys[selectedDate.getDay()];
                generiereUhrzeiten(wochentag, dateStringYMD);
            }
        }
    });

    // Initial Mitarbeiter laden
    if (data.initialData.dienstleistungId > 0) {
        (function() {
            var initialDienstleistungId = data.initialData.dienstleistungId;
            var initialMitarbeiterId = data.initialData.mitarbeiterId;

            var $mitarbeiterSelect = $('#simpbook_mitarbeiter_id');
            $mitarbeiterSelect.empty();
            $mitarbeiterSelect.append('<option value="0">-- ' + simpbookTranslations.kein_bestimmter_mitarbeiter + ' --</option>');

            $.ajax({
                url: reservierungAjax.ajax_url,
                type: 'POST',
                data: {
                    action: 'simpbook_get_mitarbeiter_fuer_dienstleistung',
                    simpbook_dienstleistung_id: initialDienstleistungId,
                    simpbook_nonce: data.mitarbeiterNonce
                },
                success: function(response) {
                    if (response.success && response.data && response.data.mitarbeiter && response.data.mitarbeiter.length > 0) {
                        $.each(response.data.mitarbeiter, function(index, mitarbeiter) {
                            var selected = (initialMitarbeiterId > 0 && mitarbeiter.id == initialMitarbeiterId) ? ' selected' : '';
                            $mitarbeiterSelect.append('<option value="' + mitarbeiter.id + '"' + selected + '>' + mitarbeiter.name + '</option>');
                        });
                        if (initialMitarbeiterId > 0 && !response.data.mitarbeiter.some(function(m) { return m.id == initialMitarbeiterId; })) {
                            $mitarbeiterSelect.append('<option value="' + initialMitarbeiterId + '" selected>' + simpbookTranslations.mitarbeiter_nicht_mehr_verfuegbar + '</option>');
                        }
                    } else {
                        if (initialMitarbeiterId > 0) {
                            $mitarbeiterSelect.append('<option value="' + initialMitarbeiterId + '" selected>' + simpbookTranslations.mitarbeiter_nicht_mehr_verfuegbar + '</option>');
                        } else {
                            $mitarbeiterSelect.append('<option value="0" selected>' + simpbookTranslations.kein_bestimmter_mitarbeiter + '</option>');
                        }
                    }
                },
                error: function() {
                    $mitarbeiterSelect.append('<option value="0">' + simpbookTranslations.fehler_beim_laden + '</option>');
                }
            });
        })();
    }

    // Initial Uhrzeiten laden
    if ($('#simpbook_datum').val()) {
        var dateInput = $('#simpbook_datum').val();
        var dateToParse = dateInput;

        if (dateInput && dateInput.indexOf('. ') !== -1) {
            dateToParse = convertDisplayToDbFormat(dateInput);
        }

        if (dateToParse && dateToParse.indexOf('.') !== -1) {
            var dateParts = dateToParse.split('.');
            if (dateParts.length === 3) {
                var day = parseInt(dateParts[0], 10);
                var month = parseInt(dateParts[1], 10) - 1;
                var yearStr = dateParts[2];
                var year = (yearStr.length === 2) ? parseInt('20' + yearStr, 10) : parseInt(yearStr, 10);
                var selectedDate = new Date(year, month, day);

                if (selectedDate && !isNaN(selectedDate.getTime())) {
                    var dateStringYMD = $.datepicker.formatDate('yy-mm-dd', selectedDate);
                    var wochentag = wochentagKeys[selectedDate.getDay()];

                    // Setze initiale Daten
                    if (data.initialData.uhrzeitRaw) {
                        $('#simpbook_uhrzeit').data('current-value', data.initialData.uhrzeitRaw);
                        $('#simpbook_uhrzeit').data('current-display', data.initialData.uhrzeitFormatiert);
                    }

                    generiereUhrzeiten(wochentag, dateStringYMD);
                }
            }
        }
    }
});

