jQuery(document).ready(function($) {
    // Zugriff auf die lokalisierten Daten
    var data = simpbookNeueReservierungData;

    // AJAX-Konfiguration
    var reservierungAjax = {
        ajax_url: data.ajax_url,
        times_nonce: data.times_nonce,
        mitarbeiter_nonce: data.mitarbeiter_nonce,
        simpbook_reservierung_id: 0 // Keine Reservierungs-ID für neue Reservierung
    };

    // Wochentage-Konfiguration
    var wochentagZeiten = data.wochentag_zeiten;
    var wochentagKeys = ['sonntag', 'montag', 'dienstag', 'mittwoch', 'donnerstag', 'freitag', 'samstag'];
    var zeitIntervall = parseInt(data.intervall);

    // Array mit ausgeschlossenen Tagen
    var ausgeschlosseneTage = data.ausgeschlossene_tage;

    // Spezielle Tage-Konfiguration
    var spezielleTageKonfiguration = data.spezielle_tage_konfiguration;

    // Datepicker-Übersetzungen
    var simpbookDatepickerTranslations = data.datepicker_translations;

    // Allgemeine Übersetzungen
    var simpbookTranslations = data.translations;

    // Überprüfung, ob ein Wochentag für Reservierungen deaktiviert ist
    function isWochentagDeaktiviert(date) {
        var wochentag = wochentagKeys[date.getDay()]; // getDay() gibt 0 für Sonntag zurück
        // Überprüfen, ob der Wochentag deaktiviert ist
        return !wochentagZeiten[wochentag] || wochentagZeiten[wochentag]['aktiv'] !== '1';
    }

    // Funktion zum Formatieren des Datums für die Anzeige (z.B. "17. Dezember 2025")
    function formatDateForDisplay(date) {
        if (!date) return '';
        var day = date.getDate();
        var monthIndex = date.getMonth();
        var year = date.getFullYear();
        var monthName = simpbookDatepickerTranslations.monthNames[monthIndex];
        return day + '. ' + monthName + ' ' + year;
    }

    // Funktion zum Konvertieren des Anzeigeformats zurück zu dd.mm.yyyy
    function convertDisplayToDbFormat(displayText) {
        // Format: "17. Dezember 2025" -> "17.12.2025"
        if (!displayText) return '';

        // Wenn bereits im Format dd.mm.yyyy oder dd.mm.yy (ohne Monatsnamen), direkt zurückgeben
        // Prüfe ob es Zahlen mit Punkten sind, nicht Monatsnamen
        if (displayText.indexOf('.') !== -1 && displayText.indexOf('-') === -1 && displayText.indexOf('. ') === -1) {
            // Prüfe ob es ein Monatsname enthalten ist (nicht nur Zahlen)
            var hasMonthName = false;
            for (var i = 0; i < simpbookDatepickerTranslations.monthNames.length; i++) {
                if (displayText.indexOf(simpbookDatepickerTranslations.monthNames[i]) !== -1) {
                    hasMonthName = true;
                    break;
                }
            }
            // Wenn kein Monatsname gefunden wurde, ist es bereits im richtigen Format
            if (!hasMonthName) {
                return displayText;
            }
        }

        // Versuche das Format mit Monatsnamen zu parsen
        var parts = displayText.split('. ');
        if (parts.length >= 2) {
            var day = parts[0];
            var monthYear = parts[1].split(' ');
            if (monthYear.length >= 2) {
                var monthName = monthYear[0];
                var year = monthYear[1];

                // Finde Monatsindex
                var monthIndex = simpbookDatepickerTranslations.monthNames.indexOf(monthName);
                if (monthIndex === -1) {
                    monthIndex = simpbookDatepickerTranslations.monthNamesShort.indexOf(monthName);
                }
                if (monthIndex !== -1) {
                    var month = (monthIndex + 1).toString().padStart(2, '0');
                    return day.padStart(2, '0') + '.' + month + '.' + year;
                }
            }
        }
        return displayText; // Fallback
    }

    // Datepicker konfigurieren
    var $datepicker = $(".datepicker");

    // Speichere das Anzeigeformat, damit wir es nach dem Schließen wiederherstellen können
    var savedDisplayFormat = null;
    var datepickerIsOpening = false; // Flag um zu verhindern, dass change-Handler während des Öffnens aktiv ist

    // Bestimme Datumsformat und firstDay basierend auf Sprache
    var dateFormat = data.dateFormat || 'dd.mm.yy';
    var firstDay = 1; // Montag
    if (simpbookDatepickerTranslations.currentLanguage === 'en_US_AMPM') {
        firstDay = 0; // Sonntag
    }

    // Variable um verfügbare Wochentage für die ausgewählte Dienstleistung zu speichern
    var availableWochentagForService = null;

    // Funktion zum Laden verfügbarer Wochentage für eine Dienstleistung
    function loadAvailableWochentagForService(serviceId) {
        if (!serviceId || serviceId <= 0) {
            availableWochentagForService = null;
            // Datepicker neu malen wenn verfügbar
            $datepicker.datepicker('refresh');
            return;
        }

        $.ajax({
            url: reservierungAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_available_dates_for_service',
                simpbook_dienstleistung_id: serviceId,
                simpbook_nonce: reservierungAjax.times_nonce
            },
            success: function(response) {
                if (response.success && response.data && response.data.wochentage) {
                    availableWochentagForService = [];
                    var tageListe = [];

                    $.each(response.data.wochentage, function(index, tag) {
                        availableWochentagForService.push(tag.key);
                        // Verwende direkt die Abkürzung aus der AJAX-Response
                        if (tag.abbr) {
                            tageListe.push(tag.abbr);
                        }
                    });

                    if (tageListe.length > 0) {
                        // Übersetzungsmeldung direkt einbauen
                        var messageText = simpbookTranslations.diese_dienstleistung_wird_nur_an_folgenden_tagen_angeboten || 'Diese Dienstleistung wird nur an folgenden Tagen angeboten: ';
                        var messageHTML = '<strong>' + messageText + tageListe.join(', ') + '</strong>';
                        $('#available-days-info').html(messageHTML).show();
                    } else {
                        $('#available-days-info').hide();
                    }
                } else {
                    availableWochentagForService = null;
                    $('#available-days-info').hide();
                }

                // Datepicker neu malen
                $datepicker.datepicker('refresh');
            }
        });
    }

    $datepicker.datepicker({
        dateFormat: dateFormat,
        minDate: 0, // Keine Termine in der Vergangenheit
        firstDay: firstDay,
        monthNames: simpbookDatepickerTranslations.monthNames,
        monthNamesShort: simpbookDatepickerTranslations.monthNamesShort,
        dayNames: simpbookDatepickerTranslations.dayNames,
        dayNamesShort: simpbookDatepickerTranslations.dayNamesShort,
        dayNamesMin: simpbookDatepickerTranslations.dayNamesMin,
        beforeShow: function(input, inst) {
            // Setze Flag, dass Datepicker geöffnet wird
            datepickerIsOpening = true;

            // Beim Öffnen des Datepickers: Anzeigeformat zurück zu dd-mm-yy konvertieren
            var displayValue = $(input).val();
            if (displayValue && displayValue.indexOf('. ') !== -1) {
                // Speichere das Anzeigeformat
                savedDisplayFormat = displayValue;
                // Es ist im Anzeigeformat, konvertiere zurück
                var dbFormat = convertDisplayToDbFormat(displayValue);
                if (dbFormat && dbFormat !== displayValue) {
                    // Setze das Datum im Datepicker (verwendet internes Format)
                    var dateObj = $.datepicker.parseDate('dd.mm.yy', dbFormat);
                    if (dateObj) {
                        $(input).datepicker('setDate', dateObj);
                        // Setze das DB-Format für den Datepicker
                        $(input).val(dbFormat);
                    }
                }
            } else {
                savedDisplayFormat = null;
            }

            // Reset Flag nach kurzer Verzögerung
            setTimeout(function() {
                datepickerIsOpening = false;
            }, 100);
        },
        onClose: function(dateText, inst) {
            // Beim Schließen des Datepickers
            var selectedDate = $(this).datepicker('getDate');
            if (selectedDate) {
                // Wenn ein Datum ausgewählt wurde, formatiere es im Anzeigeformat
                var displayFormat = formatDateForDisplay(selectedDate);
                $(this).val(displayFormat);
            } else if (savedDisplayFormat) {
                // Wenn kein Datum ausgewählt wurde, Anzeigeformat wiederherstellen
                $(this).val(savedDisplayFormat);
            }
            savedDisplayFormat = null;
        },
        beforeShowDay: function(date) {
            // Datum in das Format YYYY-MM-DD konvertieren
            var dateString = $.datepicker.formatDate('yy-mm-dd', date);

            // Überprüfen, ob das Datum in der Liste der ausgeschlossenen Tage ist
            var isExcluded = ($.inArray(dateString, ausgeschlosseneTage) != -1);

            // Überprüfen, ob der Wochentag deaktiviert ist
            var isDeaktiviert = isWochentagDeaktiviert(date);

            // NEUE LOGIK: Überprüfe ob der Wochentag für die ausgewählte Dienstleistung verfügbar ist
            var wochentag = wochentagKeys[date.getDay()];
            var serviceNotAvailable = false;
            if (availableWochentagForService !== null && availableWochentagForService.length > 0) {
                // Wenn verfügbare Wochentage für eine Dienstleistung gesetzt sind, prüfe ob dieser Wochentag dabei ist
                serviceNotAvailable = $.inArray(wochentag, availableWochentagForService) === -1;
            }

            // CSS-Klassen für Styling
            var cssClass = '';
            if (isExcluded) cssClass = 'ausgeschlossener-tag';
            if (isDeaktiviert) cssClass = 'deaktivierter-wochentag';
            if (serviceNotAvailable) cssClass = 'service-not-available';

            // Wenn true zurückgegeben wird, ist der Tag auswählbar, wenn false, dann nicht
            return [!isExcluded && !isDeaktiviert && !serviceNotAvailable, cssClass];
        },
        onSelect: function(dateText, inst) {
            // Datum im YYYY-MM-DD Format für die Prüfung spezieller Tage
            var selectedDate = $(this).datepicker('getDate');
            if (!selectedDate) return;

            var dateStringYMD = $.datepicker.formatDate('yy-mm-dd', selectedDate);
            var wochentag = wochentagKeys[selectedDate.getDay()];

            // Anzeigeformat setzen (z.B. "17. Dezember 2025")
            // Verwende setTimeout um sicherzustellen, dass der Datepicker das Datum gesetzt hat
            setTimeout(function() {
                var displayFormat = formatDateForDisplay(selectedDate);
                $datepicker.val(displayFormat);
            }, 10);

            // Laden der Mitarbeiter für diese Dienstleistung, wenn bereits eine ausgewählt wurde
            var selectedServiceId = $('#simpbook_dienstleistung_id').val();
            if (selectedServiceId && selectedServiceId > 0) {
                loadAvailableEmployees(selectedServiceId);
            }


            // Uhrzeiten für den ausgewählten Tag generieren (berücksichtigt spezielle Tage)
            generiereUhrzeiten(wochentag, dateStringYMD);
        }
    });

    // Event-Handler: Stelle das Anzeigeformat wieder her, wenn der Datepicker das Format ändert
    // Aber nur wenn der Datepicker nicht gerade geöffnet wird
    $datepicker.on('change blur', function() {
        // Überspringe, wenn Datepicker gerade geöffnet wird
        if (datepickerIsOpening) {
            return;
        }

        var currentValue = $(this).val();
        // Wenn das Format dd.mm.yyyy oder dd.mm.yy ist (nicht unser Anzeigeformat mit Monatsnamen), konvertiere es
        if (currentValue && currentValue.indexOf('.') !== -1 && currentValue.indexOf('. ') === -1) {
            // Format: dd.mm.yyyy oder dd.mm.yy
            var parts = currentValue.split('.');
            if (parts.length === 3) {
                var day = parseInt(parts[0], 10);
                var month = parseInt(parts[1], 10) - 1;
                var yearStr = parts[2];
                var year = (yearStr.length === 2) ? parseInt('20' + yearStr, 10) : parseInt(yearStr, 10);
                var date = new Date(year, month, day);
                if (date && !isNaN(date.getTime())) {
                    var displayFormat = formatDateForDisplay(date);
                    $(this).val(displayFormat);
                }
            }
        }
    });

    // Beim Laden der Seite: Initiales Datum sofort formatieren
    var initialValue = $datepicker.val();
    if (initialValue && initialValue.indexOf('.') !== -1) {
        // Versuche das Datum zu parsen (Format: dd.mm.yyyy oder dd.mm.yy)
        var parts = initialValue.split('.');
        if (parts.length === 3) {
            var day = parseInt(parts[0], 10);
            var month = parseInt(parts[1], 10) - 1; // Monate sind 0-basiert
            var yearStr = parts[2];
            // Unterstütze sowohl yy als auch yyyy
            var year = (yearStr.length === 2) ? parseInt('20' + yearStr, 10) : parseInt(yearStr, 10);
            var initialDate = new Date(year, month, day);
            if (initialDate && !isNaN(initialDate.getTime())) {
                var displayFormat = formatDateForDisplay(initialDate);
                // Setze das interne Datum für den Datepicker (wichtig für die Funktionalität)
                $datepicker.datepicker('setDate', initialDate);
                // Setze das Anzeigeformat (der change-Handler wird es auch setzen, aber wir machen es sofort)
                $datepicker.val(displayFormat);
            }
        }
    }

    // Beim Submit: Datum zurück zu dd.mm.yyyy konvertieren
    $('form').on('submit', function(e) {
        var displayValue = $datepicker.val();
        if (!displayValue) return;

        // Konvertiere Anzeigeformat (z.B. "16. Dezember 2025") zu dd.mm.yyyy
        var dbFormat = convertDisplayToDbFormat(displayValue);

        // Stelle sicher, dass das Format korrekt ist (dd.mm.yyyy oder dd.mm.yy)
        // Prüfe ob es noch im Anzeigeformat ist (enthält Monatsnamen)
        if (dbFormat) {
            var hasMonthName = false;
            for (var i = 0; i < simpbookDatepickerTranslations.monthNames.length; i++) {
                if (dbFormat.indexOf(simpbookDatepickerTranslations.monthNames[i]) !== -1) {
                    hasMonthName = true;
                    break;
                }
            }
            if (hasMonthName) {
                // Falls noch im Anzeigeformat, nochmal konvertieren
                dbFormat = convertDisplayToDbFormat(dbFormat);
            }
        }

        // Setze das DB-Format für den Submit (immer, auch wenn gleich)
        if (dbFormat) {
            $datepicker.val(dbFormat);
        }
    });

    // Funktion zum Generieren der Uhrzeiten basierend auf dem Wochentag und speziellen Tagen
    // Verwendet jetzt AJAX für Verfügbarkeitsprüfung
    function generiereUhrzeiten(wochentag, dateStringYMD) {
        loadAvailableTimes();
        return; // Alte Logik nicht mehr verwendet
    }

    // Funktion zum Laden der verfügbaren Zeiten über AJAX
    function loadAvailableTimes() {
        var $uhrzeit = $('#simpbook_uhrzeit');
        var $datum = $('#simpbook_datum');
        var $dienstleistung = $('#simpbook_dienstleistung_id');
        var $mitarbeiter = $('#simpbook_mitarbeiter_id');

        // Prüfe ob alle notwendigen Felder ausgefüllt sind
        var datumValue = $datum.val();
        var dienstleistungId = $dienstleistung.val();

        if (!datumValue || !dienstleistungId || dienstleistungId <= 0) {
            $uhrzeit.empty();
            $uhrzeit.append('<option value="">' + (simpbookTranslations.bitte_zuerst_datum_und_dienstleistung_auswaehlen || '-- Bitte Datum und Dienstleistung auswählen --') + '</option>');
            return;
        }

        // Zeige Lade-Status
        $uhrzeit.empty();
        $uhrzeit.append('<option value="">-- ' + (simpbookTranslations.lade_verfuegbare_zeiten || 'Lade verfügbare Zeiten...') + ' --</option>');

        // Datum konvertieren: Von Anzeigeformat (z.B. "17. Dezember 2025") zu d.m.Y Format
        var dateToSend = datumValue;
        if (datumValue && datumValue.indexOf('. ') !== -1) {
            // Es ist im Anzeigeformat, konvertiere zu d.m.Y
            dateToSend = convertDisplayToDbFormat(datumValue);
        }

        // Wenn es noch nicht im richtigen Format ist, versuche es zu parsen
        if (dateToSend && dateToSend.indexOf('.') !== -1) {
            var parts = dateToSend.split('.');
            if (parts.length === 3) {
                // Format: dd.mm.yyyy oder dd.mm.yy
                var day = parts[0].padStart(2, '0');
                var month = parts[1].padStart(2, '0');
                var year = parts[2];
                if (year.length === 2) {
                    year = '20' + year;
                }
                dateToSend = day + '.' + month + '.' + year;
            }
        }

        // AJAX-Request
        $.ajax({
            url: reservierungAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_available_times',
                simpbook_datum: dateToSend,
                simpbook_dienstleistung_id: dienstleistungId,
                simpbook_mitarbeiter_id: $mitarbeiter.val() || 0,
                simpbook_exclude_simpbook_reservierung_id: 0, // Für neue Reservierung immer 0
                simpbook_nonce: reservierungAjax.times_nonce
            },
            success: function(response) {
                if (response.success) {
                    // HTML-Optionen aus der Antwort parsen
                    var $options = $(response.data);
                    $uhrzeit.empty();

                    // Optionen hinzufügen
                    $options.each(function() {
                        var $option = $(this);
                        var optionValue = $option.val();
                        var optionText = $option.text();
                        var isDisabled = $option.is(':disabled');

                        if (optionValue) {
                            $uhrzeit.append('<option value="' + optionValue + '" ' + (isDisabled ? 'disabled' : '') + '>' + optionText + '</option>');
                        } else {
                            // Erste Option (Uhrzeit wählen)
                            $uhrzeit.append('<option value="">' + optionText + '</option>');
                        }
                    });
                } else {
                    $uhrzeit.empty();
                    $uhrzeit.append('<option value="">-- ' + (response.data || simpbookTranslations.fehler_beim_laden || 'Fehler beim Laden') + ' --</option>');
                }
            },
            error: function() {
                $uhrzeit.empty();
                $uhrzeit.append('<option value="">-- ' + (simpbookTranslations.fehler_beim_laden_der_zeiten || 'Fehler beim Laden der Zeiten') + ' --</option>');
            }
        });
    }

    // Funktion zum Laden der verfügbaren Mitarbeiter für Dienstleistung und Datum
    function loadAvailableEmployees(serviceId) {
        var $mitarbeiterSelect = $('#simpbook_mitarbeiter_id');
        var datumValue = $('#simpbook_datum').val();

        // Gebe den aktuell ausgewählten Mitarbeiter aus
        var currentEmployeeId = $mitarbeiterSelect.val();

        // Nur Mitarbeiter laden, wenn Service und Datum ausgewählt sind
        if (!serviceId || serviceId <= 0 || !datumValue) {
            // Service ist ausgewählt aber kein Datum - alle Mitarbeiter zeigen
            return;
        }

        // Datum konvertieren
        var dateToSend = datumValue;
        if (datumValue && datumValue.indexOf('. ') !== -1) {
            dateToSend = convertDisplayToDbFormat(datumValue);
        }

        // Format normalisieren
        if (dateToSend && dateToSend.indexOf('.') !== -1) {
            var parts = dateToSend.split('.');
            if (parts.length === 3) {
                var day = parts[0].padStart(2, '0');
                var month = parts[1].padStart(2, '0');
                var year = parts[2];
                if (year.length === 2) {
                    year = '20' + year;
                }
                dateToSend = day + '.' + month + '.' + year;
            }
        }

        // AJAX zum Laden von verfügbaren Mitarbeitern für Service + Datum
        $.ajax({
            url: reservierungAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_available_employees_for_service_date',
                simpbook_dienstleistung_id: serviceId,
                simpbook_datum: dateToSend,
                simpbook_nonce: reservierungAjax.mitarbeiter_nonce
            },
            success: function(response) {
                if (response.success && response.data && response.data.mitarbeiter) {
                    var employees = response.data.mitarbeiter;
                    var selectedValue = '0'; // Default: Kein bestimmter Mitarbeiter oder erster verfügbarer
                    var hasEmployeeWithoutCustomHours = response.data.has_employee_without_custom_hours !== undefined ? response.data.has_employee_without_custom_hours : true; // Fallback

                    // Setze den Dropdown neu
                    $mitarbeiterSelect.empty();

                    // Option für "Kein bestimmter Mitarbeiter" nur anzeigen, wenn:
                    // 1. Mehr als 1 Mitarbeiter verfügbar ist UND
                    // 2. Mindestens einer dieser Mitarbeiter KEINE individuellen Arbeitszeiten hat
                    if (employees.length > 1 && hasEmployeeWithoutCustomHours) {
                        $mitarbeiterSelect.append('<option value="0">-- ' + (simpbookTranslations.kein_bestimmter_mitarbeiter || 'Kein bestimmter Mitarbeiter') + ' --</option>');
                        selectedValue = '0'; // Default: Kein bestimmter Mitarbeiter
                    }

                    if (employees.length > 0) {
                        $.each(employees, function(index, mitarbeiter) {
                            var optionHtml = '<option value="' + mitarbeiter.id + '">' + mitarbeiter.name;
                            if (mitarbeiter.notice) {
                                optionHtml += ' (' + mitarbeiter.notice + ')';
                            }
                            optionHtml += '</option>';
                            $mitarbeiterSelect.append(optionHtml);

                            // Wenn nur ein Mitarbeiter verfügbar ist, wähle ihn aus (nicht 0)
                            if (employees.length === 1) {
                                selectedValue = mitarbeiter.id;
                            }
                        });

                        // Setze Auswahl
                        if (currentEmployeeId && employees.some(function(e) { return e.id == currentEmployeeId; })) {
                            $mitarbeiterSelect.val(currentEmployeeId);
                        } else {
                            $mitarbeiterSelect.val(selectedValue);
                        }
                    } else {
                        // Keine Mitarbeiter verfügbar
                        $mitarbeiterSelect.append('<option value="" disabled>' + (simpbookTranslations.keine_mitarbeiter_verfuegbar || 'Keine Mitarbeiter verfügbar') + '</option>');
                    }

                    // Zeiten neu laden
                    loadAvailableTimes();
                } else {
                    // Fehler - leere Liste anzeigen
                    $mitarbeiterSelect.empty();
                    $mitarbeiterSelect.append('<option value="0">-- ' + (simpbookTranslations.fehler_beim_laden_der_mitarbeiter || 'Fehler beim Laden der Mitarbeiter') + ' --</option>');
                }
            },
            error: function() {
                $mitarbeiterSelect.empty();
                $mitarbeiterSelect.append('<option value="0">-- ' + (simpbookTranslations.fehler_beim_laden_der_mitarbeiter || 'Fehler beim Laden der Mitarbeiter') + ' --</option>');
            }
        });
    }


    // Bei Änderung des Datums: Verfügbare Mitarbeiter neu laden (wenn Dienstleistung ausgewählt)
    $('#simpbook_datum').change(function() {
        var selectedServiceId = $('#simpbook_dienstleistung_id').val();
        if (selectedServiceId && selectedServiceId > 0) {
            loadAvailableEmployees(selectedServiceId);
        }
    });

    // Bei Änderung der Dienstleistung: Verfügbare Wochentage laden und Datepicker aktualisieren
    $('#simpbook_dienstleistung_id').change(function() {
        var dienstleistungId = $(this).val();
        var $mitarbeiterSelect = $('#simpbook_mitarbeiter_id');
        var $uhrzeitSelect = $('#simpbook_uhrzeit');
        var $datumField = $('#simpbook_datum');

        // Mitarbeiter-Dropdown zurücksetzen
        $mitarbeiterSelect.empty();
        $mitarbeiterSelect.append('<option value="0">-- ' + (simpbookTranslations.kein_bestimmter_mitarbeiter || 'Kein bestimmter Mitarbeiter') + ' --</option>');

        if (!dienstleistungId || dienstleistungId <= 0) {
            $mitarbeiterSelect.append('<option value="" disabled>' + (simpbookTranslations.bitte_zuerst_dienstleistung_auswaehlen || 'Bitte zuerst Dienstleistung auswählen') + '</option>');
            $uhrzeitSelect.empty();
            $uhrzeitSelect.append('<option value="">-- ' + (simpbookTranslations.bitte_zuerst_dienstleistung_auswaehlen || 'Bitte zuerst Dienstleistung auswählen') + ' --</option>');

            // Datum zurücksetzen und Datepicker deaktivieren
            $datumField.val('');
            $datumField.datepicker('disable');
            loadAvailableWochentagForService(null);
            return;
        }

        // Aktiviere Datepicker
        $datumField.datepicker('enable');

        // Lade verfügbare Wochentage für diese Dienstleistung
        loadAvailableWochentagForService(dienstleistungId);

        // Mitarbeiter für diese Dienstleistung laden
        $.ajax({
            url: reservierungAjax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_mitarbeiter_fuer_dienstleistung',
                simpbook_dienstleistung_id: dienstleistungId,
                simpbook_nonce: reservierungAjax.mitarbeiter_nonce
            },
            success: function(response) {
                if (response.success && response.data && response.data.mitarbeiter && response.data.mitarbeiter.length > 0) {
                    $.each(response.data.mitarbeiter, function(index, mitarbeiter) {
                        $mitarbeiterSelect.append('<option value="' + mitarbeiter.id + '">' + mitarbeiter.name + '</option>');
                    });
                } else {
                    // Keine Mitarbeiter vorhanden - das ist OK, dann wird kein Mitarbeiter zugewiesen
                    $mitarbeiterSelect.append('<option value="0" selected>' + (simpbookTranslations.kein_bestimmter_mitarbeiter || 'Kein bestimmter Mitarbeiter') + '</option>');
                }

                // Uhrzeiten neu laden wenn Datum bereits ausgewählt
                if ($('#simpbook_datum').val()) {
                    loadAvailableTimes();
                }
            },
            error: function() {
                $mitarbeiterSelect.append('<option value="0">' + (simpbookTranslations.fehler_beim_laden_der_mitarbeiter || 'Fehler beim Laden der Mitarbeiter') + '</option>');
            }
        });
    });

    // Bei Änderung des Mitarbeiters Uhrzeiten neu laden
    $('#simpbook_mitarbeiter_id').change(function() {
        if ($('#simpbook_datum').val() && $('#simpbook_dienstleistung_id').val()) {
            loadAvailableTimes();
        }
    });

    // Initial Uhrzeiten laden, falls bereits ein Datum ausgewählt ist
    if ($('#simpbook_datum').val()) {
        var dateInput = $('#simpbook_datum').val();
        var dateToParse = dateInput;
        // Wenn es im Anzeigeformat ist, konvertiere zu dd.mm.yyyy
        if (dateInput && dateInput.indexOf('. ') !== -1) {
            dateToParse = convertDisplayToDbFormat(dateInput);
        }
        // Versuche das Datum zu parsen (Format: dd.mm.yyyy oder dd.mm.yy)
        if (dateToParse && dateToParse.indexOf('.') !== -1) {
            var dateParts = dateToParse.split('.');
            if (dateParts.length === 3) {
                // Konvertiere dd.mm.yyyy zu Date-Objekt
                var day = parseInt(dateParts[0], 10);
                var month = parseInt(dateParts[1], 10) - 1; // Monate sind 0-basiert
                var yearStr = dateParts[2];
                var year = (yearStr.length === 2) ? parseInt('20' + yearStr, 10) : parseInt(yearStr, 10);
                var selectedDate = new Date(year, month, day);

                if (selectedDate && !isNaN(selectedDate.getTime())) {
                    // Datum im YYYY-MM-DD Format für die Prüfung spezieller Tage
                    var dateStringYMD = $.datepicker.formatDate('yy-mm-dd', selectedDate);
                    var wochentag = wochentagKeys[selectedDate.getDay()];
                    generiereUhrzeiten(wochentag, dateStringYMD);
                }
            }
        }
    }
    // Show/hide email checkbox based on status
    $('#status').on('change', function() {
        if ($(this).val() === 'BESTÄTIGT') {
            $('#send_email_row').show();
        } else {
            $('#send_email_row').hide();
        }
    }).trigger('change'); // Trigger on page load to set initial state

});

