jQuery(document).ready(function($) {
    // ==========================================
    // Suchfunktionalität
    // ==========================================
    var searchTimeout;
    var $searchInput = $('#mitarbeiter-search-input');
    var $clearBtn = $('#clear-search-btn-mitarbeiter');
    
    // Suche durchführen
    function performSearch() {
        var searchTerm = $searchInput.val().toLowerCase().trim();
        
        // Clear-Button anzeigen/ausblenden
        if (searchTerm.length > 0) {
            $clearBtn.show();
        } else {
            $clearBtn.hide();
        }
        
        // Tabellen-Zeilen filtern
        $('.desktop-mitarbeiter-tabelle tbody tr').each(function() {
            var $row = $(this);
            var name = $row.find('td').eq(1).text().toLowerCase(); // Name Spalte (nach Foto)
            var email = $row.find('td').eq(2).text().toLowerCase(); // E-Mail
            var telefon = $row.find('td').eq(3).text().toLowerCase(); // Telefon
            
            if (searchTerm === '' || 
                name.includes(searchTerm) || 
                email.includes(searchTerm) ||
                telefon.includes(searchTerm)) {
                $row.show();
            } else {
                $row.hide();
            }
        });
        
        // Karten-Ansicht filtern
        $('.mobile-mitarbeiter-karten .mitarbeiter-karte').each(function() {
            var $card = $(this);
            var name = $card.find('.mitarbeiter-name').text().toLowerCase();
            var email = $card.find('.mitarbeiter-email').text().toLowerCase();
            var telefon = $card.find('.mitarbeiter-telefon').text().toLowerCase();
            
            if (searchTerm === '' || 
                name.includes(searchTerm) || 
                email.includes(searchTerm) ||
                telefon.includes(searchTerm)) {
                $card.show();
            } else {
                $card.hide();
            }
        });
        
        // Keine Ergebnisse Meldung
        updateNoResultsMessage(searchTerm);
    }
    
    // Keine Ergebnisse Meldung
    function updateNoResultsMessage(searchTerm) {
        var $tableBody = $('.desktop-mitarbeiter-tabelle tbody');
        var $cardsContainer = $('.mobile-mitarbeiter-karten');
        var visibleTableRows = $tableBody.find('tr:visible').length;
        var visibleCards = $cardsContainer.find('.mitarbeiter-karte:visible').length;
        
        // Entferne alte Meldungen
        $('.no-search-results').remove();
        
        if (searchTerm.length > 0) {
            if (visibleTableRows === 0 && $('.desktop-mitarbeiter-tabelle').hasClass('active')) {
                $tableBody.append(
                    '<tr class="no-search-results">' +
                    '<td colspan="100%" style="text-align: center; padding: 40px; color: #8c8f94;">' +
                    '<span class="dashicons dashicons-search" style="font-size: 48px; opacity: 0.3;"></span><br>' +
                    '<strong>Keine Ergebnisse gefunden</strong><br>' +
                    'Keine Mitarbeiter entsprechen Ihrer Suche nach "' + searchTerm + '"' +
                    '</td>' +
                    '</tr>'
                );
            }
            
            if (visibleCards === 0 && !$cardsContainer.hasClass('hidden')) {
                $cardsContainer.append(
                    '<div class="no-search-results" style="grid-column: 1 / -1; text-align: center; padding: 40px; color: #8c8f94;">' +
                    '<span class="dashicons dashicons-search" style="font-size: 48px; opacity: 0.3;"></span><br>' +
                    '<strong>Keine Ergebnisse gefunden</strong><br>' +
                    'Keine Mitarbeiter entsprechen Ihrer Suche nach "' + searchTerm + '"' +
                    '</div>'
                );
            }
        }
    }
    
    // Event Listener für Sucheingabe
    $searchInput.on('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(performSearch, 300); // Debounce 300ms
    });
    
    // Clear-Button Funktionalität
    $clearBtn.on('click', function() {
        $searchInput.val('').focus();
        performSearch();
    });
    
    // Enter-Taste für Suche
    $searchInput.on('keypress', function(e) {
        if (e.which === 13) {
            e.preventDefault();
            performSearch();
        }
    });

    // ==========================================
    // View Toggle Funktionalität
    // ==========================================
    var storedView = localStorage.getItem('simpbook_mitarbeiter_card_view');
    var isCardView = storedView === null ? true : (storedView !== 'false'); // Default true beim ersten Besuch
    
    // Initial view setzen
    if (isCardView) {
        switchToCardView();
    } else {
        switchToTableView();
    }
    
    $('#toggle-view-btn').on('click', function() {
        isCardView = !isCardView;
        localStorage.setItem('simpbook_mitarbeiter_card_view', isCardView);
        
        if (isCardView) {
            switchToCardView();
        } else {
            switchToTableView();
        }
        
        // Suche erneut anwenden nach View-Wechsel
        if ($searchInput.val().trim().length > 0) {
            performSearch();
        }
    });
    
    function switchToTableView() {
        $('.desktop-mitarbeiter-tabelle').addClass('active');
        $('.mobile-mitarbeiter-karten').addClass('hidden');
        $('#toggle-view-text').text(simpbookMitarbeiterData.i18n.card_view || 'Kartenansicht');
    }
    
    function switchToCardView() {
        $('.desktop-mitarbeiter-tabelle').removeClass('active');
        $('.mobile-mitarbeiter-karten').removeClass('hidden');
        $('#toggle-view-text').text(simpbookMitarbeiterData.i18n.table_view || 'Tabellenansicht');
    }

    // Zeile klickbar machen - Weiterleitung zur Bearbeitungsseite
    $(document).on('click', '.mitarbeiter-row-clickable, .mitarbeiter-karte-clickable', function(e) {
        // Verhindere Klick wenn auf Link oder Button geklickt wird
        if ($(e.target).is('a') || $(e.target).closest('a').length ||
            $(e.target).is('button') || $(e.target).closest('button').length) {
            return;
        }

        e.preventDefault();
        e.stopPropagation();

        var $row = $(this);
        var bearbeitenUrl = $row.data('bearbeiten-url');

        if (bearbeitenUrl) {
            window.location.href = bearbeitenUrl;
        }
    });
});

