// Datepicker-Übersetzungen basierend auf der aktuellen Plugin-Sprache
// (Diese Variable wird über wp_localize_script gesetzt)

jQuery(document).ready(function($) {
    // ============================================================
    // SPRACHSPEZIFISCHE ZEITFORMAT-KONVERTIERUNG (für en_US_AMPM)
    // ============================================================
    // Diese Funktionen konvertieren Zeiten zwischen 24h und 12h (AM/PM) Format
    // analog zu einstellungen.php - um konsistentes Verhalten zu gewährleisten

    // Ermittle aktuelle Sprache (wird von der Hauptdatei gesetzt)
    var currentLanguage = 'de_DE'; // Standard
    if (typeof simpbookMitarbeiterBearbeiten !== 'undefined' && simpbookMitarbeiterBearbeiten.simpbookDatepickerTranslations && simpbookMitarbeiterBearbeiten.simpbookDatepickerTranslations.currentLanguage) {
        currentLanguage = simpbookMitarbeiterBearbeiten.simpbookDatepickerTranslations.currentLanguage;
    }

    // Konvertiere 24h zu 12h mit AM/PM (z.B. "14:00" -> "02:00 PM")
    function convert24to12(time24) {
        if (!time24 || !time24.match(/^\d{2}:\d{2}$/)) return time24;
        var parts = time24.split(':');
        var hours = parseInt(parts[0], 10);
        var minutes = parts[1];
        var ampm = hours >= 12 ? 'PM' : 'AM';
        hours = hours % 12;
        hours = hours ? hours : 12; // 0 sollte 12 sein
        return (hours < 10 ? '0' : '') + hours + ':' + minutes + ' ' + ampm;
    }

    // Konvertiere 12h mit AM/PM zu 24h (z.B. "02:00 PM" -> "14:00")
    function convert12to24(time12) {
        if (!time12) return '';
        // Format: "HH:MM AM" oder "HH:MM PM"
        var match = time12.match(/^(\d{1,2}):(\d{2})\s*(AM|PM)$/i);
        if (!match) {
            // Versuche auch ohne Leerzeichen
            match = time12.match(/^(\d{1,2}):(\d{2})(AM|PM)$/i);
        }
        if (!match) return time12; // Falls kein gültiges Format, zurückgeben

        var hours = parseInt(match[1], 10);
        var minutes = match[2];
        var ampm = match[3].toUpperCase();

        if (ampm === 'PM' && hours !== 12) {
            hours += 12;
        } else if (ampm === 'AM' && hours === 12) {
            hours = 0;
        }

        return (hours < 10 ? '0' : '') + hours + ':' + minutes;
    }

    // Konvertiere alle time inputs zur Anzeige (24h -> 12h bei en_US_AMPM)
    function convertTimeInputsForUS() {
        if (currentLanguage !== 'en_US_AMPM') {
            return; // Nur für US-Sprache
        }

        // Konvertiere alle time inputs in BEIDEN Containern (Desktop & Mobile)
        $('#arbeitszeiten-container .time-input[type="time"]').each(function() {
            var $input = $(this);
            var time24 = $input.val();
            if (time24) {
                var time12 = convert24to12(time24);
                // Ersetze type="time" durch type="text" mit pattern
                $input.attr('type', 'text');
                $input.attr('pattern', '^([0-1]?[0-9]|2[0-3]):[0-5][0-9]\\s*(AM|PM)$');
                $input.attr('placeholder', 'HH:MM AM/PM');
                $input.val(time12);
            } else {
                $input.attr('type', 'text');
                $input.attr('pattern', '^([0-1]?[0-9]|2[0-3]):[0-5][0-9]\\s*(AM|PM)$');
                $input.attr('placeholder', 'HH:MM AM/PM');
            }
        });
    }

    // Konvertiere alle time inputs vor dem Submit zurück (12h -> 24h bei en_US_AMPM)
    function convertTimeInputsTo24h() {
        if (currentLanguage !== 'en_US_AMPM') {
            return; // Nur für US-Sprache
        }

        // Konvertiere alle text inputs (die ehemals time inputs waren) zurück zu 24h in BEIDEN Containern
        $('#arbeitszeiten-container .time-input[type="text"]').each(function() {
            var $input = $(this);
            var time12 = $input.val();
            if (time12) {
                var time24 = convert12to24(time12);
                $input.attr('type', 'time');
                $input.val(time24);
            } else {
                $input.attr('type', 'time');
            }
        });
    }

    // Konvertiere bei Seitenladung für US-Sprache
    convertTimeInputsForUS();

    // ============================================================
    // LIVE-SYNCHRONISIERUNG zwischen Desktop und Mobile
    // ============================================================
    // Synchronisiere Arbeitszeiten LIVE (nicht erst beim Submit)
    var wochentage = ['montag', 'dienstag', 'mittwoch', 'donnerstag', 'freitag', 'samstag', 'sonntag'];

    wochentage.forEach(function(tag) {
        // Desktop -> Mobile Synchronisierung
        $('input[name="arbeitszeit_' + tag + '_aktiv"]').on('change', function() {
            $('input[name="arbeitszeit_' + tag + '_aktiv_mobile"]').prop('checked', $(this).is(':checked'));
        });

        $('input[name="arbeitszeit_' + tag + '_beginn"]').on('change', function() {
            $('input[name="arbeitszeit_' + tag + '_beginn_mobile"]').val($(this).val());
        });

        $('input[name="arbeitszeit_' + tag + '_ende"]').on('change', function() {
            $('input[name="arbeitszeit_' + tag + '_ende_mobile"]').val($(this).val());
        });

        // Mobile -> Desktop Synchronisierung
        $('input[name="arbeitszeit_' + tag + '_aktiv_mobile"]').on('change', function() {
            $('input[name="arbeitszeit_' + tag + '_aktiv"]').prop('checked', $(this).is(':checked'));
        });

        $('input[name="arbeitszeit_' + tag + '_beginn_mobile"]').on('change', function() {
            $('input[name="arbeitszeit_' + tag + '_beginn"]').val($(this).val());
        });

        $('input[name="arbeitszeit_' + tag + '_ende_mobile"]').on('change', function() {
            $('input[name="arbeitszeit_' + tag + '_ende"]').val($(this).val());
        });
    });

    // Synchronisiere Dienstleistungen LIVE
    $('input[name="dienstleistungen[]"]').on('change', function() {
        var $checkbox = $(this);
        var value = $checkbox.val();
        var isChecked = $checkbox.is(':checked');

        // Synchronisiere alle anderen Checkboxes mit diesem Wert
        $('input[name="dienstleistungen[]"][value="' + value + '"]').not($checkbox).prop('checked', isChecked);
    });

    // ============================================================
    // SYNCHRONISIERUNG BASIS-FELDER (Name, Email, Telefon, etc.)
    // ============================================================
    // Da wir zwei Formulare (Desktop & Mobile) im gleichen <form> Tag haben,
    // müssen wir sicherstellen, dass die Werte synchronisiert werden,

    // Vor dem Submit: Zeit-Konvertierung UND unsichtbare Felder deaktivieren (um doppelte name-Attribute zu vermeiden)
    $('form.mitarbeiter-edit-form').on('submit', function(e) {
        console.log('PocketBooking: Form submit started');

        try {
            convertTimeInputsTo24h();
        } catch (error) {
            console.warn('Fehler bei Zeit-Konvertierung:', error);
        }

        // Deaktiviere unsichtbare Formular-Felder, um doppelte name-Attribute zu vermeiden
        // (sonst überschreibt das leere unsichtbare Feld das sichtbare Feld)
        // Prüfe ob Mobile oder Desktop sichtbar ist und deaktiviere das jeweils unsichtbare
        var mobileVisible = $('.mobile-mitarbeiter-form-card').is(':visible');
        console.log('PocketBooking: Mobile visible: ' + mobileVisible);

        if (mobileVisible) {
            // Mobile ist sichtbar - deaktiviere Desktop-Felder
            console.log('PocketBooking: Disabling desktop fields');
            $('.desktop-mitarbeiter-form input, .desktop-mitarbeiter-form select, .desktop-mitarbeiter-form textarea').prop('disabled', true);
        } else {
            // Desktop ist sichtbar - deaktiviere Mobile-Felder
            console.log('PocketBooking: Disabling mobile fields');
            $('.mobile-mitarbeiter-form-card input, .mobile-mitarbeiter-form-card select, .mobile-mitarbeiter-form-card textarea').prop('disabled', true);
        }

        console.log('PocketBooking: Form will now submit');
        // Form-Submit wird fortgesetzt (kein return false oder preventDefault)
    });

    // Media Library für Profilfoto
    var file_frame;
    $('#upload_foto_button').on('click', function(event) {
        event.preventDefault();

        if (file_frame) {
            file_frame.open();
            return;
        }

        file_frame = wp.media({
            title: simpbookMitarbeiterBearbeiten.uploadFotoTitle,
            button: {
                text: simpbookMitarbeiterBearbeiten.uploadFotoButton,
            },
            multiple: false
        });

        file_frame.on('select', function() {
            var attachment = file_frame.state().get('selection').first().toJSON();
            $('#profilfoto_url').val(attachment.url);
            $('#foto_preview').html('<img src="' + attachment.url + '" alt="Profilfoto" style="max-width: 200px; max-height: 200px; border-radius: 4px;">');
            $('#remove_foto_button').show();
        });

        file_frame.open();
    });


    $('#remove_foto_button').on('click', function() {
        $('#profilfoto_url').val('');
        $('#foto_preview').html('');
        $('#remove_foto_button').hide();
    });

    // Individuelle Arbeitszeiten ein-/ausblenden
    $('#simpbook_individuelle_arbeitszeiten_aktiv').on('change', function() {
        if ($(this).is(':checked')) {
            $('#arbeitszeiten-container').slideDown();
        } else {
            $('#arbeitszeiten-container').slideUp();
        }
    });

    // ============================================================
    // APP-ZUGANG TOGGLE
    // ============================================================
    // Desktop Checkbox
    $('#simpbook_app_zugang_aktiv').on('change', function() {
        var isChecked = $(this).is(':checked');
        
        if (isChecked) {
            $('#simpbook-app-zugang-details').slideDown();
        } else {
            $('#simpbook-app-zugang-details').slideUp();
        }
        
        // Synchronisiere mit Mobile
        $('#app_zugang_aktiv-mobile').prop('checked', isChecked);
    });
    
    // Mobile Checkbox
    $('#app_zugang_aktiv-mobile').on('change', function() {
        var isChecked = $(this).is(':checked');
        $('#simpbook_app_zugang_aktiv').prop('checked', isChecked).trigger('change');
    });

    // ============================================================
    // APP ZUGANGSDATEN E-MAIL SENDEN
    // ============================================================
    $('.simpbook-send-app-email').on('click', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var mitarbeiterId = $button.data('mitarbeiter-id');
        
        if (!mitarbeiterId) {
            if (typeof window.simpbookAlert === 'function') {
                window.simpbookAlert('Ungültige Mitarbeiter-ID.', 'Fehler');
            } else {
                alert('Ungültige Mitarbeiter-ID.');
            }
            return;
        }
        
        // Button deaktivieren und Text ändern
        var originalText = $button.html();
        $button.prop('disabled', true).html('<span class="dashicons dashicons-update spin"></span> Sende...');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'simpbook_send_app_access_email',
                mitarbeiter_id: mitarbeiterId,
                nonce: simpbookMitarbeiterBearbeiten.appEmailNonce || ''
            },
            success: function(response) {
                $button.prop('disabled', false).html(originalText);
                
                if (response && response.success) {
                    if (typeof window.simpbookAlert === 'function') {
                        window.simpbookAlert(response.data.message || 'E-Mail wurde erfolgreich gesendet.', 'Erfolg');
                    } else {
                        alert(response.data.message || 'E-Mail wurde erfolgreich gesendet.');
                    }
                } else {
                    var errorMsg = (response && response.data && response.data.message) ? response.data.message : 'E-Mail konnte nicht gesendet werden.';
                    if (typeof window.simpbookAlert === 'function') {
                        window.simpbookAlert(errorMsg, 'Fehler');
                    } else {
                        alert(errorMsg);
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error);
                $button.prop('disabled', false).html(originalText);
                
                if (typeof window.simpbookAlert === 'function') {
                    window.simpbookAlert('Ein Fehler ist aufgetreten.', 'Fehler');
                } else {
                    alert('Ein Fehler ist aufgetreten.');
                }
            }
        });
    });

    // Löschen
    if (typeof simpbookMitarbeiterBearbeiten !== 'undefined' && simpbookMitarbeiterBearbeiten.mitarbeiterId > 0) {
        $('#mitarbeiter-delete').on('click', function(e) {
            e.preventDefault();

            if (!simpbookMitarbeiterBearbeiten.mitarbeiterId || simpbookMitarbeiterBearbeiten.mitarbeiterId == 0) {
                if (typeof window.simpbookAlert === 'function') {
                    window.simpbookAlert(simpbookMitarbeiterBearbeiten.invalidIdMessage, simpbookMitarbeiterBearbeiten.errorTitle);
                } else {
                    alert(simpbookMitarbeiterBearbeiten.invalidIdMessage);
                }
                return;
            }

            if (typeof window.simpbookConfirm === 'function') {
                window.simpbookConfirm(simpbookMitarbeiterBearbeiten.confirmDeleteMessage, simpbookMitarbeiterBearbeiten.confirmTitle).then(function(confirmed) {
                    if (confirmed) {
                        $.ajax({
                            url: ajaxurl,
                            type: 'POST',
                            data: {
                                action: 'simpbook_delete_mitarbeiter',
                                simpbook_id: simpbookMitarbeiterBearbeiten.mitarbeiterId,
                                simpbook_nonce: simpbookMitarbeiterBearbeiten.deleteNonce
                            },
                            success: function(response) {
                                if (response && response.success) {
                                    window.location.href = simpbookMitarbeiterBearbeiten.redirectUrl;
                                } else {
                                    var errorMsg = (response && response.data) ? response.data : simpbookMitarbeiterBearbeiten.deleteErrorMessage;
                                    if (typeof window.simpbookAlert === 'function') {
                                        window.simpbookAlert(errorMsg, simpbookMitarbeiterBearbeiten.errorTitle);
                                    } else {
                                        alert(errorMsg);
                                    }
                                }
                            },
                            error: function(xhr, status, error) {
                                console.error('AJAX Error:', status, error);
                                console.error('Response:', xhr.responseText);
                                var errorMsg = simpbookMitarbeiterBearbeiten.unknownErrorMessage;
                                if (xhr.responseJSON && xhr.responseJSON.data) {
                                    errorMsg = xhr.responseJSON.data;
                                }
                                if (typeof window.simpbookAlert === 'function') {
                                    window.simpbookAlert(errorMsg, simpbookMitarbeiterBearbeiten.errorTitle);
                                } else {
                                    alert(errorMsg);
                                }
                            }
                        });
                    }
                });
            } else {
                // Fallback zu Browser confirm
                if (confirm(simpbookMitarbeiterBearbeiten.confirmDeleteMessage)) {
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'simpbook_delete_mitarbeiter',
                            simpbook_id: simpbookMitarbeiterBearbeiten.mitarbeiterId,
                            simpbook_nonce: simpbookMitarbeiterBearbeiten.deleteNonce
                        },
                        success: function(response) {
                            if (response && response.success) {
                                window.location.href = simpbookMitarbeiterBearbeiten.redirectUrl;
                            } else {
                                var errorMsg = (response && response.data) ? response.data : simpbookMitarbeiterBearbeiten.deleteErrorMessage;
                                alert(errorMsg);
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('AJAX Error:', status, error);
                            console.error('Response:', xhr.responseText);
                            var errorMsg = simpbookMitarbeiterBearbeiten.unknownErrorMessage;
                            if (xhr.responseJSON && xhr.responseJSON.data) {
                                errorMsg = xhr.responseJSON.data;
                            }
                            alert(errorMsg);
                        }
                    });
                }
            }
        });
    }
});
