jQuery(document).ready(function($) {
    // Hilfsfunktionen für Statusänderungen
    window.statusAendernBestaetigen = function(url, nachricht) {
        var confirmTitle = simpbookKalender.translations.confirmation;

        if (typeof window.simpbookConfirmPositive === 'function') {
            window.simpbookConfirmPositive(nachricht, confirmTitle).then(function(confirmed) {
                if (confirmed) {
                    window.location.href = url;
                }
            });
        } else {
            // Fallback zu Browser confirm
            if (confirm(nachricht)) {
                window.location.href = url;
            }
        }
        return false;
    };

    window.statusAendernAblehnen = function(url, nachricht) {
        var confirmTitle = simpbookKalender.translations.confirmation;

        if (typeof window.simpbookConfirm === 'function') {
            window.simpbookConfirm(nachricht, confirmTitle).then(function(confirmed) {
                if (confirmed) {
                    window.location.href = url;
                }
            });
        } else {
            // Fallback zu Browser confirm
            if (confirm(nachricht)) {
                window.location.href = url;
            }
        }
        return false;
    };

    window.loeschenAendern = function(url, nachricht) {
        var confirmTitle = simpbookKalender.translations.confirmation;

        if (typeof window.simpbookConfirm === 'function') {
            window.simpbookConfirm(nachricht, confirmTitle).then(function(confirmed) {
                if (confirmed) {
                    window.location.href = url;
                }
            });
        } else {
            // Fallback zu Browser confirm
            if (confirm(nachricht)) {
                window.location.href = url;
            }
        }
        return false;
    };

    // Funktion zum Öffnen des Reservierungs-Modals vom Kalender
    window.openReservierungModalFromCalendar = function(reservierungId) {
        $.ajax({
            url: simpbookKalender.ajaxUrl,
            type: 'POST',
            data: {
                action: 'simpbook_get_reservierung_details',
                simpbook_id: reservierungId,
                simpbook_nonce: simpbookKalender.detailsNonce
            },
            success: function(response) {
                if (response && response.success && response.data) {
                    var reservierung = response.data;
                    showReservierungModal(reservierung);
                } else {
                    alert(simpbookKalender.translations.errorLoadingDetails);
                }
            },
            error: function() {
                alert(simpbookKalender.translations.errorLoadingDetails);
            }
        });
    };

    // Funktion zum Anzeigen des Reservierungs-Modals
    function showReservierungModal(reservierung) {
        var baseUrl = simpbookKalender.baseUrl;
        var editUrl = simpbookKalender.editUrl + '&simpbook_id=' + reservierung.id;
        
        // Debug: PWA-Status und URLs loggen
        console.log('PWA Modal Debug:', {
            isPwa: simpbookKalender.isPwa,
            baseUrl: baseUrl,
            editUrl: editUrl
        });

        // Status-Klassen und -Texte
        var statusClass = 'status-ausstehend';
        var statusText = simpbookKalender.translations.ausstehend;
        if (reservierung.status === 'BESTÄTIGT') {
            statusClass = 'status-bestätigt';
            statusText = simpbookKalender.translations.bestaetigt;
        } else if (reservierung.status === 'ABGELEHNT' || reservierung.status === 'STORNIERT') {
            statusClass = 'status-abgelehnt';
            statusText = reservierung.status === 'STORNIERT' ? simpbookKalender.translations.storniert : simpbookKalender.translations.abgelehnt;
        }

        var modalContent = '<div class="reservierung-detail-grid">';

        // Kontaktinformationen Kachel
        modalContent += '<div class="detail-card">';
        modalContent += '<div class="detail-card-header">';
        modalContent += '<span class="dashicons dashicons-admin-users"></span>';
        modalContent += '<h3>' + simpbookKalender.translations.contactInfo + '</h3>';
        modalContent += '</div>';
        modalContent += '<div class="detail-card-content">';
        modalContent += '<div class="detail-item"><strong>' + simpbookKalender.translations.name + '</strong><span>' + reservierung.name + '</span></div>';
        modalContent += '<div class="detail-item"><strong>' + simpbookKalender.translations.email + '</strong><span><a href="mailto:' + reservierung.email + '">' + reservierung.email + '</a></span></div>';
        if (reservierung.telefon) {
            modalContent += '<div class="detail-item"><strong>' + simpbookKalender.translations.phone + '</strong><span><a href="tel:' + reservierung.telefon + '">' + reservierung.telefon + '</a></span></div>';
        }
        modalContent += '</div>';
        modalContent += '</div>';

        // Termin Kachel
        modalContent += '<div class="detail-card">';
        modalContent += '<div class="detail-card-header">';
        modalContent += '<span class="dashicons dashicons-calendar-alt"></span>';
        modalContent += '<h3>' + simpbookKalender.translations.appointment + '</h3>';
        modalContent += '</div>';
        modalContent += '<div class="detail-card-content">';
        modalContent += '<div class="detail-item"><strong>' + simpbookKalender.translations.date + '</strong><span>' + reservierung.datum + '</span></div>';
        // Uhrzeit im richtigen Format anzeigen
        var pluginLang = simpbookKalender.currentLanguage;
        var displayTime = reservierung.uhrzeit;
        if (displayTime) {
            var timeParts = displayTime.split(':');
            if (timeParts.length >= 2) {
                var hour = parseInt(timeParts[0], 10);
                var minute = timeParts[1];
                if (pluginLang === 'en_US_AMPM') {
                    var ampm = hour >= 12 ? 'PM' : 'AM';
                    var hour12 = hour % 12;
                    if (hour12 === 0) hour12 = 12;
                    displayTime = hour12 + ':' + minute + ' ' + ampm;
                } else {
                    displayTime = hour.toString().padStart(2, '0') + ':' + minute;
                }
            }
        }
        modalContent += '<div class="detail-item"><strong>' + simpbookKalender.translations.time + '</strong><span>' + displayTime + '</span></div>';
        modalContent += '</div>';
        modalContent += '</div>';

        // Service Kachel
        modalContent += '<div class="detail-card">';
        modalContent += '<div class="detail-card-header">';
        modalContent += '<span class="dashicons dashicons-admin-tools"></span>';
        modalContent += '<h3>' + simpbookKalender.translations.service + '</h3>';
        modalContent += '</div>';
        modalContent += '<div class="detail-card-content">';
        modalContent += '<div class="detail-item"><strong>' + simpbookKalender.translations.serviceType + '</strong><span>' + (reservierung.dienstleistung || '-') + '</span></div>';
        
        // Mitarbeiter-Dropdown
        modalContent += '<div class="detail-item">';
        modalContent += '<strong>' + simpbookKalender.translations.employee + '</strong>';
        modalContent += '<select id="calendar-modal-mitarbeiter-select" class="simpbook-mitarbeiter-dropdown" data-reservierung-id="' + reservierung.id + '">';
        modalContent += '<option value="0">' + simpbookKalender.translations.noSpecificEmployee + '</option>';
        
        // Nur verfügbare Mitarbeiter anzeigen (aus AJAX-Antwort)
        if (reservierung.verfuegbare_mitarbeiter && reservierung.verfuegbare_mitarbeiter.length > 0) {
            for (var i = 0; i < reservierung.verfuegbare_mitarbeiter.length; i++) {
                var mitarbeiter = reservierung.verfuegbare_mitarbeiter[i];
                var selected = (reservierung.mitarbeiter_id && reservierung.mitarbeiter_id == mitarbeiter.id) ? ' selected' : '';
                modalContent += '<option value="' + mitarbeiter.id + '"' + selected + '>' + mitarbeiter.name + '</option>';
            }
        }
        
        modalContent += '</select>';
        modalContent += '<span class="simpbook-save-indicator" style="display:none; margin-left: 10px; color: #46b450;">';
        modalContent += '<span class="dashicons dashicons-yes-alt"></span> ' + simpbookKalender.translations.saved;
        modalContent += '</span>';
        modalContent += '</div>';
        
        modalContent += '</div>';
        modalContent += '</div>';

        // Nachricht Kachel
        modalContent += '<div class="detail-card">';
        modalContent += '<div class="detail-card-header">';
        modalContent += '<span class="dashicons dashicons-format-chat"></span>';
        modalContent += '<h3>' + simpbookKalender.translations.message + '</h3>';
        modalContent += '</div>';
        modalContent += '<div class="detail-card-content">';
        modalContent += '<div style="white-space: pre-wrap; min-height: 60px;">' + (reservierung.nachricht && reservierung.nachricht !== '-' ? reservierung.nachricht : simpbookKalender.translations.none) + '</div>';
        modalContent += '</div>';
        modalContent += '</div>';

        // Status & Aktionen Kachel
        modalContent += '<div class="detail-card full-width">';
        modalContent += '<div class="detail-card-header">';
        modalContent += '<span class="dashicons dashicons-admin-settings"></span>';
        modalContent += '<h3>' + simpbookKalender.translations.statusAndActions + '</h3>';
        modalContent += '</div>';
        modalContent += '<div class="detail-card-content">';
        modalContent += '<div class="detail-item-row">';
        modalContent += '<div class="detail-item"><strong>' + simpbookKalender.translations.currentStatus + '</strong><span class="status-badge ' + statusClass + '">' + statusText + '</span></div>';
        modalContent += '<div class="detail-item" id="calendar-modal-status-date" style="display: none;"><strong id="calendar-modal-status-date-label"></strong><span id="calendar-modal-status-date-value"></span></div>';
        modalContent += '</div>';
        modalContent += '<div class="detail-actions">';

        // Action Buttons (wie in reservierungen-liste.php)
        // PWA-aware URLs: baseUrl enthält bereits pwa=1 wenn im PWA-Modus (gesetzt in PHP)
        var redirectParam = '&simpbook_redirect_to=' + encodeURIComponent(baseUrl);
        var bestaetigenUrl = baseUrl + '&simpbook_aktion=simpbook_status_aendern&simpbook_id=' + reservierung.id + '&simpbook_status=BESTÄTIGT&simpbook_nonce=' + reservierung.nonce_status + redirectParam;
        var ablehnenUrl = baseUrl + '&simpbook_aktion=simpbook_status_aendern&simpbook_id=' + reservierung.id + '&simpbook_status=ABGELEHNT&simpbook_nonce=' + reservierung.nonce_status + redirectParam;
        var stornierenUrl = baseUrl + '&simpbook_aktion=stornieren&simpbook_id=' + reservierung.id + '&simpbook_nonce=' + reservierung.nonce_delete + redirectParam;
        var loeschenUrl = baseUrl + '&simpbook_aktion=loeschen&simpbook_id=' + reservierung.id + '&simpbook_nonce=' + reservierung.nonce_delete + redirectParam;
        
        // Debug: URLs loggen
        console.log('Modal Action URLs:', {
            bestaetigenUrl: bestaetigenUrl,
            ablehnenUrl: ablehnenUrl,
            editUrlFull: editUrl,
            loeschenUrl: loeschenUrl
        });
        
        // editUrl mit Reservierungs-ID versehen (enthält bereits pwa=1 wenn im PWA-Modus)
        var editUrlFull = editUrl;

        modalContent += '<a href="#" onclick="return statusAendernBestaetigen(\'' + bestaetigenUrl + '\', \'' + simpbookKalender.translations.confirmBooking + '\')" class="button button-bestaetigen"><span class="dashicons dashicons-yes-alt"></span>' + simpbookKalender.translations.confirm + '</a>';
        modalContent += '<a href="#" onclick="return statusAendernAblehnen(\'' + ablehnenUrl + '\', \'' + simpbookKalender.translations.rejectBooking + '\')" class="button button-ablehnen"><span class="dashicons dashicons-dismiss"></span>' + simpbookKalender.translations.reject + '</a>';
        modalContent += '<a href="' + editUrlFull + '" class="button"><span class="dashicons dashicons-edit"></span>' + simpbookKalender.translations.edit + '</a>';
        modalContent += '<button class="button nachricht-senden-btn-modal" data-email="' + reservierung.email + '" data-name="' + reservierung.name + '"><span class="dashicons dashicons-email"></span>' + simpbookKalender.translations.sendMessage + '</button>';
        modalContent += '<a href="#" onclick="return loeschenAendern(\'' + loeschenUrl + '\', \'' + simpbookKalender.translations.confirmDelete + '\')" class="button button-link-delete"><span class="dashicons dashicons-trash"></span>' + simpbookKalender.translations.delete + '</a>';

        modalContent += '</div>';
        modalContent += '</div>';
        modalContent += '</div>';

        modalContent += '</div>'; // Ende reservierung-detail-grid

        $('#reservierung-details-content').html(modalContent);
        $('#reservierung-details-modal').show();

        // Status-Datum anzeigen (wie in reservierungen-liste.php)
        var statusDateLabel = '';
        var statusDateValue = '';
        var statusDate = reservierung.status_geaendert_datum || reservierung.erstellungsdatum;

        if (statusDate && reservierung.status && reservierung.status !== 'AUSSTEHEND') {
            var statusTranslated = '';
            if (reservierung.status === 'BESTÄTIGT') {
                statusTranslated = simpbookKalender.translations.bestaetigt;
            } else if (reservierung.status === 'ABGELEHNT') {
                statusTranslated = simpbookKalender.translations.abgelehnt;
            } else if (reservierung.status === 'STORNIERT' || reservierung.storniert == 1) {
                statusTranslated = simpbookKalender.translations.storniert;
            }

            if (statusTranslated) {
                statusDateLabel = simpbookKalender.translations.at;
                // Datum und Uhrzeit formatieren
                var dateObj = new Date(statusDate);
                if (!isNaN(dateObj.getTime())) {
                    var day = String(dateObj.getDate()).padStart(2, '0');
                    var month = String(dateObj.getMonth() + 1).padStart(2, '0');
                    var year = dateObj.getFullYear();
                    var hours = String(dateObj.getHours()).padStart(2, '0');
                    var minutes = String(dateObj.getMinutes()).padStart(2, '0');
                    var displayTime = hours + ':' + minutes;
                    var pluginLang = simpbookKalender.currentLanguage;
                    if (pluginLang === 'en_US_AMPM') {
                        var hour = parseInt(hours, 10);
                        var ampm = hour >= 12 ? 'PM' : 'AM';
                        var hour12 = hour % 12;
                        if (hour12 === 0) hour12 = 12;
                        displayTime = hour12 + ':' + minutes + ' ' + ampm;
                    }
                    var displayDate = day + '.' + month + '.' + year;
                    var pluginLang = simpbookKalender.currentLanguage;
                    if (pluginLang === 'en_US_AMPM') {
                        var monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
                        displayDate = monthNames[dateObj.getMonth()] + ' ' + day + ', ' + year;
                    }
                    statusDateValue = displayDate + ' ' + simpbookKalender.translations.atTime + ' ' + displayTime;
                } else {
                    // Falls Datum nicht als Date geparst werden kann, direkt anzeigen
                    statusDateValue = statusDate;
                }
                $('#calendar-modal-status-date-label').text(statusDateLabel);
                $('#calendar-modal-status-date-value').text(statusDateValue);
                $('#calendar-modal-status-date').show();
            } else {
                $('#calendar-modal-status-date').hide();
            }
        } else {
            $('#calendar-modal-status-date').hide();
        }
    }

    // Modal schließen - Event-Handler
    $(document).on('click', '.reservierung-modal-close', function() {
        $('#reservierung-details-modal').hide();
    });

    $(document).on('click', '.reservierung-modal-overlay', function() {
        $('#reservierung-details-modal').hide();
    });

    // Locale und responsive Einstellungen vorbereiten
    // Nutze die Plugin-Spracheinstellung extrahiert aus WordPress Locale (z.B. de_DE -> de)
    var fcLocale = simpbookKalender.fcLocale; // z.B. 'de', 'en', 'it', 'es', 'fr', 'pl'

    // Debug: Prüfe ob FullCalendar geladen ist
    if (typeof FullCalendar === 'undefined') {
        console.error('FullCalendar ist nicht geladen');
        return; // Beende das Script, wenn FullCalendar nicht verfügbar ist
    }

    // Responsive View bestimmen
    var isMobile = window.innerWidth <= 782;
    var initialView = 'timeGridWeek';

    var calendarEl = document.getElementById('calendar');

    // Button-Texte aus Übersetzungen
    var buttonText = {
        today: simpbookKalender.buttonText.today,
        month: simpbookKalender.buttonText.month,
        week: simpbookKalender.buttonText.week,
        day: simpbookKalender.buttonText.day
    };

    // Zeitformat basierend auf Spracheinstellung bestimmen
    // Nur en_US_AMPM soll AM/PM verwenden, alle anderen (inkl. en_US) verwenden 24h
    var pluginLang = simpbookKalender.currentLanguage || 'en_US';
    var useAmPm = (pluginLang === 'en_US_AMPM');
    
    var timeFormat = useAmPm 
        ? { hour: 'numeric', minute: '2-digit', hour12: true, meridiem: 'short' }
        : { hour: '2-digit', minute: '2-digit', hour12: false };

    // Berechne minimale und maximale Zeitslots basierend auf Öffnungszeiten
    var wochentag_zeiten = simpbookKalender.wochentag_zeiten || {};
    var calendarMinTime = '06:00:00'; // Standard-Fallback
    var calendarMaxTime = '22:00:00'; // Standard-Fallback

    console.log('DEBUG: wochentag_zeiten Rohdaten:', wochentag_zeiten);
    console.log('DEBUG: wochentag_zeiten Typ:', typeof wochentag_zeiten);
    console.log('DEBUG: wochentag_zeiten Keys:', Object.keys(wochentag_zeiten));

    // Wenn Öffnungszeiten verfügbar sind, berechne min/max Zeit
    if (wochentag_zeiten && typeof wochentag_zeiten === 'object' && Object.keys(wochentag_zeiten).length > 0) {
        var minTimes = [];
        var maxTimes = [];
        
        console.log('DEBUG: Starte Verarbeitung von Öffnungszeiten...');
        
        // Sammle alle Zeiten von aktiven Tagen
        for (var day in wochentag_zeiten) {
            if (wochentag_zeiten.hasOwnProperty(day)) {
                var dayConfig = wochentag_zeiten[day];
                console.log('DEBUG: Tag:', day, 'Config:', dayConfig);
                
                if (dayConfig && (dayConfig.aktiv === '1' || dayConfig.aktiv === 1 || dayConfig.aktiv === true) && dayConfig.beginn && dayConfig.ende) {
                    console.log('DEBUG: Tag', day, 'ist aktiv. Beginn:', dayConfig.beginn, 'Ende:', dayConfig.ende);
                    minTimes.push(dayConfig.beginn);
                    maxTimes.push(dayConfig.ende);
                } else {
                    console.log('DEBUG: Tag', day, 'wird übersprungen. Aktiv:', dayConfig?.aktiv, 'Beginn:', dayConfig?.beginn, 'Ende:', dayConfig?.ende);
                }
            }
        }
        
        console.log('DEBUG: Gesammelte Min-Zeiten:', minTimes);
        console.log('DEBUG: Gesammelte Max-Zeiten:', maxTimes);
        
        // Finde früheste Start- und späteste Endzeit
        if (minTimes.length > 0) {
            minTimes.sort();
            calendarMinTime = minTimes[0]; // Früheste Öffnungszeit
            console.log('DEBUG: Berechnet calendarMinTime:', calendarMinTime);
        }
        
        if (maxTimes.length > 0) {
            maxTimes.sort();
            var lastEndTime = maxTimes[maxTimes.length - 1]; // Späteste Schließungszeit
            console.log('DEBUG: Letzter Schließungszeitpunkt:', lastEndTime);
            
            // Addiere eine Stunde zur Endzeit
            var timeParts = lastEndTime.split(':');
            var hours = parseInt(timeParts[0], 10);
            var minutes = parseInt(timeParts[1], 10);
            var nextHour = (hours + 1) % 24;
            calendarMaxTime = (nextHour < 10 ? '0' : '') + nextHour + ':' + (minutes < 10 ? '0' : '') + minutes + ':00';
            console.log('DEBUG: Berechnet calendarMaxTime:', calendarMaxTime);
        }
        
        console.log('Calendar Times - Min:', calendarMinTime, 'Max:', calendarMaxTime);
    } else {
        console.log('DEBUG: Öffnungszeiten nicht verfügbar oder leer, verwende Standard-Fallback');
    }

    var calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: initialView,
        locale: fcLocale,
        locales: FullCalendar.globalLocales || [],
        height: 'auto',
        contentHeight: 'auto',
        buttonText: buttonText,
        eventTimeFormat: timeFormat,
        slotLabelFormat: timeFormat,
        headerToolbar: {
            left: 'dayGridMonth,timeGridWeek,timeGridDay',
            center: 'title',
            right: 'prev,next,today'
        },
        // Responsive Einstellungen
        views: {
            dayGridMonth: {
                dayMaxEvents: isMobile ? 2 : 3,
                moreLinkClick: 'popover'
            },
            timeGridWeek: {
                slotMinTime: calendarMinTime,
                slotMaxTime: calendarMaxTime,
                allDaySlot: false
            },
            timeGridDay: {
                slotMinTime: calendarMinTime,
                slotMaxTime: calendarMaxTime,
                allDaySlot: false
            }
        },
        // Event Popover für mobile
        eventMaxStack: isMobile ? 2 : 3,
        moreLinkClick: 'popover',
        moreLinkContent: function(args) {
            var template = simpbookKalender.translations.moreLinkText || '+%s mehr';
            return template.replace('%s', args.num);
        },
        events: function(info, successCallback, failureCallback) {
            // AJAX-Anfrage für Reservierungen
            $.ajax({
                url: simpbookKalender.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'simpbook_get_calendar_events',
                    simpbook_start: info.startStr,
                    simpbook_end: info.endStr,
                    simpbook_filter_mitarbeiter: $('#simpbook_filter_mitarbeiter').val() || 0,
                    simpbook_filter_dienstleistung: $('#simpbook_filter_dienstleistung').val() || 0,
                    simpbook_nonce: simpbookKalender.eventsNonce
                },
                success: function(response) {
                    if (response.success) {
                        successCallback(response.data);
                    } else {
                        failureCallback();
                    }
                },
                error: function() {
                    failureCallback();
                }
            });
        },
        eventClick: function(info) {
            // Öffne Modal mit Reservierungsdetails
            info.jsEvent.preventDefault();
            var reservierungId = info.event.id;
            if (reservierungId) {
                openReservierungModalFromCalendar(reservierungId);
            }
        },
        datesSet: function(dateInfo) {
            var view = dateInfo.view;
            
            if (view.type === 'timeGridWeek') {
                // Wochenansicht: verwende die globalen min/max Zeiten (früheste und späteste Öffnungszeiten aller Tage)
                calendar.setOption('slotMinTime', calendarMinTime);
                calendar.setOption('slotMaxTime', calendarMaxTime);
            } else if (view.type === 'timeGridDay') {
                // Tagesansicht: berechne die Zeiten für den spezifischen Wochentag
                var currentDate = dateInfo.start;
                var dayOfWeek = currentDate.getDay(); // 0 = Sonntag, 1 = Montag, etc.
                
                // Map JavaScript day (0-6) zu unseren Wochentag-Keys
                var dayMap = {
                    0: 'sonntag',
                    1: 'montag',
                    2: 'dienstag',
                    3: 'mittwoch',
                    4: 'donnerstag',
                    5: 'freitag',
                    6: 'samstag'
                };
                
                var dayKey = dayMap[dayOfWeek];
                var dayConfig = wochentag_zeiten[dayKey];
                
                if (dayConfig && (dayConfig.aktiv === '1' || dayConfig.aktiv === 1 || dayConfig.aktiv === true) && dayConfig.beginn && dayConfig.ende) {
                    // Verwende die spezifischen Zeiten für diesen Tag
                    var dayMinTime = dayConfig.beginn;
                    var dayMaxTime = dayConfig.ende;
                    
                    // Addiere eine Stunde zur Endzeit
                    var timeParts = dayMaxTime.split(':');
                    var hours = parseInt(timeParts[0], 10);
                    var minutes = parseInt(timeParts[1], 10);
                    var nextHour = (hours + 1) % 24;
                    dayMaxTime = (nextHour < 10 ? '0' : '') + nextHour + ':' + (minutes < 10 ? '0' : '') + minutes + ':00';
                    
                    calendar.setOption('slotMinTime', dayMinTime);
                    calendar.setOption('slotMaxTime', dayMaxTime);
                } else {
                    // Fallback: verwende die globalen Zeiten wenn Tag nicht aktiv
                    calendar.setOption('slotMinTime', calendarMinTime);
                    calendar.setOption('slotMaxTime', calendarMaxTime);
                }
            }
        }
    });

    calendar.render();

    // Responsive Anpassungen beim Resize
    var resizeTimer;
    $(window).on('resize', function() {
        clearTimeout(resizeTimer);
        resizeTimer = setTimeout(function() {
            var newIsMobile = window.innerWidth <= 782;
            if (newIsMobile !== isMobile) {
                isMobile = newIsMobile;
                // View-Anpassung bei Größenänderung
                var currentView = calendar.view.type;
                if (isMobile && (currentView === 'timeGridWeek' || currentView === 'timeGridDay')) {
                    calendar.changeView('dayGridMonth');
                }
                calendar.updateSize();
            } else {
                calendar.updateSize();
            }
        }, 250);
    });

    // Event-Handler für Nachrichten-Modal
    $(document).on('click', '.nachricht-senden-btn-modal', function() {
        var email = $(this).data('email');
        var name = $(this).data('name');
        $('#empfaenger-email').val(email);
        $('#empfaenger-name').text(name);
        $('#reservierung-details-modal').fadeOut(200);
        setTimeout(function() {
            $('#nachrichten-modal').show();
        }, 250);
    });

    // Close button für Nachrichtenmodal (spezifisch für #nachrichten-modal)
    $('#nachrichten-modal').on('click', '.close', function() { 
        $('#nachrichten-modal').hide(); 
    });
    
    $(window).click(function(event) { 
        if (event.target.id === 'nachrichten-modal') { 
            $('#nachrichten-modal').hide(); 
        } 
    });
    
    $('#nachrichten-form').submit(function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        $.ajax({
            url: simpbookKalender.ajaxUrl, 
            type: 'POST',
            data: { 
                action: 'simpbook_sende_nachricht_an_gast', 
                simpbook_form_data: formData, 
                simpbook_nonce: $('#nachricht_nonce').val() 
            },
            beforeSend: function() { 
                $('#nachrichten-form button').prop('disabled', true).text(simpbookKalender.translations.sending); 
            },
            success: function(response) {
                if (response.success) {
                    var successMsg = simpbookKalender.translations.messageSent;
                    if (typeof window.simpbookAlert === 'function') {
                        window.simpbookAlert(successMsg, simpbookKalender.translations.success);
                    } else {
                        alert(successMsg);
                    }
                    $('#nachrichten-modal').hide();
                    $('#nachrichten-form')[0].reset();
                } else {
                    var errorMsg = simpbookKalender.translations.errorColon + response.data;
                    if (typeof window.simpbookAlert === 'function') {
                        window.simpbookAlert(errorMsg, simpbookKalender.translations.error);
                    } else {
                        alert(errorMsg);
                    }
                }
            },
            error: function() {
                var errorMsg = simpbookKalender.translations.generalErrorRetry;
                if (typeof window.simpbookAlert === 'function') {
                    window.simpbookAlert(errorMsg, simpbookKalender.translations.error);
                } else {
                    alert(errorMsg);
                }
            },
            complete: function() { 
                $('#nachrichten-form button').prop('disabled', false).text(simpbookKalender.translations.sendMessage); 
            }
        });
    });

    // Filter anwenden
    $('#apply-filters').on('click', function() {
        var mitarbeiter = $('#simpbook_filter_mitarbeiter').val() || 0;
        var dienstleistung = $('#simpbook_filter_dienstleistung').val() || 0;
        var url = simpbookKalender.baseUrl;
        url += '&simpbook_filter_mitarbeiter=' + mitarbeiter;
        url += '&simpbook_filter_dienstleistung=' + dienstleistung;
        window.location.href = url;
    });

    // Kalender-Abonnement
    var currentToken = null;

    $('#simpbook-calendar-subscribe-form').on('submit', function(e) {
        e.preventDefault();

        var includePast = $('#simpbook_include_past').is(':checked') ? 1 : 0;
        var calendarApp = $('#simpbook_calendar_app').val();
        var nonce = $('#simpbook_calendar_token_nonce').val();

        $.ajax({
            url: simpbookKalender.ajaxUrl,
            type: 'POST',
            data: {
                action: 'simpbook_generate_calendar_token',
                simpbook_include_past: includePast,
                simpbook_calendar_app: calendarApp,
                simpbook_nonce: simpbookKalender.tokenNonce
            },
            success: function(response) {
                if (response.success) {
                    currentToken = response.data.token;
                    var feedUrl = response.data.url;

                    $('#calendar-url-display').text(feedUrl);
                    $('#calendar-url-result').show();
                    $('#delete-calendar-token').show();

                    // Anweisungen für das gewählte Kalenderprogramm
                    var instructions = '';
                    switch(calendarApp) {
                        case 'google':
                            instructions = simpbookKalender.instructions.google;
                            break;
                        case 'outlook':
                            instructions = simpbookKalender.instructions.outlook;
                            break;
                        case 'thunderbird':
                            instructions = simpbookKalender.instructions.thunderbird;
                            break;
                        case 'apple':
                            instructions = simpbookKalender.instructions.apple;
                            break;
                    }
                    $('#calendar-app-instructions').html('<strong>' + instructions + '</strong>');
                } else {
                    alert(response.data || simpbookKalender.translations.errorGenerateUrl);
                }
            },
            error: function() {
                alert(simpbookKalender.translations.generalError);
            }
        });
    });

    $('#delete-calendar-token').on('click', function() {
        if (!currentToken) {
            return;
        }

        if (!confirm(simpbookKalender.translations.confirmDeleteToken)) {
            return;
        }

        var nonce = $('#simpbook_calendar_token_nonce').val();

        $.ajax({
            url: simpbookKalender.ajaxUrl,
            type: 'POST',
            data: {
                action: 'simpbook_delete_calendar_token',
                simpbook_token: currentToken,
                simpbook_nonce: simpbookKalender.tokenNonce
            },
            success: function(response) {
                if (response.success) {
                    currentToken = null;
                    $('#calendar-url-result').hide();
                    $('#delete-calendar-token').hide();
                    alert(simpbookKalender.translations.tokenDeleted);
                } else {
                    alert(response.data || simpbookKalender.translations.errorDeleteToken);
                }
            },
            error: function() {
                alert(simpbookKalender.translations.generalError);
            }
        });
    });
    
    // ============================================
    // Mobile & Tablet Filter Toggle für Kalender
    // ============================================
    var calendarFilterToggle = $('#simpbook-calendar-filter-toggle');
    var calendarFilterPanel = $('#simpbook-calendar-filter-panel');
    
    if (calendarFilterToggle.length && calendarFilterPanel.length) {
        calendarFilterToggle.on('click', function(e) {
            e.preventDefault();
            var isExpanded = $(this).attr('aria-expanded') === 'true';
            $(this).attr('aria-expanded', !isExpanded);
            calendarFilterPanel.toggleClass('show');
        });
        
        $(document).on('click', function(e) {
            if (window.innerWidth <= 1200) {
                if (!$(e.target).closest('.simpbook-calendar-filters').length) {
                    calendarFilterPanel.removeClass('show');
                    calendarFilterToggle.attr('aria-expanded', 'false');
                }
            }
        });
        
        calendarFilterPanel.on('click', function(e) {
            e.stopPropagation();
        });
    }
    
    // ============================================
    // Mitarbeiter-Dropdown im Kalender-Modal
    // ============================================
    $(document).on('change', '#calendar-modal-mitarbeiter-select', function() {
        var $select = $(this);
        var reservierungId = $select.attr('data-reservierung-id');
        var mitarbeiterId = $select.val();
        var $indicator = $('.simpbook-save-indicator');
        
        if (!reservierungId) {
            return;
        }
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'simpbook_update_reservierung_mitarbeiter',
                reservierung_id: reservierungId,
                mitarbeiter_id: mitarbeiterId,
                simpbook_nonce: simpbookKalender.updateMitarbeiterNonce
            },
            success: function(response) {
                if (response.success) {
                    // Zeige Speicher-Indikator
                    $indicator.fadeIn(200);
                    setTimeout(function() {
                        $indicator.fadeOut(400);
                    }, 2000);
                    
                    // Kalenderereignisse neu laden
                    if (typeof calendar !== 'undefined') {
                        calendar.refetchEvents();
                    }
                } else {
                    alert(response.data || 'Fehler beim Speichern des Mitarbeiters.');
                }
            },
            error: function() {
                alert('Fehler beim Speichern des Mitarbeiters.');
            }
        });
    });
});

