jQuery(document).ready(function($) {
    var currentStep = 1;
    var selectedDate = '';
    var selectedService = '';
    var selectedServiceId = '';
    var selectedEmployee = '';
    var selectedEmployeeId = '';
    var selectedTime = '';
    var hasEmployees = true; // Wird auf false gesetzt wenn keine Mitarbeiter existieren

    // Korrigierte Zeilen
    var wochentagZeiten = simpbook_ajax.wochentagZeiten;
    var ausgeschlosseneTage = simpbook_ajax.ausgeschlosseneTage;

    // Datepicker-Übersetzungen basierend auf der aktuellen Plugin-Sprache
    var simpbookDatepickerTranslations = simpbook_ajax.datepickerTranslations;

    function convertDateToYMD(dateStr) {
        if (!dateStr || typeof dateStr !== 'string') return null;
        // Unterstütze sowohl europäisches Format (dd.mm.yyyy) als auch US-Format (mm/dd/yyyy)
        var parts;
        if (dateStr.indexOf('/') !== -1) {
            // US-Format: mm/dd/yyyy
            parts = dateStr.split('/');
            if (parts.length === 3) {
                return parts[2] + '-' + parts[0] + '-' + parts[1];
            }
        } else {
            // Europäisches Format: dd.mm.yyyy
            parts = dateStr.split('.');
            if (parts.length === 3) {
                return parts[2] + '-' + parts[1] + '-' + parts[0];
            }
        }
        return null;
    }

    function isDateAvailable(dateStr /* DD.MM.YYYY */) {
        var ymdDate = convertDateToYMD(dateStr);
        if (!ymdDate) return false;

        if (ausgeschlosseneTage.includes(ymdDate)) {
            return false;
        }

        var dateObj = new Date(ymdDate.replace(/-/g, '/'));
        var day = dateObj.getDay();
        var wochentagKey = ['sonntag', 'montag', 'dienstag', 'mittwoch', 'donnerstag', 'freitag', 'samstag'][day];

        if (wochentagZeiten[wochentagKey] && wochentagZeiten[wochentagKey].aktiv !== '1') {
            return false;
        }
        return true;
    }

    $('.date-option:not(#custom-date-option)').each(function() {
        var dateValue = $(this).data('date-value');
        if (!isDateAvailable(dateValue)) {
            $(this).addClass('disabled-option').off('click');
        }
    });

    function showStep(step) {
        currentStep = parseInt(step);
        $('.reservierung-form-step').removeClass('active');
        $('.reservierung-form-step[data-step="' + currentStep + '"]').addClass('active');

        $('.reservierung-step').removeClass('active completed');
        for (var i = 1; i < currentStep; i++) {
            $('.reservierung-step[data-step="' + i + '"]').addClass('completed');
        }
        $('.reservierung-step[data-step="' + currentStep + '"]').addClass('active');

        if (currentStep === 1) {
            $('.form-button.back').hide().data('prev', '');
            $('.form-button.next').show().data('next', 2);
            $('.form-button.submit').hide();
        } else if (currentStep === 4) {
            $('.form-button.back').show().data('prev', 3);
            $('.form-button.next').hide();
            $('.form-button.submit').show();
            $('#summary-datum').text(selectedDate);
            // Zeitformat für Zusammenfassung anpassen
            var summaryTime = selectedTime;
            if (simpbook_ajax.currentLanguage === 'en_US_AMPM' && selectedTime) {
                // selectedTime ist meist "HH:MM" oder "H:MM" (24h)
                var timeParts = selectedTime.split(':');
                if (timeParts.length >= 2) {
                    var hour = parseInt(timeParts[0], 10);
                    var minute = timeParts[1];
                    var ampm = hour >= 12 ? 'PM' : 'AM';
                    var hour12 = hour % 12;
                    if (hour12 === 0) hour12 = 12;
                    summaryTime = hour12 + ':' + minute + ' ' + ampm;
                }
            }
            $('#summary-uhrzeit').text(summaryTime);
            $('#summary-dienstleistung').text(selectedService || '-');
            
            // Mitarbeiter-Zeile nur anzeigen wenn Mitarbeiter existieren
            if (hasEmployees) {
                $('#summary-mitarbeiter').text(selectedEmployee || (simpbook_ajax.translations.noSpecificEmployee || 'Kein bestimmter Mitarbeiter'));
                $('.summary-label-mitarbeiter').show();
                $('#summary-mitarbeiter').show();
                $('.summary-br-mitarbeiter').show();
            } else {
                $('.summary-label-mitarbeiter').hide();
                $('#summary-mitarbeiter').hide();
                $('.summary-br-mitarbeiter').hide();
            }
            
            $('#summary-name').text($('#simpbook_name').val());
            $('#summary-email').text($('#simpbook_email').val());
            $('#summary-telefon').text($('#simpbook_telefon').val());
            $('#summary-nachricht').text($('#simpbook_nachricht').val() || (simpbook_ajax.translations.noMessage || 'Keine'));
        } else {
            $('.form-button.back').show().data('prev', currentStep - 1);
            $('.form-button.next').show().data('next', currentStep + 1);
            $('.form-button.submit').hide();
        }
    }

    $('.date-option:not(#custom-date-option)').on('click', function() {
        if ($(this).hasClass('disabled-option')) return;

        $('.date-option').removeClass('selected');
        $(this).addClass('selected');
        selectedDate = $(this).data('date-value');
        $('#simpbook_datum').val(selectedDate);

        $('#selected-date-display').show();
        $('#display-date').text(selectedDate);

        // Wenn bereits eine Dienstleistung ausgewählt wurde, Mitarbeiter neu laden (mit Datum)
        if (selectedServiceId) {
            loadEmployeesForService(selectedServiceId);
        }

        resetServiceAndTime();
    });

    // Bestimme Datumsformat und firstDay basierend auf Sprache
    var dateFormat = 'dd.mm.yy';
    var firstDay = 1; // Montag
    if (simpbook_ajax.currentLanguage === 'en_US_AMPM') {
        dateFormat = 'mm/dd/yy';
        firstDay = 0; // Sonntag
    }

    $("#simpbook_datum").datepicker({
        dateFormat: dateFormat,
        minDate: 0,
        firstDay: firstDay,
        monthNames: simpbookDatepickerTranslations.monthNames,
        monthNamesShort: simpbookDatepickerTranslations.monthNamesShort,
        dayNames: simpbookDatepickerTranslations.dayNames,
        dayNamesShort: simpbookDatepickerTranslations.dayNamesShort,
        dayNamesMin: simpbookDatepickerTranslations.dayNamesMin,
        beforeShowDay: function(date) {
            var stringDate = $.datepicker.formatDate('yy-mm-dd', date);
            var day = date.getDay();
            var wochentagKey = ['sonntag', 'montag', 'dienstag', 'mittwoch', 'donnerstag', 'freitag', 'samstag'][day];

            var istAusgeschlossen = ausgeschlosseneTage.includes(stringDate);
            var istWochentagAktiv = (wochentagZeiten[wochentagKey] && wochentagZeiten[wochentagKey].aktiv === '1');

            if (istAusgeschlossen || !istWochentagAktiv) {
                return [false, 'ui-state-disabled', simpbook_ajax.translations.notAvailable || 'Nicht verfügbar'];
            }
            return [true, '', simpbook_ajax.translations.available || 'Verfügbar'];
        },
        beforeShow: function(input, inst) {
            setTimeout(function() {
                inst.dpDiv.css({
                    top: ($(window).height() - inst.dpDiv.outerHeight()) / 2 + $(window).scrollTop(),
                    left: ($(window).width() - inst.dpDiv.outerWidth()) / 2 + $(window).scrollLeft()
                });
            }, 0);
        },
        onSelect: function(dateText, inst) {
            selectedDate = dateText;

            $('#custom-date-display').text(dateText);
            $('.date-option').removeClass('selected');
            $('#custom-date-option').addClass('selected');
            $('#display-date').text(dateText);
            $('#selected-date-display').show();

            // Wenn bereits eine Dienstleistung ausgewählt wurde, Mitarbeiter neu laden (mit Datum)
            if (selectedServiceId) {
                loadEmployeesForService(selectedServiceId);
            }

            resetServiceAndTime();
        }
    });

    // Debug-Funktion für mobile Geräte
    function isMobileDevice() {
        return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) || 
               window.innerWidth <= 768;
    }

    // Verbesserte Touch-Behandlung - unterscheidet zwischen Scrollen und Tippen
    var touchStartData = {};
    
    function handleServiceSelection($element) {
        selectedServiceId = $element.data('service-id');
        selectedService = $element.data('service-name');
        $('.service-card').removeClass('selected');
        $element.addClass('selected');
        $('#simpbook_dienstleistung_id').val(selectedServiceId);

        // Mitarbeiter für diese Dienstleistung laden
        loadEmployeesForService(selectedServiceId);

        // Zeit-Auswahl verstecken (wird später wieder gezeigt)
        $('#time-selection-group').hide();
        selectedEmployeeId = 0;
        selectedEmployee = '';
        $('#simpbook_mitarbeiter_id').val(0);
    }

    // Touch Start - speichere Position und Zeit
    $(document).on('touchstart', '.service-card:not(.disabled)', function(e) {
        var touch = e.originalEvent.touches[0];
        touchStartData[this] = {
            startX: touch.clientX,
            startY: touch.clientY,
            startTime: Date.now(),
            element: $(this)
        };
    });

    // Touch End - prüfe ob es ein Tap oder Scroll war
    $(document).on('touchend', '.service-card:not(.disabled)', function(e) {
        var touchData = touchStartData[this];
        if (!touchData) return;
        
        var touch = e.originalEvent.changedTouches[0];
        var deltaX = Math.abs(touch.clientX - touchData.startX);
        var deltaY = Math.abs(touch.clientY - touchData.startY);
        var duration = Date.now() - touchData.startTime;
        
        // Nur als Tap werten wenn:
        // - Bewegung unter 15px (kein Scrollen)
        // - Dauer unter 500ms (kein langes Drücken)
        if (deltaX < 15 && deltaY < 15 && duration < 500) {
            e.preventDefault();
            handleServiceSelection(touchData.element);
        }
        
        delete touchStartData[this];
    });
    
    // Click Event für Desktop
    $(document).on('click', '.service-card:not(.disabled)', function(e) {
        // Nur auf Desktop oder wenn Touch-Daten nicht vorhanden sind
        if (!isMobileDevice() || !touchStartData[this]) {
            handleServiceSelection($(this));
        }
    });

    // Verbesserte Mitarbeiter-Auswahl mit korrekter Touch-Behandlung
    function handleEmployeeSelection($element) {
        // Verhindere Klick auf Fehlermeldung
        if ($element.closest('.employee-error-message').length > 0) {
            return;
        }
        
        selectedEmployeeId = $element.data('employee-id') || 0;
        selectedEmployee = $element.data('employee-name') || '';
        $('.employee-card').removeClass('selected');
        $element.addClass('selected');
        $('#simpbook_mitarbeiter_id').val(selectedEmployeeId);

        // Uhrzeiten laden und anzeigen
        if (selectedDate && selectedServiceId) {
            getAvailableTimes(selectedDate, selectedServiceId, selectedEmployeeId);
        }
    }
    
    // Touch Start für Mitarbeiter
    $(document).on('touchstart', '.employee-card:not(.disabled)', function(e) {
        var touch = e.originalEvent.touches[0];
        touchStartData[this] = {
            startX: touch.clientX,
            startY: touch.clientY,
            startTime: Date.now(),
            element: $(this)
        };
    });

    // Touch End für Mitarbeiter
    $(document).on('touchend', '.employee-card:not(.disabled)', function(e) {
        var touchData = touchStartData[this];
        if (!touchData) return;
        
        var touch = e.originalEvent.changedTouches[0];
        var deltaX = Math.abs(touch.clientX - touchData.startX);
        var deltaY = Math.abs(touch.clientY - touchData.startY);
        var duration = Date.now() - touchData.startTime;
        
        // Nur als Tap werten wenn kein Scrollen
        if (deltaX < 15 && deltaY < 15 && duration < 500) {
            e.preventDefault();
            handleEmployeeSelection(touchData.element);
        }
        
        delete touchStartData[this];
    });
    
    // Click Event für Desktop (Mitarbeiter)
    $(document).on('click', '.employee-card:not(.disabled)', function(e) {
        if (!isMobileDevice() || !touchStartData[this]) {
            handleEmployeeSelection($(this));
        }
    });

    // Funktion zum Laden der Mitarbeiter für eine Dienstleistung
    function loadEmployeesForService(serviceId) {
        if (!serviceId) {
            $('#employee-selection-group').hide();
            return;
        }

        // Prüfe ob ein Datum ausgewählt wurde
        if (!selectedDate) {
            loadEmployeesForServiceWithoutDate(serviceId);
            return;
        }
        $('#employee-selection').html('<div class="employee-card disabled">' + (simpbook_ajax.translations.loadingEmployees || 'Lade Mitarbeiter...') + '</div>');
        $('#employee-selection-group').show(); // Sofort zeigen damit Lade-Status sichtbar ist

        $.ajax({
            url: simpbook_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_mitarbeiter_fuer_dienstleistung',
                simpbook_dienstleistung_id: serviceId,
                simpbook_datum: selectedDate, // Datum mitsenden
                simpbook_nonce: simpbook_ajax.mitarbeiter_nonce || simpbook_ajax.times_nonce
            },
            success: function(response) {
                if (response.success && response.data) {
                    var mitarbeiterListe = response.data.mitarbeiter || response.data; // Rückwärtskompatibilität
                    var hasAvailableEmployees = response.data.has_available_employees !== undefined ? response.data.has_available_employees : (mitarbeiterListe.length > 0);
                    var hasEmployeesResponse = response.data.has_employees !== undefined ? response.data.has_employees : true; // Ob überhaupt Mitarbeiter existieren

                    // Globale Variable setzen
                    hasEmployees = hasEmployeesResponse;

                    // WICHTIG: Wenn keine Mitarbeiter existieren, Mitarbeiterauswahl komplett überspringen
                    if (!hasEmployees) {
                        // Keine Mitarbeiter in der Datenbank - Schritt überspringen
                        $('#employee-selection-group').hide();
                        selectedEmployeeId = 0;
                        selectedEmployee = '';
                        $('#simpbook_mitarbeiter_id').val(0);
                        
                        // Direkt Zeiten laden
                        if (selectedDate && selectedServiceId) {
                            getAvailableTimes(selectedDate, selectedServiceId, 0);
                        }
                        return; // Funktion beenden
                    }

                    // Wenn kein Datum ausgewählt wurde oder Mitarbeiter verfügbar sind, normal anzeigen
                    if (!selectedDate || hasAvailableEmployees) {
                        var html = '';

                        // Option für "Kein bestimmter Mitarbeiter" nur anzeigen, wenn:
                        // 1. Mehr als 1 Mitarbeiter verfügbar ist UND
                        // 2. Mindestens einer dieser Mitarbeiter KEINE individuellen Arbeitszeiten hat
                        var hasEmployeeWithoutCustomHours = response.data.has_employee_without_custom_hours !== undefined ? response.data.has_employee_without_custom_hours : true; // Fallback

                        if (mitarbeiterListe.length > 1 && hasEmployeeWithoutCustomHours) {
                            html += '<div class="employee-card" data-employee-id="0" data-employee-name="">';
                            html += '<div class="employee-card-content">';
                            html += '<div class="employee-name">' + (simpbook_ajax.translations.noSpecificEmployee || 'Kein bestimmter Mitarbeiter') + '</div>';
                            html += '</div>';
                            html += '</div>';
                        }

                        // Mitarbeiter hinzufügen, falls vorhanden
                        if (mitarbeiterListe.length > 0) {
                            $.each(mitarbeiterListe, function(index, mitarbeiter) {
                                html += '<div class="employee-card" data-employee-id="' + mitarbeiter.id + '" data-employee-name="' + (mitarbeiter.name || '') + '">';
                                html += '<div class="employee-card-content">';
                                if (mitarbeiter.profilfoto_url) {
                                    html += '<div class="employee-photo-wrapper">';
                                    html += '<img src="' + mitarbeiter.profilfoto_url + '" alt="' + (mitarbeiter.name || '') + '" class="employee-photo">';
                                    html += '</div>';
                                }
                                html += '<div class="employee-name">' + (mitarbeiter.name || '') + '</div>';
                                html += '</div>';
                                html += '</div>';
                            });
                        }

                        $('#employee-selection').html(html);
                        $('#employee-selection-group').show();
                        
                        // SOFORTIGE CSS-REPARATUR für mobile Geräte
                        if (isMobileDevice()) {
                            // Entferne alle CSS-Animationen und Transitions die das Problem verursachen könnten
                            $('#employee-selection-group, #employee-selection, .employee-card').css({
                                'transition': 'none',
                                'animation': 'none',
                                'transform': 'none'
                            });
                            
                            // Setze wichtige Styles sofort
                            $('#employee-selection-group').attr('style', 
                                'display: block !important; ' +
                                'visibility: visible !important; ' +
                                'opacity: 1 !important; ' +
                                'height: auto !important; ' +
                                'min-height: 100px !important; ' +
                                'overflow: visible !important;'
                            );
                        }
                        
                        // Zeit-Auswahl verstecken bis Mitarbeiter ausgewählt wurde
                        $('#time-selection-group').hide();
                        // Keine automatische Auswahl - Benutzer muss selbst wählen
                        selectedEmployeeId = 0;
                        selectedEmployee = '';
                        $('#simpbook_mitarbeiter_id').val(0);
                    } else {
                        // Keine Mitarbeiter verfügbar - Fehlermeldung anzeigen und verfügbare Tage laden
                        showNoEmployeesAvailableMessage(serviceId);
                    }
                } else {
                    // Fehler oder keine Daten
                    if (selectedDate) {
                        showNoEmployeesAvailableMessage(serviceId);
                    } else {
                        // Kein Datum - normal anzeigen
                        var html = '';
                        html += '<div class="employee-card" data-employee-id="0" data-employee-name="">';
                        html += '<div class="employee-card-content">';
                        html += '<div class="employee-name">' + (simpbook_ajax.translations.noSpecificEmployee || 'Kein bestimmter Mitarbeiter') + '</div>';
                        html += '</div>';
                        html += '</div>';
                        $('#employee-selection').html(html);
                        $('#employee-selection-group').show();
                        // Keine automatische Auswahl - Benutzer muss selbst wählen
                        selectedEmployeeId = 0;
                        selectedEmployee = '';
                        $('#simpbook_mitarbeiter_id').val('0');
                        $('#time-selection-group').hide();
                    }
                }
            },
            error: function(xhr, status, error) {
                console.error('Fehler beim Laden der Mitarbeiter:', error);
                // Auch bei Fehler "Kein bestimmter Mitarbeiter" anzeigen
                var html = '';
                html += '<div class="employee-card" data-employee-id="0" data-employee-name="">';
                html += '<div class="employee-card-content">';
                html += '<div class="employee-name">' + (simpbook_ajax.translations.noSpecificEmployee || 'Kein bestimmter Mitarbeiter') + '</div>';
                html += '</div>';
                html += '</div>';
                $('#employee-selection').html(html);
                $('#employee-selection-group').show();
                // Keine automatische Auswahl - Benutzer muss selbst wählen
                selectedEmployeeId = 0;
                selectedEmployee = '';
                $('#simpbook_mitarbeiter_id').val('0');
                $('#time-selection-group').hide();
            }
        });
    }

    // Funktion zum Laden der Mitarbeiter ohne Datum (Fallback)
    function loadEmployeesForServiceWithoutDate(serviceId) {
        $('#employee-selection').html('<div class="employee-card disabled">' + (simpbook_ajax.translations.loadingEmployees || 'Lade Mitarbeiter...') + '</div>');
        $('#employee-selection-group').show();

        $.ajax({
            url: simpbook_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_mitarbeiter_fuer_dienstleistung',
                simpbook_dienstleistung_id: serviceId,
                simpbook_nonce: simpbook_ajax.mitarbeiter_nonce || simpbook_ajax.times_nonce
            },
            success: function(response) {
                if (response.success && response.data) {
                    var mitarbeiterListe = response.data.mitarbeiter || response.data;
                    var hasEmployeesResponse = response.data.has_employees !== undefined ? response.data.has_employees : true;
                    
                    // Globale Variable setzen
                    hasEmployees = hasEmployeesResponse;
                    
                    // Wenn keine Mitarbeiter existieren, Schritt überspringen
                    if (!hasEmployees || mitarbeiterListe.length === 0) {
                        $('#employee-selection-group').hide();
                        selectedEmployeeId = 0;
                        selectedEmployee = '';
                        $('#simpbook_mitarbeiter_id').val(0);
                        
                        // Direkt Zeiten laden falls Datum vorhanden
                        if (selectedDate && selectedServiceId) {
                            getAvailableTimes(selectedDate, selectedServiceId, 0);
                        }
                        return;
                    }
                    
                    var html = '';

                    if (mitarbeiterListe.length > 1) {
                        html += '<div class="employee-card" data-employee-id="0" data-employee-name="">';
                        html += '<div class="employee-card-content">';
                        html += '<div class="employee-name">' + (simpbook_ajax.translations.noSpecificEmployee || 'Kein bestimmter Mitarbeiter') + '</div>';
                        html += '</div>';
                        html += '</div>';
                    }

                    if (mitarbeiterListe.length > 0) {
                        $.each(mitarbeiterListe, function(index, mitarbeiter) {
                            html += '<div class="employee-card" data-employee-id="' + mitarbeiter.id + '" data-employee-name="' + (mitarbeiter.name || '') + '">';
                            html += '<div class="employee-card-content">';
                            if (mitarbeiter.profilfoto_url) {
                                html += '<div class="employee-photo-wrapper">';
                                html += '<img src="' + mitarbeiter.profilfoto_url + '" alt="' + (mitarbeiter.name || '') + '" class="employee-photo">';
                                html += '</div>';
                            }
                            html += '<div class="employee-name">' + (mitarbeiter.name || '') + '</div>';
                            html += '</div>';
                            html += '</div>';
                        });
                    }

                    $('#employee-selection').html(html);
                    $('#employee-selection-group').show();
                }
            },
            error: function() {
                $('#employee-selection-group').hide();
            }
        });
    }

    $(document).on('click', '.time-option:not(.disabled)', function() {
        selectedTime = $(this).data('time');
        $('.time-option').removeClass('selected');
        $(this).addClass('selected');
        $('#simpbook_uhrzeit').val(selectedTime);
    });

    // Funktion zum Anzeigen der Fehlermeldung wenn keine Mitarbeiter verfügbar sind
    function showNoEmployeesAvailableMessage(serviceId) {
        // Lade verfügbare Tage
        $.ajax({
            url: simpbook_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_available_dates_for_service',
                simpbook_dienstleistung_id: serviceId,
                simpbook_nonce: simpbook_ajax.mitarbeiter_nonce || simpbook_ajax.times_nonce
            },
            success: function(response) {
                var html = '<div class="employee-error-message" style="background: #bd4d4d; border: 1px solid #a04444; border-radius: 8px; padding: 20px; margin: 20px 0;">';
                html += '<h3 style="margin-top: 0; color: #ffffff;">' + (simpbook_ajax.translations.noEmployeesAvailable || 'Keine Mitarbeiter verfügbar') + '</h3>';
                html += '<p style="color: #ffffff; margin-bottom: 15px;">' + (simpbook_ajax.translations.noEmployeesAvailableDesc || 'Für den ausgewählten Tag sind keine Mitarbeiter verfügbar, die diese Dienstleistung durchführen können. Bitte wählen Sie einen anderen Tag.') + '</p>';

                if (response.success && response.data && response.data.wochentage && response.data.wochentage.length > 0) {
                    // Erstelle Abkürzungen für Wochentage (übersetzbar)
                    var wochentagAbkuerzungen = {
                        'montag': simpbook_ajax.translations.weekdayMo || 'Mo',
                        'dienstag': simpbook_ajax.translations.weekdayDi || 'Di',
                        'mittwoch': simpbook_ajax.translations.weekdayMi || 'Mi',
                        'donnerstag': simpbook_ajax.translations.weekdayDo || 'Do',
                        'freitag': simpbook_ajax.translations.weekdayFr || 'Fr',
                        'samstag': simpbook_ajax.translations.weekdaySa || 'Sa',
                        'sonntag': simpbook_ajax.translations.weekdaySo || 'So'
                    };

                    var tageListe = [];
                    $.each(response.data.wochentage, function(index, tag) {
                        tageListe.push(wochentagAbkuerzungen[tag.key] || tag.name);
                    });

                    html += '<p style="color: #ffffff; font-weight: 600; margin-bottom: 10px;">' + (simpbook_ajax.translations.serviceOfferedOnDays || 'Diese Dienstleistung wird nur an folgenden Tagen angeboten:') + '</p>';
                    html += '<p style="color: #ffffff; font-size: 18px; font-weight: 600; margin: 0;">' + tageListe.join(' ') + '</p>';
                }
                html += '</div>';

                $('#employee-selection').html(html);
                $('#employee-selection-group').show();

                // Zeitauswahl deaktivieren
                $('#time-selection').html('<div class="time-option disabled">' + (simpbook_ajax.translations.pleaseSelectAnotherDay || 'Bitte wählen Sie einen anderen Tag') + '</div>');
                resetTime();
            },
            error: function() {
                var html = '<div class="employee-error-message" style="background: #bd4d4d; border: 1px solid #a04444; border-radius: 8px; padding: 20px; margin: 20px 0;">';
                html += '<h3 style="margin-top: 0; color: #ffffff;">' + (simpbook_ajax.translations.noEmployeesAvailable || 'Keine Mitarbeiter verfügbar') + '</h3>';
                html += '<p style="color: #ffffff;">' + (simpbook_ajax.translations.noEmployeesAvailableDesc || 'Für den ausgewählten Tag sind keine Mitarbeiter verfügbar, die diese Dienstleistung durchführen können. Bitte wählen Sie einen anderen Tag.') + '</p>';
                html += '</div>';

                $('#employee-selection').html(html);
                $('#employee-selection-group').show();

                // Zeitauswahl deaktivieren
                $('#time-selection').html('<div class="time-option disabled">' + (simpbook_ajax.translations.pleaseSelectAnotherDay || 'Bitte wählen Sie einen anderen Tag') + '</div>');
                resetTime();
            }
        });
    }

    function resetServiceAndTime() {
        $('.service-card').removeClass('selected');
        selectedService = '';
        selectedServiceId = '';
        $('#simpbook_dienstleistung_id').val('');
        $('#employee-selection-group').hide();
        $('#time-selection-group').hide();
        $('.employee-card').removeClass('selected');
        selectedEmployee = '';
        selectedEmployeeId = '';
        $('#simpbook_mitarbeiter_id').val('0');
        $('#time-selection').html('<div class="time-option disabled">' + (simpbook_ajax.translations.pleaseSelectDateAndService || 'Bitte zuerst Datum und Dienstleistung wählen') + '</div>');
        selectedTime = '';
        $('#simpbook_uhrzeit').val('');
    }

    function resetTime() {
        $('#time-selection-group').hide();
        $('#time-selection').html('<div class="time-option disabled">' + (simpbook_ajax.translations.pleaseSelectDateAndService || 'Bitte zuerst Datum und Dienstleistung wählen') + '</div>');
        selectedTime = '';
        $('#simpbook_uhrzeit').val('');
    }

    function getAvailableTimes(date, serviceId, employeeId) {
        if (!serviceId) {
            $('#time-selection').html('<div class="time-option disabled">' + (simpbook_ajax.translations.pleaseSelectService || 'Bitte zuerst eine Dienstleistung wählen') + '</div>');
            return;
        }

        // Zeige die Zeit-Auswahl-Gruppe
        $('#time-selection-group').show();
        $('#time-selection').html('<div class="time-option disabled">' + (simpbook_ajax.translations.loadingTimes || 'Lade Zeiten...') + '</div>');

        $.ajax({
            url: simpbook_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_get_available_times',
                simpbook_datum: date,
                simpbook_dienstleistung_id: serviceId,
                simpbook_mitarbeiter_id: employeeId || 0,
                simpbook_exclude_simpbook_reservierung_id: 0,
                simpbook_nonce: simpbook_ajax.times_nonce
            },
            success: function(response) {
                if (response.success) {
                    var options = $(response.data);
                    var timeOptions = '';

                    options.each(function() {
                        var option = $(this);
                        if (option.val() && !option.is(':disabled')) {
                            timeOptions += '<div class="time-option" data-time="' + option.val() + '">' + option.text() + '</div>';
                        } else if (option.is(':disabled')) {
                            timeOptions += '<div class="time-option disabled">' + option.text().replace('(Ausgebucht)', '').trim() + '</div>';
                        }
                    });

                    $('#time-selection').html(timeOptions || '<div class="time-option disabled">' + (simpbook_ajax.translations.noTimesAvailable || 'Keine verfügbaren Zeiten') + '</div>');
                    
                    // CSS-Reparatur für Uhrzeiten auf mobilen Geräten
                    if (isMobileDevice()) {
                        // Entferne alle CSS-Animationen und Transitions
                        $('#time-selection-group, #time-selection, .time-option').css({
                            'transition': 'none',
                            'animation': 'none',
                            'transform': 'none'
                        });
                        
                        // Setze wichtige Styles sofort
                        $('#time-selection-group').attr('style', 
                            'display: block !important; ' +
                            'visibility: visible !important; ' +
                            'opacity: 1 !important; ' +
                            'height: auto !important; ' +
                            'min-height: 100px !important; ' +
                            'overflow: visible !important;'
                        );
                    }
                } else {
                    $('#time-selection').html('<div class="time-option disabled">' + (response.data || simpbook_ajax.translations.error || 'Fehler') + '</div>');
                }
            },
            error: function() {
                $('#time-selection').html('<div class="time-option disabled">' + (simpbook_ajax.translations.errorLoading || 'Fehler beim Laden') + '</div>');
            }
        });
    }

    $('.form-button').click(function(e) {
        if ($(this).hasClass('submit')) {
            return;
        }
        e.preventDefault();

        var $thisButton = $(this);
        var nextStep = $thisButton.data('next');
        var prevStep = $thisButton.data('prev');

        if (currentStep === 1 && nextStep) {
            if (!selectedDate) {
                $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text(simpbook_ajax.translations.pleaseSelectDate || 'Bitte wählen Sie ein Datum aus.').show();
                return;
            }
        }
        if (currentStep === 2 && nextStep) {
            selectedServiceId = $('#simpbook_dienstleistung_id').val();
            selectedTime = $('#simpbook_uhrzeit').val();
            if (!selectedServiceId) {
                 $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text(simpbook_ajax.translations.pleaseSelectService || 'Bitte wählen Sie eine Dienstleistung aus.').show();
                return;
            }
            if (!selectedTime) {
                 $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text(simpbook_ajax.translations.pleaseSelectTime || 'Bitte wählen Sie eine Uhrzeit aus.').show();
                return;
            }
        }
        if (currentStep === 3 && nextStep) {
             if (!$('#simpbook_name').val() || !$('#simpbook_email').val() || !$('#simpbook_telefon').val()) {
                $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text(simpbook_ajax.translations.pleaseFillAllFields || 'Bitte füllen Sie alle Pflichtfelder (Name, E-Mail, Telefon) aus.').show();
                return;
            }
            var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            if (!emailRegex.test($('#simpbook_email').val())) {
                $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text(simpbook_ajax.translations.invalidEmail || 'Bitte geben Sie eine gültige E-Mail-Adresse ein.').show();
                return;
            }
            var telefonRegex = /^[0-9\s+()/.-]+$/;
            if (!telefonRegex.test($('#simpbook_telefon').val())) {
                $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text(simpbook_ajax.translations.invalidPhone || 'Bitte geben Sie eine gültige Telefonnummer ein.').show();
                return;
            }
        }

        $('.reservierung-nachricht').hide();

        if (nextStep) {
            showStep(nextStep);
        } else if (prevStep) {
            showStep(prevStep);
        }
    });

    $('#reservierung-formular').submit(function(e) {
        e.preventDefault();

        if (!selectedDate || !$('#simpbook_dienstleistung_id').val() || !$('#simpbook_uhrzeit').val() || !$('#simpbook_name').val() || !$('#simpbook_email').val() || !$('#simpbook_telefon').val()) {
            $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text(simpbook_ajax.translations.pleaseFillAllSteps || 'Bitte füllen Sie alle Schritte und Pflichtfelder korrekt aus.').show();
            showStep(1);
            return;
        }

        $('.form-button.submit').prop('disabled', true).text(simpbook_ajax.translations.sending || 'Senden...');
        $('.reservierung-nachricht').hide();

        $.ajax({
            url: simpbook_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'simpbook_reservierung_speichern',
                simpbook_datum: selectedDate,
                simpbook_uhrzeit: $('#simpbook_uhrzeit').val(),
                simpbook_dienstleistung_id: $('#simpbook_dienstleistung_id').val(),
                simpbook_mitarbeiter_id: $('#simpbook_mitarbeiter_id').val() || 0,
                simpbook_name: $('#simpbook_name').val(),
                simpbook_email: $('#simpbook_email').val(),
                simpbook_telefon: $('#simpbook_telefon').val(),
                simpbook_nachricht: $('#simpbook_nachricht').val(),
                simpbook_nonce: simpbook_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $('.reservierung-nachricht').removeClass('fehler').addClass('erfolg').text(response.data || simpbook_ajax.translations.reservationSent || 'Reservierung erfolgreich!').show();
                    $('#reservierung-formular')[0].reset();
                    $('.form-button.submit').prop('disabled', false).text(simpbook_ajax.translations.submitReservation || 'Reservierung absenden');

                    selectedDate = '';
                    selectedService = '';
                    selectedServiceId = '';
                    selectedEmployee = '';
                    selectedEmployeeId = '';
                    selectedTime = '';
                    $('#selected-date-display').hide();
                    $('#display-date').text('');
                    $('.date-option').removeClass('selected');
                    $('#custom-date-display').text(simpbook_ajax.translations.selectDate || 'Wähle ein Datum');
                    resetServiceAndTime();
                    showStep(1);
                } else {
                    $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text(response.data || simpbook_ajax.translations.errorOccurred || 'Ein Fehler ist aufgetreten.').show();
                    $('.form-button.submit').prop('disabled', false).text(simpbook_ajax.translations.submitReservation || 'Reservierung absenden');
                }
            },
            error: function(xhr, status, error) {
                $('.reservierung-nachricht').removeClass('erfolg').addClass('fehler').text((simpbook_ajax.translations.errorOccurredTryLater || 'Es ist ein Fehler aufgetreten. Bitte versuchen Sie es später erneut.') + ': ' + error).show();
                $('.form-button.submit').prop('disabled', false).text(simpbook_ajax.translations.submitReservation || 'Reservierung absenden');
            }
        });
    });
    
    // Service Description Modal Functionality
    var $modal = $('#service-description-modal');
    var $modalTitle = $('#service-description-title');
    var $modalText = $('#service-description-text');
    var hoverTimeout = null;
    
    // Modal in den body verschieben um Positionierungsprobleme zu vermeiden
    if ($modal.length && !$modal.parent().is('body')) {
        $modal.appendTo('body');
    }
    
    $(document).on('mouseenter', '.service-card[data-service-description]:not([data-service-description=""])', function(e) {
        var $card = $(this);
        var description = $card.data('service-description');
        var serviceName = $card.data('service-name');
        
        if (!description) return;
        
        // Verzögerung von 300ms bevor Modal angezeigt wird
        hoverTimeout = setTimeout(function() {
            // Modal-Inhalt setzen
            $modalTitle.text(serviceName);
            
            // Beschreibung mit Zeilenumbrüchen formatieren
            var formattedDescription = description
                .replace(/\n\n+/g, '<br><br>') // Doppelte Umbrüche mit mehr Abstand
                .replace(/\n/g, '<br>');        // Einfache Umbrüche
            $modalText.html(formattedDescription);
            
            // Modal temporär sichtbar machen (ohne Opacity) um Größe zu messen
            $modal.css({
                'display': 'block',
                'visibility': 'hidden'
            });
            $modal.removeClass('visible');
            
            // Kurz warten damit Browser das Layout berechnet hat
            requestAnimationFrame(function() {
                // Position berechnen
                var cardRect = $card[0].getBoundingClientRect();
                var modalWidth = $modal.outerWidth();
                var modalHeight = $modal.outerHeight();
                
                // Viewport-Dimensionen
                var viewportWidth = $(window).width();
                var viewportHeight = $(window).height();
                
                // Ermittle ob Karte in linker oder rechter Spalte ist
                var cardCenterX = cardRect.left + (cardRect.width / 2);
                var viewportCenterX = viewportWidth / 2;
                var isLeftColumn = cardCenterX < viewportCenterX;
                
                var left, top;
                var spacing = 15; // Abstand zwischen Karte und Modal
                var margin = 10; // Mindestabstand zum Viewport-Rand
                
                // Horizontale Position berechnen
                if (isLeftColumn) {
                    // Karte ist in linker Spalte -> versuche Modal links zu öffnen
                    left = cardRect.left - modalWidth - spacing;
                    
                    // Falls nicht genug Platz links, dann rechts
                    if (left < margin) {
                        left = cardRect.right + spacing;
                        // Falls auch rechts nicht genug Platz, dann zentriert über der Karte
                        if (left + modalWidth > viewportWidth - margin) {
                            left = cardRect.left + (cardRect.width / 2) - (modalWidth / 2);
                        }
                    }
                } else {
                    // Karte ist in rechter Spalte -> versuche Modal rechts zu öffnen
                    left = cardRect.right + spacing;
                    
                    // Falls nicht genug Platz rechts, dann links
                    if (left + modalWidth > viewportWidth - margin) {
                        left = cardRect.left - modalWidth - spacing;
                        // Falls auch links nicht genug Platz, dann zentriert über der Karte
                        if (left < margin) {
                            left = cardRect.left + (cardRect.width / 2) - (modalWidth / 2);
                        }
                    }
                }
                
                // Stelle sicher, dass left innerhalb des Viewports bleibt
                left = Math.max(margin, Math.min(left, viewportWidth - modalWidth - margin));
                
                // Vertikale Position: Modal vertikal zur Karte zentrieren
                top = cardRect.top + (cardRect.height / 2) - (modalHeight / 2);
                
                // Prüfe ob Modal unten aus dem Viewport läuft
                if (top + modalHeight > viewportHeight - margin) {
                    top = viewportHeight - modalHeight - margin;
                }
                
                // Prüfe ob Modal oben aus dem Viewport läuft
                if (top < margin) {
                    top = margin;
                }
                
                // Debug-Ausgabe (kann später entfernt werden)
                console.log('Modal Position:', {
                    cardTop: cardRect.top,
                    cardBottom: cardRect.bottom,
                    modalTop: top,
                    modalHeight: modalHeight,
                    viewportHeight: viewportHeight
                });
                
                // Modal positionieren und sichtbar machen
                $modal.css({
                    'left': left + 'px',
                    'top': top + 'px',
                    'visibility': 'visible'
                });
                
                // Sichtbar machen mit Animation
                requestAnimationFrame(function() {
                    $modal.addClass('visible');
                });
            });
        }, 300);
    });
    
    $(document).on('mouseleave', '.service-card[data-service-description]:not([data-service-description=""])', function() {
        // Timeout abbrechen falls Maus schnell bewegt wurde
        if (hoverTimeout) {
            clearTimeout(hoverTimeout);
            hoverTimeout = null;
        }
        
        // Modal ausblenden
        $modal.removeClass('visible');
        setTimeout(function() {
            if (!$modal.hasClass('visible')) {
                $modal.css('display', 'none');
            }
        }, 200);
    });
    
    // Modal auch beim Mouseover schließen (falls Benutzer auf Modal bewegt)
    $modal.on('mouseenter', function() {
        $(this).removeClass('visible');
        setTimeout(function() {
            $modal.css('display', 'none');
        }, 200);
    });
    
    // Country Code Selector for Phone Input
    // Get localized country names based on Plugin language setting from settings page
    // Map plugin language codes to locale codes that Intl.DisplayNames understands
    var pluginLanguage = simpbook_ajax.currentLanguage || 'de_DE';
    var localeMap = {
        'de_DE': 'de',
        'en_US': 'en-US',
        'en_GB': 'en-GB',
        'en_US_AMPM': 'en-US',
        'it_IT': 'it',
        'es_ES': 'es',
        'fr_FR': 'fr',
        'pl_PL': 'pl',
        'ru_RU': 'ru',
        'sv_SE': 'sv'
    };
    
    var userLocale = localeMap[pluginLanguage] || 'en-US';
    var regionNames;
    
    // Try to create Intl.DisplayNames with plugin's locale, fallback to English if not supported
    try {
        regionNames = new Intl.DisplayNames([userLocale, 'en'], { type: 'region' });
    } catch (e) {
        regionNames = new Intl.DisplayNames(['en'], { type: 'region' });
    }
    
    // Function to get localized country name
    function getCountryName(code) {
        try {
            return regionNames.of(code);
        } catch (e) {
            return code; // Fallback to country code if translation fails
        }
    }
    
    // Country list with codes, dial codes, and flags - names are generated dynamically
    var countryData = [
        { code: 'DE', dialCode: '+49', flag: '🇩🇪' },
        { code: 'AT', dialCode: '+43', flag: '🇦🇹' },
        { code: 'CH', dialCode: '+41', flag: '🇨🇭' },
        { code: 'US', dialCode: '+1', flag: '🇺🇸' },
        { code: 'GB', dialCode: '+44', flag: '🇬🇧' },
        { code: 'FR', dialCode: '+33', flag: '🇫🇷' },
        { code: 'IT', dialCode: '+39', flag: '🇮🇹' },
        { code: 'ES', dialCode: '+34', flag: '🇪🇸' },
        { code: 'NL', dialCode: '+31', flag: '🇳🇱' },
        { code: 'BE', dialCode: '+32', flag: '🇧🇪' },
        { code: 'LU', dialCode: '+352', flag: '🇱🇺' },
        { code: 'PL', dialCode: '+48', flag: '🇵🇱' },
        { code: 'CZ', dialCode: '+420', flag: '🇨🇿' },
        { code: 'DK', dialCode: '+45', flag: '🇩🇰' },
        { code: 'SE', dialCode: '+46', flag: '🇸🇪' },
        { code: 'NO', dialCode: '+47', flag: '🇳🇴' },
        { code: 'FI', dialCode: '+358', flag: '🇫🇮' },
        { code: 'RU', dialCode: '+7', flag: '🇷🇺' },
        { code: 'TR', dialCode: '+90', flag: '🇹🇷' },
        { code: 'GR', dialCode: '+30', flag: '🇬🇷' },
        { code: 'PT', dialCode: '+351', flag: '🇵🇹' },
        { code: 'CA', dialCode: '+1', flag: '🇨🇦' },
        { code: 'AU', dialCode: '+61', flag: '🇦🇺' },
        { code: 'JP', dialCode: '+81', flag: '🇯🇵' },
        { code: 'CN', dialCode: '+86', flag: '🇨🇳' },
        { code: 'IN', dialCode: '+91', flag: '🇮🇳' },
        { code: 'BR', dialCode: '+55', flag: '🇧🇷' },
        { code: 'MX', dialCode: '+52', flag: '🇲🇽' },
        { code: 'ZA', dialCode: '+27', flag: '🇿🇦' }
    ];
    
    // Add localized names to countries
    var countries = countryData.map(function(country) {
        return {
            name: getCountryName(country.code),
            code: country.code,
            dialCode: country.dialCode,
            flag: country.flag
        };
    });
    
    var selectedCountry = countries[0]; // Default: First country (Germany)
    var $countryButton = $('#country-code-button');
    var $countryDropdown = $('#country-dropdown');
    var $countryList = $('#country-list');
    var $countrySearch = $('#country-search');
    var $phoneNumber = $('#simpbook_telefon_number');
    var $phoneHidden = $('#simpbook_telefon');
    
    // Populate country list
    function populateCountryList(filteredCountries) {
        $countryList.empty();
        filteredCountries.forEach(function(country) {
            var $li = $('<li></li>');
            if (country.code === selectedCountry.code) {
                $li.addClass('selected');
            }
            $li.html(
                '<span class="flag">' + country.flag + '</span>' +
                '<span class="country-name">' + country.name + '</span>' +
                '<span class="dial-code">' + country.dialCode + '</span>'
            );
            $li.data('country', country);
            $li.on('click', function() {
                selectCountry($(this).data('country'));
                $countryDropdown.hide();
                $countryButton.removeClass('active');
            });
            $countryList.append($li);
        });
    }
    
    // Select country
    function selectCountry(country) {
        selectedCountry = country;
        $('#selected-flag').text(country.flag);
        $('#selected-code').text(country.dialCode);
        updatePhoneValue();
    }
    
    // Update hidden phone value
    function updatePhoneValue() {
        var number = $phoneNumber.val().trim();
        if (number) {
            $phoneHidden.val(selectedCountry.dialCode + ' ' + number);
        } else {
            $phoneHidden.val('');
        }
    }
    
    // Toggle dropdown
    $countryButton.on('click', function(e) {
        e.preventDefault();
        var isVisible = $countryDropdown.is(':visible');
        if (isVisible) {
            $countryDropdown.hide();
            $countryButton.removeClass('active');
        } else {
            $countryDropdown.show();
            $countryButton.addClass('active');
            $countrySearch.focus();
        }
    });
    
    // Search countries
    $countrySearch.on('input', function() {
        var searchTerm = $(this).val().toLowerCase();
        var filtered = countries.filter(function(country) {
            return country.name.toLowerCase().indexOf(searchTerm) !== -1 ||
                   country.dialCode.indexOf(searchTerm) !== -1;
        });
        populateCountryList(filtered);
    });
    
    // Close dropdown when clicking outside
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.country-code-selector').length) {
            $countryDropdown.hide();
            $countryButton.removeClass('active');
        }
    });
    
    // Update phone value on number input
    $phoneNumber.on('input', updatePhoneValue);
    
    // Auto-detect user's country based on browser locale
    function autoDetectCountry() {
        var userLang = navigator.language || navigator.userLanguage;
        var countryCode = userLang.split('-')[1];
        
        if (countryCode) {
            var detectedCountry = countries.find(function(c) {
                return c.code === countryCode.toUpperCase();
            });
            
            if (detectedCountry) {
                selectCountry(detectedCountry);
            }
        }
    }
    
    // Initialize
    populateCountryList(countries);
    autoDetectCountry();
    
    showStep(1);
});


