jQuery(document).ready(function($) {
    // Daten aus wp_localize_script
    var data = simpbookDienstleistungenData;

    // ==========================================
    // Suchfunktionalität
    // ==========================================
    var searchTimeout;
    var $searchInput = $('#dienstleistungen-search-input');
    var $clearBtn = $('#clear-search-btn-dienstleistungen');
    
    // Suche durchführen
    function performSearch() {
        var searchTerm = $searchInput.val().toLowerCase().trim();
        
        // Clear-Button anzeigen/ausblenden
        if (searchTerm.length > 0) {
            $clearBtn.show();
        } else {
            $clearBtn.hide();
        }
        
        // Tabellen-Zeilen filtern
        $('.desktop-dienstleistungen-tabelle tbody tr').each(function() {
            var $row = $(this);
            var name = $row.find('td').eq(0).text().toLowerCase(); // Name Spalte
            var kategorie = $row.find('td').eq(1).text().toLowerCase(); // Kategorie
            var beschreibung = $row.attr('data-beschreibung') || '';
            beschreibung = beschreibung.toLowerCase();
            
            if (searchTerm === '' || 
                name.includes(searchTerm) || 
                kategorie.includes(searchTerm) ||
                beschreibung.includes(searchTerm)) {
                $row.show();
            } else {
                $row.hide();
            }
        });
        
        // Karten-Ansicht filtern
        $('.mobile-dienstleistungen-karten .dienstleistung-karte').each(function() {
            var $card = $(this);
            var name = $card.find('.dienstleistung-name').text().toLowerCase();
            var kategorie = $card.find('.dienstleistung-kategorie').text().toLowerCase();
            var beschreibung = $card.attr('data-beschreibung') || '';
            beschreibung = beschreibung.toLowerCase();
            
            if (searchTerm === '' || 
                name.includes(searchTerm) || 
                kategorie.includes(searchTerm) ||
                beschreibung.includes(searchTerm)) {
                $card.show();
            } else {
                $card.hide();
            }
        });
        
        // Keine Ergebnisse Meldung
        updateNoResultsMessage(searchTerm);
    }
    
    // Keine Ergebnisse Meldung
    function updateNoResultsMessage(searchTerm) {
        var $tableBody = $('.desktop-dienstleistungen-tabelle tbody');
        var $cardsContainer = $('.mobile-dienstleistungen-karten');
        var visibleTableRows = $tableBody.find('tr:visible').length;
        var visibleCards = $cardsContainer.find('.dienstleistung-karte:visible').length;
        
        // Entferne alte Meldungen
        $('.no-search-results').remove();
        
        if (searchTerm.length > 0) {
            if (visibleTableRows === 0 && $('.desktop-dienstleistungen-tabelle').hasClass('active')) {
                $tableBody.append(
                    '<tr class="no-search-results">' +
                    '<td colspan="100%" style="text-align: center; padding: 40px; color: #8c8f94;">' +
                    '<span class="dashicons dashicons-search" style="font-size: 48px; opacity: 0.3;"></span><br>' +
                    '<strong>Keine Ergebnisse gefunden</strong><br>' +
                    'Keine Dienstleistungen entsprechen Ihrer Suche nach "' + searchTerm + '"' +
                    '</td>' +
                    '</tr>'
                );
            }
            
            if (visibleCards === 0 && !$cardsContainer.hasClass('hidden')) {
                $cardsContainer.append(
                    '<div class="no-search-results" style="grid-column: 1 / -1; text-align: center; padding: 40px; color: #8c8f94;">' +
                    '<span class="dashicons dashicons-search" style="font-size: 48px; opacity: 0.3;"></span><br>' +
                    '<strong>Keine Ergebnisse gefunden</strong><br>' +
                    'Keine Dienstleistungen entsprechen Ihrer Suche nach "' + searchTerm + '"' +
                    '</div>'
                );
            }
        }
    }
    
    // Event Listener für Sucheingabe
    $searchInput.on('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(performSearch, 300); // Debounce 300ms
    });
    
    // Clear-Button Funktionalität
    $clearBtn.on('click', function() {
        $searchInput.val('').focus();
        performSearch();
    });
    
    // Enter-Taste für Suche
    $searchInput.on('keypress', function(e) {
        if (e.which === 13) {
            e.preventDefault();
            performSearch();
        }
    });

    // ==========================================
    // View Toggle Funktionalität
    // ==========================================
    var storedView = localStorage.getItem('simpbook_dienstleistungen_card_view');
    var isCardView = storedView === null ? true : (storedView !== 'false'); // Default true beim ersten Besuch
    
    // Initial view setzen
    if (isCardView) {
        switchToCardView();
    } else {
        switchToTableView();
    }
    
    $('#toggle-view-btn').on('click', function() {
        isCardView = !isCardView;
        localStorage.setItem('simpbook_dienstleistungen_card_view', isCardView);
        
        if (isCardView) {
            switchToCardView();
        } else {
            switchToTableView();
        }
        
        // Suche erneut anwenden nach View-Wechsel
        if ($searchInput.val().trim().length > 0) {
            performSearch();
        }
    });
    
    function switchToTableView() {
        $('.desktop-dienstleistungen-tabelle').addClass('active');
        $('.mobile-dienstleistungen-karten').addClass('hidden');
        $('#toggle-view-text').text(simpbookDienstleistungenData.i18n.card_view || 'Kartenansicht');
    }
    
    function switchToCardView() {
        $('.desktop-dienstleistungen-tabelle').removeClass('active');
        $('.mobile-dienstleistungen-karten').removeClass('hidden');
        $('#toggle-view-text').text(simpbookDienstleistungenData.i18n.table_view || 'Tabellenansicht');
    }

    // Handler für "Neue Dienstleistung hinzufügen" Button
    $(document).on('click', '#add-new-service-btn', function(e) {
        e.preventDefault();

        // Modal für neue Dienstleistung öffnen
        openServiceModalForNew();
    });

    // Funktion zum Öffnen des Modals für neue Dienstleistung
    function openServiceModalForNew() {
        // Titel ändern
        $('#modal-title').text(data.i18n.add_new_service || 'Neue Dienstleistung hinzufügen');

        // Lösch-Button ausblenden
        $('#modal-delete-section').hide();

        // Speichern-Button Text ändern
        $('#modal-save-btn').text(data.i18n.add_service || 'Dienstleistung hinzufügen');

        // Formular leeren und Standardwerte setzen
        $('#dienstleistung-edit-id').val('');
        $('#edit-name').val('');
        $('#edit-kategorie_id').val(''); // Kategorie zurücksetzen
        $('#edit-dauer_minuten').val('30');
        $('#edit-pufferzeit_minuten').val('0');
        $('#edit-beschreibung').val('');
        $('#edit-sortierung').val('0');
        $('#edit-preis').val('');
        $('#edit-preis_anzeigen').prop('checked', false);
        $('#edit-bild_id').val('0');
        $('#edit-aktiv').prop('checked', true); // Neue Dienstleistungen standardmäßig aktiv

        // Bild-Vorschau zurücksetzen
        $('#edit-bild-img').hide();
        $('#edit-remove-image').hide();

        // Mitarbeiter-Liste laden (für neue Dienstleistung keine Vorauswahl)
        var nonce = $('input[name="dienstleistung_nonce"]').val();
        $.ajax({
            url: data.ajaxurl,
            type: 'POST',
            data: {
                action: 'simpbook_get_mitarbeiter_zuweisung_for_dienstleistung',
                simpbook_dienstleistung_id: '', // Leere ID für neue Dienstleistung
                simpbook_nonce: nonce
            },
            success: function(response) {
                if (response.success && response.data && response.data.html) {
                    $('#dienstleistung-mitarbeiter-list').html(response.data.html);
                } else {
                    $('#dienstleistung-mitarbeiter-list').html('<p style="color: red;">' + (data.i18n.error_loading_employees || 'Fehler beim Laden der Mitarbeiter') + '</p>');
                }
            },
            error: function() {
                $('#dienstleistung-mitarbeiter-list').html('<p style="color: red;">' + (data.i18n.unknown_error || 'Unbekannter Fehler') + '</p>');
            }
        });

        // Modal anzeigen
        var modalElement = $('#dienstleistung-detail-modal');
        modalElement.removeAttr('style');
        modalElement.css('display', 'flex').hide().fadeIn(200);
    }

    // Zeile klickbar machen - delegated event handler wie bei Reservierungen
    $(document).on('click', '.dienstleistung-row-clickable, .dienstleistung-karte-clickable', function(e) {
        // Verhindere Klick wenn auf Link oder Button geklickt wird
        if ($(e.target).is('a') || $(e.target).closest('a').length ||
            $(e.target).is('button') || $(e.target).closest('button').length) {
            return;
        }

        e.preventDefault();
        e.stopPropagation();

        var $row = $(this);
        var dienstleistungDataStr = $row.attr('data-dienstleistung-data');

        if (!dienstleistungDataStr) {
            console.error('Keine Dienstleistungs-Daten gefunden');
            return;
        }

        var dienstleistungData;
        try {
            dienstleistungData = JSON.parse(dienstleistungDataStr);
        } catch (e) {
            console.error('Fehler beim Parsen der JSON-Daten:', e);
            return;
        }

        var dienstleistungId = $row.attr('data-dienstleistung-id');

        // Fülle das Formular mit den Daten
        $('#dienstleistung-edit-id').val(dienstleistungId);
        $('#edit-name').val(dienstleistungData.name || '');
        $('#edit-kategorie_id').val(dienstleistungData.kategorie_id || ''); // Kategorie setzen
        $('#edit-dauer_minuten').val(dienstleistungData.dauer_minuten || 30);
        $('#edit-pufferzeit_minuten').val(dienstleistungData.pufferzeit_minuten || 0);
        $('#edit-beschreibung').val(dienstleistungData.beschreibung || '');
        $('#edit-sortierung').val(dienstleistungData.sortierung || 0);
        $('#edit-preis').val(dienstleistungData.preis || '');
        $('#edit-preis_anzeigen').prop('checked', dienstleistungData.preis_anzeigen == 1);
        $('#edit-bild_id').val(dienstleistungData.bild_id || 0);
        $('#edit-aktiv').prop('checked', dienstleistungData.aktiv == 1);

        // Zeige Bild-Vorschau wenn vorhanden
        if (dienstleistungData.bild_id && dienstleistungData.bild_id > 0) {
            var attachment = wp.media.attachment(dienstleistungData.bild_id);
            attachment.fetch();
            attachment.on('change', function() {
                var imageUrl = attachment.get('url');
                $('#edit-bild-img').attr('src', imageUrl).show();
                $('#edit-remove-image').show();
            });
        } else {
            $('#edit-bild-img').hide();
            $('#edit-remove-image').hide();
        }

        // Lade Mitarbeiter für diese Dienstleistung
        var nonce = $('input[name="dienstleistung_nonce"]').val();
        $.ajax({
            url: data.ajaxurl,
            type: 'POST',
            data: {
                action: 'simpbook_get_mitarbeiter_zuweisung_for_dienstleistung',
                simpbook_dienstleistung_id: dienstleistungId,
                simpbook_nonce: nonce
            },
            success: function(response) {
                if (response.success && response.data && response.data.html) {
                    $('#dienstleistung-mitarbeiter-list').html(response.data.html);
                } else {
                    $('#dienstleistung-mitarbeiter-list').html('<p style="color: red;">' + (data.i18n.error_loading_employees || 'Fehler beim Laden der Mitarbeiter') + '</p>');
                }
            },
            error: function() {
                $('#dienstleistung-mitarbeiter-list').html('<p style="color: red;">' + (data.i18n.unknown_error || 'Unbekannter Fehler') + '</p>');
            }
        });

        // Modal für Bearbeitung konfigurieren
        $('#modal-title').text(data.i18n.edit_service || 'Dienstleistung bearbeiten');
        $('#modal-delete-section').show();
        $('#modal-save-btn').text(data.i18n.save || 'Speichern');

        // Modal anzeigen
        var modalElement = $('#dienstleistung-detail-modal');
        if (modalElement.length === 0) {
            console.error('Modal-Element nicht gefunden!');
            if (typeof window.simpbookAlert === 'function') {
                window.simpbookAlert(data.i18n.error_modal_not_found, data.i18n.error_title);
            } else {
                alert(data.i18n.error_modal_not_found);
            }
            return;
        }
        // Zeige Modal mit Animation (wie bei Reservierungen)
        // Entferne inline style, setze display: flex und zeige mit fadeIn
        modalElement.removeAttr('style');
        modalElement.css('display', 'flex').hide().fadeIn(200);
    });

    // Modal schließen
    $(document).on('click', '.reservierung-modal-close, .reservierung-modal-overlay', function() {
        $('#dienstleistung-detail-modal').fadeOut(200);
    });

    // ESC-Taste zum Schließen
    $(document).on('keydown', function(e) {
        if (e.key === 'Escape' && $('#dienstleistung-detail-modal').is(':visible')) {
            $('#dienstleistung-detail-modal').fadeOut(200);
        }
    });

    // Bild-Upload Handler
    var dienstleistung_image_frame;
    $(document).on('click', '#edit-upload-image', function(e) {
        e.preventDefault();

        // Erstelle oder verwende bestehenden Media Frame
        if (dienstleistung_image_frame) {
            dienstleistung_image_frame.open();
            return;
        }

        dienstleistung_image_frame = wp.media.frames.dienstleistung_image = wp.media({
            title: data.i18n.select_image,
            button: {
                text: data.i18n.use_image
            },
            multiple: false,
            library: {
                type: 'image'
            }
        });

        dienstleistung_image_frame.on('select', function() {
            var attachment = dienstleistung_image_frame.state().get('selection').first().toJSON();
            $('#edit-bild_id').val(attachment.id);
            $('#edit-bild-img').attr('src', attachment.url).show();
            $('#edit-remove-image').show();
        });

        dienstleistung_image_frame.open();
    });

    // Bild entfernen Handler
    $(document).on('click', '#edit-remove-image', function(e) {
        e.preventDefault();
        $('#edit-bild_id').val(0);
        $('#edit-bild-img').hide();
        $(this).hide();
    });

    // Formular absenden (delegated event handler für dynamisches Formular)
    $(document).on('submit', '#dienstleistung-edit-form', function(e) {
        e.preventDefault();

        // Sammle alle Form-Felder manuell in einem Objekt
        var formData = {
            action: 'simpbook_save_dienstleistung',
            simpbook_dienstleistung_id: $('#dienstleistung-edit-id').val(),
            simpbook_nonce: $('input[name="dienstleistung_nonce"]').val(),
            simpbook_name: $('#dienstleistung-edit-form input[name="simpbook_name"]').val(),
            simpbook_kategorie_id: $('#dienstleistung-edit-form select[name="simpbook_kategorie_id"]').val(),
            simpbook_dauer_minuten: $('#dienstleistung-edit-form input[name="simpbook_dauer_minuten"]').val(),
            simpbook_pufferzeit_minuten: $('#dienstleistung-edit-form input[name="simpbook_pufferzeit_minuten"]').val(),
            simpbook_beschreibung: $('#dienstleistung-edit-form textarea[name="simpbook_beschreibung"]').val(),
            simpbook_aktiv: $('#dienstleistung-edit-form input[name="simpbook_aktiv"]').is(':checked') ? '1' : '0',
            simpbook_sortierung: $('#dienstleistung-edit-form input[name="simpbook_sortierung"]').val(),
            simpbook_preis: $('#dienstleistung-edit-form input[name="simpbook_preis"]').val(),
            simpbook_preis_anzeigen: $('#dienstleistung-edit-form input[name="simpbook_preis_anzeigen"]').is(':checked') ? '1' : '0',
            simpbook_bild_id: $('#dienstleistung-edit-form input[name="simpbook_bild_id"]').val()
        };

        // Sammle alle ausgewählten Mitarbeiter als Array
        var mitarbeiterIds = [];
        $('#dienstleistung-mitarbeiter-list input[type="checkbox"]:checked').each(function() {
            mitarbeiterIds.push($(this).val());
        });

        // Debug-Ausgabe entfernen nach Test
        console.log('Ausgewählte Mitarbeiter:', mitarbeiterIds);

        // Erstelle FormData für Datei-Upload und füge Mitarbeiter hinzu
        var ajaxData = new FormData();
        for (var key in formData) {
            ajaxData.append(key, formData[key]);
        }
        // Mitarbeiter als Array hinzufügen - WICHTIG: Ohne die Klammern im Namen, PHP erkennt das automatisch
        for (var i = 0; i < mitarbeiterIds.length; i++) {
            ajaxData.append('simpbook_mitarbeiter[' + i + ']', mitarbeiterIds[i]);
        }

        $.ajax({
            url: data.ajaxurl,
            type: 'POST',
            data: ajaxData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert(response.data || data.i18n.error_saving);
                }
            },
            error: function(xhr, status, error) {
                console.error('AJAX Error:', status, error, xhr.responseText);
                alert(data.i18n.unknown_error);
            }
        });
    });

    // Löschen
    $(document).on('click', '#dienstleistung-delete', function(e) {
        e.preventDefault();
        var dienstleistungId = $('#dienstleistung-edit-id').val();

        if (!dienstleistungId || dienstleistungId == 0) {
            alert(data.i18n.select_service_first);
            return;
        }

        // Hole Nonce aus dem geklickten Row oder Karte
        var row = $('.dienstleistung-row-clickable[data-dienstleistung-id="' + dienstleistungId + '"], .dienstleistung-karte-clickable[data-dienstleistung-id="' + dienstleistungId + '"]');
        var nonce = row.attr('data-delete-nonce');

        if (!nonce) {
            if (typeof window.simpbookAlert === 'function') {
                window.simpbookAlert(data.i18n.security_token_missing, data.i18n.error_title);
            } else {
                alert(data.i18n.security_token_missing);
            }
            return;
        }

        var confirmMessage = data.i18n.confirm_delete;
        var confirmTitle = data.i18n.confirmation_title;

        if (typeof window.simpbookConfirm === 'function') {
            window.simpbookConfirm(confirmMessage, confirmTitle).then(function(confirmed) {
                if (confirmed) {
                    $.ajax({
                        url: data.ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'simpbook_delete_dienstleistung',
                            simpbook_id: dienstleistungId,
                            simpbook_nonce: nonce
                        },
                        success: function(response) {
                            if (response && response.success) {
                                location.reload();
                            } else {
                                var errorMsg = (response && response.data) ? response.data : data.i18n.error_deleting;
                                if (typeof window.simpbookAlert === 'function') {
                                    window.simpbookAlert(errorMsg, data.i18n.error_title);
                                } else {
                                    alert(errorMsg);
                                }
                            }
                        },
                        error: function(xhr, status, error) {
                            console.error('AJAX Error:', status, error);
                            console.error('Response:', xhr.responseText);
                            var errorMsg = data.i18n.unknown_error;
                            if (xhr.responseJSON && xhr.responseJSON.data) {
                                errorMsg = xhr.responseJSON.data;
                            }
                            if (typeof window.simpbookAlert === 'function') {
                                window.simpbookAlert(errorMsg, data.i18n.error_title);
                            } else {
                                alert(errorMsg);
                            }
                        }
                    });
                }
            });
        } else {
            // Fallback zu Browser confirm
            if (confirm(confirmMessage)) {
                $.ajax({
                    url: data.ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'simpbook_delete_dienstleistung',
                        simpbook_id: dienstleistungId,
                        simpbook_nonce: nonce
                    },
                    success: function(response) {
                        if (response && response.success) {
                            location.reload();
                        } else {
                            var errorMsg = (response && response.data) ? response.data : data.i18n.error_deleting;
                            alert(errorMsg);
                        }
                    },
                    error: function(xhr, status, error) {
                        console.error('AJAX Error:', status, error);
                        console.error('Response:', xhr.responseText);
                        var errorMsg = data.i18n.unknown_error;
                        if (xhr.responseJSON && xhr.responseJSON.data) {
                            errorMsg = xhr.responseJSON.data;
                        }
                        alert(errorMsg);
                    }
                });
            }
        }
    });
});

