<?php
// admin/statistiken.php
if (!defined('ABSPATH')) {
    exit;
}

simpbook_display_trial_notice_on_admin_pages();

// Standard: Von heute bis in 1 Monat (statt letzter Monat)
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$simpbook_filter_start = isset($_GET['simpbook_filter_start']) ? sanitize_text_field(wp_unslash($_GET['simpbook_filter_start'])) : wp_date('Y-m-d');
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$simpbook_filter_end = isset($_GET['simpbook_filter_end']) ? sanitize_text_field(wp_unslash($_GET['simpbook_filter_end'])) : wp_date('Y-m-d', strtotime('now +30 days'));

global $wpdb;
$simpbook_tabellen_name = $wpdb->prefix . 'reservierungen';

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, PluginCheck.Security.DirectDB.UnescapedDBParameter
$simpbook_total_buchungen = $wpdb->get_var($wpdb->prepare(
    "SELECT COUNT(*) FROM %i WHERE datum >= %s AND datum <= %s", 
    $simpbook_tabellen_name, 
    $simpbook_filter_start, 
    $simpbook_filter_end 
)); 

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, PluginCheck.Security.DirectDB.UnescapedDBParameter
$simpbook_bestaetigt = $wpdb->get_var($wpdb->prepare(
    "SELECT COUNT(*) FROM %i WHERE status = 'BESTÄTIGT' AND datum >= %s AND datum <= %s",
    $simpbook_tabellen_name, 
    $simpbook_filter_start, 
    $simpbook_filter_end 
));

// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, PluginCheck.Security.DirectDB.UnescapedDBParameter
$simpbook_storniert = $wpdb->get_var($wpdb->prepare(
    "SELECT COUNT(*) FROM %i WHERE storniert = 1 AND datum >= %s AND datum <= %s",
    $simpbook_tabellen_name, 
    $simpbook_filter_start, 
    $simpbook_filter_end 
));

$simpbook_stornierungsquote = $simpbook_total_buchungen > 0 ? round(($simpbook_storniert / $simpbook_total_buchungen) * 100, 1) : 0;
?>

<div class="wrap simpbook-admin-wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Statistiken', 'simple-appointment-booking'); ?></h1>
    <a href="<?php echo esc_url(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-reservierungen'))); ?>" class="page-title-action"><?php esc_html_e('Zurück zur Liste', 'simple-appointment-booking'); ?></a>
    <hr class="wp-header-end">

    <div class="simpbook-stats-filters">
        <button class="filter-toggle-button" id="simpbook-stats-filter-toggle" aria-expanded="false">
            <span class="dashicons dashicons-filter"></span>
            <span class="filter-toggle-text"><?php esc_html_e('Filter', 'simple-appointment-booking'); ?></span>
            <span class="dashicons dashicons-arrow-down-alt2 filter-toggle-icon"></span>
        </button>
        <div class="filter-options" id="simpbook-stats-filter-panel">
        <form method="get" action="">
            <input type="hidden" name="page" value="simpbook-statistiken">
            <label for="simpbook_filter_start"><?php esc_html_e('Von:', 'simple-appointment-booking'); ?></label>
            <input type="date" id="simpbook_filter_start" name="simpbook_filter_start" value="<?php echo esc_attr($simpbook_filter_start); ?>">

            <label for="simpbook_filter_end"><?php esc_html_e('Bis:', 'simple-appointment-booking'); ?></label>
            <input type="date" id="simpbook_filter_end" name="simpbook_filter_end" value="<?php echo esc_attr($simpbook_filter_end); ?>">

            <div class="simpbook-filter-actions">
                <button type="submit" class="button button-primary"><?php esc_html_e('Filter anwenden', 'simple-appointment-booking'); ?></button>
                <button type="button" class="button simpbook-quick-filter" data-range="last-month"><?php esc_html_e('Letzter Monat', 'simple-appointment-booking'); ?></button>
                <button type="button" class="button simpbook-quick-filter" data-range="last-3-months"><?php esc_html_e('Letzte 3 Monate', 'simple-appointment-booking'); ?></button>
                <button type="button" class="button simpbook-quick-filter" data-range="last-6-months"><?php esc_html_e('Letzte 6 Monate', 'simple-appointment-booking'); ?></button>
                <a href="<?php echo esc_url(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-statistiken'))); ?>" class="button"><?php esc_html_e('Zurücksetzen', 'simple-appointment-booking'); ?></a>
            </div>
        </form>
        </div>
    </div>

    <div class="simpbook-stats-grid">
        <div class="simpbook-stat-card">
            <h3><?php esc_html_e('Gesamte Buchungen', 'simple-appointment-booking'); ?></h3>
            <div class="simpbook-stat-value"><?php echo esc_html($simpbook_total_buchungen); ?></div>
            <p><?php esc_html_e('Im ausgewählten Zeitraum', 'simple-appointment-booking'); ?></p>
        </div>

        <div class="simpbook-stat-card">
            <h3><?php esc_html_e('Bestätigte Buchungen', 'simple-appointment-booking'); ?></h3>
            <div class="simpbook-stat-value"><?php echo esc_html($simpbook_bestaetigt); ?></div>
            <p><?php esc_html_e('Im ausgewählten Zeitraum', 'simple-appointment-booking'); ?></p>
        </div>

        <div class="simpbook-stat-card">
            <h3><?php esc_html_e('Stornierte Buchungen', 'simple-appointment-booking'); ?></h3>
            <div class="simpbook-stat-value"><?php echo esc_html($simpbook_storniert); ?></div>
            <p><?php esc_html_e('Im ausgewählten Zeitraum', 'simple-appointment-booking'); ?></p>
        </div>

        <div class="simpbook-stat-card">
            <h3><?php esc_html_e('Stornierungsquote', 'simple-appointment-booking'); ?></h3>
            <div class="simpbook-stat-value"><?php echo esc_html($simpbook_stornierungsquote); ?>%</div>
            <p><?php esc_html_e('Im ausgewählten Zeitraum', 'simple-appointment-booking'); ?></p>
        </div>
    </div>

    <div class="simpbook-chart-container">
        <h3><?php esc_html_e('Buchungen pro Tag', 'simple-appointment-booking'); ?></h3>
        <div class="simpbook-chart-wrapper">
            <canvas id="bookingsPerDayChart"></canvas>
        </div>
    </div>

    <div class="simpbook-chart-container">
        <h3><?php esc_html_e('Buchungen pro Dienstleistung', 'simple-appointment-booking'); ?></h3>
        <div class="simpbook-chart-wrapper">
            <canvas id="bookingsPerServiceChart"></canvas>
        </div>
    </div>

    <div class="simpbook-chart-container">
        <h3><?php esc_html_e('Buchungen pro Mitarbeiter', 'simple-appointment-booking'); ?></h3>
        <div class="simpbook-chart-wrapper">
            <canvas id="bookingsPerEmployeeChart"></canvas>
        </div>
    </div>
</div>