<?php
// admin/setup-wizard.php
// Direkten Zugriff verhindern
if (!defined('ABSPATH')) {
    exit;
}

// Prüfe ob Wizard bereits durchgeführt wurde
$simpbook_wizard_completed = get_transient('simpbook_setup_wizard_completed');
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for wizard step navigation only
$simpbook_current_step = isset($_GET['simpbook_step']) ? intval($_GET['simpbook_step']) : 1;

// Wenn Wizard bereits abgeschlossen und nicht explizit neu gestartet
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for wizard restart check only
if ($simpbook_wizard_completed && !isset($_GET['simpbook_restart'])) {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for page routing only
    $simpbook_current_page = isset($_GET['page']) ? sanitize_text_field(wp_unslash($_GET['page'])) : 'simpbook-dashboard';
    wp_safe_redirect(admin_url('admin.php?page=' . $simpbook_current_page));
    exit;
}

// Formular-Verarbeitung erfolgt jetzt im admin_init Hook (handle_setup_wizard_submit)
// in simple-appointment-booking.php, damit Redirects funktionieren, bevor Header gesendet werden

// Fehler aus URL lesen
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for error display only
$simpbook_wizard_error = isset($_GET['simpbook_error']) && $_GET['simpbook_error'] === 'no_day' ? esc_html__('Bitte aktivieren Sie mindestens einen Wochentag für Reservierungen.', 'simple-appointment-booking') : '';

// Wochentage für Schritt 2
if (function_exists('simpbook_get_wochentage')) {
    $simpbook_wochentage = simpbook_get_wochentage();
} else {
    // Fallback falls Funktion nicht verfügbar
    $simpbook_wochentage = [
        'montag' => __('Montag', 'simple-appointment-booking'),
        'dienstag' => __('Dienstag', 'simple-appointment-booking'),
        'mittwoch' => __('Mittwoch', 'simple-appointment-booking'),
        'donnerstag' => __('Donnerstag', 'simple-appointment-booking'),
        'freitag' => __('Freitag', 'simple-appointment-booking'),
        'samstag' => __('Samstag', 'simple-appointment-booking'),
        'sonntag' => __('Sonntag', 'simple-appointment-booking')
    ];
}
$simpbook_wochentag_zeiten = get_option('simpbook_wochentag_zeiten', []);
$simpbook_standard_beginn = '11:00';
$simpbook_standard_ende = '22:00';
foreach ($simpbook_wochentage as $simpbook_tag_key => $simpbook_tag_name) {
    if (!isset($simpbook_wochentag_zeiten[$simpbook_tag_key])) {
        $simpbook_wochentag_zeiten[$simpbook_tag_key] = [
            'aktiv' => '0',
            'beginn' => $simpbook_standard_beginn,
            'ende' => $simpbook_standard_ende
        ];
    }
}

// Aktuelle Werte laden
$simpbook_firmen_name = get_option('simpbook_firmen_name', get_bloginfo('name'));
$simpbook_benachrichtigungs_email = get_option('simpbook_benachrichtigungs_email', get_option('admin_email'));
$simpbook_email_benachrichtigungen = get_option('simpbook_email_benachrichtigungen', '1');
$simpbook_current_language = function_exists('simpbook_get_current_language') ? simpbook_get_current_language() : 'en_US';

// CSS und JS werden bereits in admin_skripte_laden() geladen - NICHT hier, da zu spät!
?>

<div class="wrap simpbook-admin-wrap simpbook-setup-wizard">
    <div class="simpbook-wizard-container">
        <div class="simpbook-wizard-header">
            <h1><?php esc_html_e('Willkommen beim Buchungssystem', 'simple-appointment-booking'); ?></h1>
            <p><?php esc_html_e('Lassen Sie uns Ihr Plugin in wenigen Schritten einrichten.', 'simple-appointment-booking'); ?></p>
        </div>
            <div class="simpbook-wizard-progress">
                <?php for ($simpbook_i = 1; $simpbook_i <= 6; $simpbook_i++) : ?>
                    <div class="simpbook-progress-step <?php echo $simpbook_i <= $simpbook_current_step ? 'active' : ''; ?> <?php echo $simpbook_i < $simpbook_current_step ? 'completed' : ''; ?>">
                        <div class="simpbook-progress-number"><?php echo $simpbook_i < $simpbook_current_step ? '✓' : esc_html($simpbook_i); ?></div>
                        <div class="simpbook-progress-label">
                            <?php
                            $simpbook_labels = [
                                1 => __('Grunddaten', 'simple-appointment-booking'),
                                2 => __('Öffnungszeiten', 'simple-appointment-booking'),
                                3 => __('Dienstleistung', 'simple-appointment-booking'),
                                4 => __('Mitarbeiter', 'simple-appointment-booking'),
                                5 => __('Sprache', 'simple-appointment-booking'),
                                6 => __('Fertig', 'simple-appointment-booking')
                            ];
                            echo esc_html($simpbook_labels[$simpbook_i]);
                            ?>
                        </div>
                    </div>
                    <?php if ($simpbook_i < 6) : ?>
                        <div class="simpbook-progress-line <?php echo $simpbook_i < $simpbook_current_step ? 'completed' : ''; ?>"></div>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
        <?php if (!empty($simpbook_wizard_error)) : ?>
            <div class="notice notice-error">
                <p><?php echo esc_html($simpbook_wizard_error); ?></p>
            </div>
        <?php endif; ?>
        <form method="post" action="" class="simpbook-wizard-form">
            <?php wp_nonce_field('simpbook_wizard_step_' . $simpbook_current_step); ?>
            <input type="hidden" name="simpbook_wizard_step" value="<?php echo esc_attr($simpbook_current_step); ?>">

            <?php if ($simpbook_current_step === 1) : ?>
                <div class="simpbook-wizard-step">
                    <h2><?php esc_html_e('Schritt 1: Grunddaten', 'simple-appointment-booking'); ?></h2>
                    <p class="simpbook-wizard-description"><?php esc_html_e('Geben Sie die grundlegenden Informationen zu Ihrem Unternehmen ein.', 'simple-appointment-booking'); ?></p>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_firmen_name"><?php esc_html_e('Firmenname *', 'simple-appointment-booking'); ?></label>
                        <input type="text" id="simpbook_firmen_name" name="simpbook_firmen_name" value="<?php echo esc_attr($simpbook_firmen_name); ?>" class="regular-text" required>
                        <p class="description"><?php esc_html_e('Dieser Name wird in allen E-Mails verwendet.', 'simple-appointment-booking'); ?></p>
                    </div>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_benachrichtigungs_email"><?php esc_html_e('E-Mail-Adresse für Benachrichtigungen', 'simple-appointment-booking'); ?></label>
                        <input type="email" id="simpbook_benachrichtigungs_email" name="simpbook_benachrichtigungs_email" value="<?php echo esc_attr($simpbook_benachrichtigungs_email); ?>" class="regular-text">
                        <p class="description"><?php
                        printf(
                            /* translators: %s: Admin email address */
                            esc_html__('Leer lassen, um die Admin-E-Mail zu verwenden (%s).', 'simple-appointment-booking'),
                            esc_html(get_option('admin_email'))
                        ); ?></p>
                    </div>

                    <div class="simpbook-wizard-field">
                        <label>
                            <input type="checkbox" name="simpbook_email_benachrichtigungen" value="1" <?php checked($simpbook_email_benachrichtigungen, '1'); ?>>
                            <?php esc_html_e('Bei neuen Buchungen eine E-Mail senden', 'simple-appointment-booking'); ?>
                        </label>
                    </div>

                    <div class="simpbook-wizard-field">
                        <button type="button" id="simpbook-wizard-reset-step1" class="button button-secondary">
                            <span class="dashicons dashicons-update"></span>
                            <?php esc_html_e('Zurücksetzen', 'simple-appointment-booking'); ?>
                        </button>
                        <p class="description"><?php esc_html_e('Setzt alle Felder in diesem Schritt auf die Standardwerte zurück.', 'simple-appointment-booking'); ?></p>
                    </div>
                </div>

            <?php elseif ($simpbook_current_step === 2) : ?>
                <div class="simpbook-wizard-step">
                    <h2><?php esc_html_e('Schritt 2: Öffnungszeiten', 'simple-appointment-booking'); ?></h2>
                    <p class="simpbook-wizard-description"><?php esc_html_e('Aktivieren Sie mindestens einen Wochentag und setzen Sie die Öffnungszeiten.', 'simple-appointment-booking'); ?></p>

                    <div class="simpbook-wizard-opening-hours">
                        <?php foreach ($simpbook_wochentage as $simpbook_tag_key => $simpbook_tag_name) : ?>
                            <div class="simpbook-wizard-day-card">
                                <label class="simpbook-wizard-day-checkbox">
                                    <input type="checkbox" name="simpbook_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv" value="1" <?php checked($simpbook_wochentag_zeiten[$simpbook_tag_key]['aktiv'] ?? '0', '1'); ?>>
                                    <strong><?php echo esc_html($simpbook_tag_name); ?></strong>
                                </label>
                                <div class="simpbook-wizard-day-times">
                                    <span class="time-input-group">
                                        <label><?php esc_html_e('Von:', 'simple-appointment-booking'); ?></label>
                                        <input type="time" name="simpbook_<?php echo esc_attr($simpbook_tag_key); ?>_beginn" value="<?php echo esc_attr($simpbook_wochentag_zeiten[$simpbook_tag_key]['beginn'] ?? $simpbook_standard_beginn); ?>" class="time-input">
                                    </span>
                                    <span class="time-input-group">
                                        <label><?php esc_html_e('Bis:', 'simple-appointment-booking'); ?></label>
                                        <input type="time" name="simpbook_<?php echo esc_attr($simpbook_tag_key); ?>_ende" value="<?php echo esc_attr($simpbook_wochentag_zeiten[$simpbook_tag_key]['ende'] ?? $simpbook_standard_ende); ?>" class="time-input">
                                    </span>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>

            <?php elseif ($simpbook_current_step === 3) : ?>
                <div class="simpbook-wizard-step">
                    <h2><?php esc_html_e('Schritt 3: Dienstleistung anlegen', 'simple-appointment-booking'); ?></h2>
                    <p class="simpbook-wizard-description"><?php esc_html_e('Erstellen Sie Ihre erste Dienstleistung. Sie können später weitere hinzufügen.', 'simple-appointment-booking'); ?></p>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_dienstleistung_name"><?php esc_html_e('Name der Dienstleistung *', 'simple-appointment-booking'); ?></label>
                        <input type="text" id="simpbook_dienstleistung_name" name="simpbook_dienstleistung_name" value="" class="regular-text" required>
                        <p class="description"><?php esc_html_e('z.B. "Haarschnitt", "Massage", "Beratung"', 'simple-appointment-booking'); ?></p>
                    </div>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_dienstleistung_dauer"><?php esc_html_e('Dauer (Minuten) *', 'simple-appointment-booking'); ?></label>
                        <input type="number" id="simpbook_dienstleistung_dauer" name="simpbook_dienstleistung_dauer" value="30" min="5" max="480" step="5" class="small-text" required>
                        <p class="description"><?php esc_html_e('Dauer der Dienstleistung in Minuten', 'simple-appointment-booking'); ?></p>
                    </div>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_dienstleistung_pufferzeit"><?php esc_html_e('Pufferzeit (Minuten)', 'simple-appointment-booking'); ?></label>
                        <input type="number" id="simpbook_dienstleistung_pufferzeit" name="simpbook_dienstleistung_pufferzeit" value="0" min="0" max="60" step="5" class="small-text">
                        <p class="description"><?php esc_html_e('Pufferzeit nach der Dienstleistung (z.B. für Reinigung)', 'simple-appointment-booking'); ?></p>
                    </div>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_dienstleistung_beschreibung"><?php esc_html_e('Beschreibung', 'simple-appointment-booking'); ?></label>
                        <textarea id="simpbook_dienstleistung_beschreibung" name="simpbook_dienstleistung_beschreibung" rows="3" cols="50" class="large-text"></textarea>
                        <p class="description"><?php esc_html_e('Optionale Beschreibung der Dienstleistung', 'simple-appointment-booking'); ?></p>
                    </div>
                </div>

            <?php elseif ($simpbook_current_step === 4) : ?>
                <div class="simpbook-wizard-step">
                    <h2><?php esc_html_e('Schritt 4: Mitarbeiter anlegen', 'simple-appointment-booking'); ?></h2>
                    <p class="simpbook-wizard-description"><?php esc_html_e('Erstellen Sie Ihren ersten Mitarbeiter. Sie können später weitere hinzufügen.', 'simple-appointment-booking'); ?></p>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_mitarbeiter_name"><?php esc_html_e('Name des Mitarbeiters *', 'simple-appointment-booking'); ?></label>
                        <input type="text" id="simpbook_mitarbeiter_name" name="simpbook_mitarbeiter_name" value="" class="regular-text" required>
                        <p class="description"><?php esc_html_e('Vor- und Nachname des Mitarbeiters', 'simple-appointment-booking'); ?></p>
                    </div>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_mitarbeiter_email"><?php esc_html_e('E-Mail-Adresse', 'simple-appointment-booking'); ?></label>
                        <input type="email" id="simpbook_mitarbeiter_email" name="simpbook_mitarbeiter_email" value="" class="regular-text">
                        <p class="description"><?php esc_html_e('E-Mail-Adresse des Mitarbeiters (optional)', 'simple-appointment-booking'); ?></p>
                    </div>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_mitarbeiter_telefon"><?php esc_html_e('Telefonnummer', 'simple-appointment-booking'); ?></label>
                        <input type="text" id="simpbook_mitarbeiter_telefon" name="simpbook_mitarbeiter_telefon" value="" class="regular-text">
                        <p class="description"><?php esc_html_e('Telefonnummer des Mitarbeiters (optional)', 'simple-appointment-booking'); ?></p>
                    </div>
                </div>

            <?php elseif ($simpbook_current_step === 5) : ?>
                <div class="simpbook-wizard-step">
                    <h2><?php esc_html_e('Schritt 5: Sprache', 'simple-appointment-booking'); ?></h2>
                    <p class="simpbook-wizard-description"><?php esc_html_e('Wählen Sie die Sprache für das Frontend und Backend.', 'simple-appointment-booking'); ?></p>

                    <div class="simpbook-wizard-field">
                        <label for="simpbook_language"><?php esc_html_e('Sprache *', 'simple-appointment-booking'); ?></label>
                        <select name="simpbook_language" id="simpbook_language" class="regular-text" required>
                            <option value="de_DE" <?php selected($simpbook_current_language, 'de_DE'); ?>>Deutsch</option>
                            <option value="en_US" <?php selected($simpbook_current_language, 'en_US'); ?>>English</option>
                            <option value="en_US_AMPM" <?php selected($simpbook_current_language, 'en_US_AMPM'); ?>>English (US) - AM/PM</option>
                            <option value="it_IT" <?php selected($simpbook_current_language, 'it_IT'); ?>>Italiano</option>
                            <option value="es_ES" <?php selected($simpbook_current_language, 'es_ES'); ?>>Español</option>
                            <option value="fr_FR" <?php selected($simpbook_current_language, 'fr_FR'); ?>>Français</option>
                            <option value="pl_PL" <?php selected($simpbook_current_language, 'pl_PL'); ?>>Polski</option>
                        </select>
                    </div>
                </div>

            <?php elseif ($simpbook_current_step === 6) : ?>
                <div class="simpbook-wizard-step">
                    <h2><?php esc_html_e('Fertig!', 'simple-appointment-booking'); ?></h2>
                    <p class="simpbook-wizard-description"><?php esc_html_e('Ihr Buchungssystem ist jetzt eingerichtet. Hier sind die nächsten Schritte:', 'simple-appointment-booking'); ?></p>

                    <div class="simpbook-wizard-checklist">
                        <div class="simpbook-checklist-item">
                            <span class="dashicons dashicons-yes-alt"></span>
                            <div>
                                <strong><?php esc_html_e('Shortcode einfügen', 'simple-appointment-booking'); ?></strong>
                                <p><?php esc_html_e('Fügen Sie den Shortcode', 'simple-appointment-booking'); ?> <code>[simpbook_bookingform]</code> <?php esc_html_e('auf einer Seite oder einem Beitrag ein.', 'simple-appointment-booking'); ?></p>
                            </div>
                        </div>
                        <div class="simpbook-checklist-item">
                            <span class="dashicons dashicons-admin-settings"></span>
                            <div>
                                <strong><?php esc_html_e('Einstellungen anpassen', 'simple-appointment-booking'); ?></strong>
                                <p><?php esc_html_e('Passen Sie E-Mail-Templates, Design und weitere Einstellungen nach Ihren Wünschen an.', 'simple-appointment-booking'); ?></p>
                            </div>
                        </div>
                        <div class="simpbook-checklist-item">
                            <span class="dashicons dashicons-calendar-alt"></span>
                            <div>
                                <strong><?php esc_html_e('Buchungen verwalten', 'simple-appointment-booking'); ?></strong>
                                <p><?php esc_html_e('Verwalten Sie Buchungen über das Dashboard oder die Buchungen-Liste.', 'simple-appointment-booking'); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="simpbook_wizard-actions">
                <?php if ($simpbook_current_step > 1) : ?>
                    <?php
                    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for page routing only
                    $simpbook_current_page = isset($_GET['page']) ? sanitize_text_field(wp_unslash($_GET['page'])) : 'simpbook-dashboard';
                    ?>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=' . $simpbook_current_page . '&simpbook_wizard=1&simpbook_step=' . ($simpbook_current_step - 1))); ?>" class="button">
                        <?php esc_html_e('Zurück', 'simple-appointment-booking'); ?>
                    </a>
                <?php endif; ?>

                <?php if ($simpbook_current_step < 6) : ?>
                    <button type="submit" name="simpbook_wizard_submit" class="button button-primary">
                        <?php esc_html_e('Weiter', 'simple-appointment-booking'); ?>
                    </button>
                <?php else : ?>
                    <button type="submit" name="simpbook_wizard_submit" class="button button-primary">
                        <?php esc_html_e('Abschließen', 'simple-appointment-booking'); ?>
                    </button>
                <?php endif; ?>

                <?php
                // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for page routing only
                $simpbook_current_page = isset($_GET['page']) ? sanitize_text_field(wp_unslash($_GET['page'])) : 'simpbook-dashboard';
                ?>
                <a href="<?php echo esc_url(admin_url('admin.php?page=' . $simpbook_current_page)); ?>" class="button button-secondary">
                    <?php esc_html_e('Überspringen', 'simple-appointment-booking'); ?>
                </a>
            </div>
        </form>
    </div>
</div>








