<?php
// admin/neue-reservierung.php
// Direkten Zugriff verhindern
if (!defined('ABSPATH')) {
    exit;
}

// Testphase-Hinweis anzeigen
simpbook_display_trial_notice_on_admin_pages();

// CSS und JS werden bereits in admin_skripte_laden() geladen - NICHT hier, da zu spät!

// Wochentage und Zeiten aus der Datenbank laden
$simpbook_wochentag_zeiten = get_option('simpbook_wochentag_zeiten', []);
$simpbook_intervall = intval(get_option('simpbook_intervall', 30));
$simpbook_ausgeschlossene_tage = get_option('simpbook_ausgeschlossene_tage', '');
// Spezielle Tage-Konfiguration laden
$simpbook_default_map = simpbook_get_default_settings_map();
$simpbook_spezielle_tage_konfiguration = simpbook_get_option('simpbook_spezielle_tage_konfiguration', $simpbook_default_map['simpbook_spezielle_tage_konfiguration']);
// Alle Dienstleistungen laden (sortiert nach Kategorien)
$simpbook_alle_dienstleistungen = simpbook_get_all_dienstleistungen_sorted_by_kategorie(true); // Nur aktive

// Kategorien für Gruppierung laden
$simpbook_alle_kategorien = simpbook_get_all_kategorien();
$simpbook_kategorien_map = [];
foreach ($simpbook_alle_kategorien as $simpbook_kat) {
    $simpbook_kategorien_map[$simpbook_kat->id] = $simpbook_kat->name;
}

// Standardwerte falls keine Zeiten gesetzt sind
$simpbook_standard_beginn = '11:00';
$simpbook_standard_ende = '22:00';

// Wochentage übersetzbar definieren
$simpbook_wochentage = [
    'montag' => __('Montag', 'simple-appointment-booking'),
    'dienstag' => __('Dienstag', 'simple-appointment-booking'),
    'mittwoch' => __('Mittwoch', 'simple-appointment-booking'),
    'donnerstag' => __('Donnerstag', 'simple-appointment-booking'),
    'freitag' => __('Freitag', 'simple-appointment-booking'),
    'samstag' => __('Samstag', 'simple-appointment-booking'),
    'sonntag' => __('Sonntag', 'simple-appointment-booking')
];

// Inaktive Wochentage finden
$simpbook_deaktivierte_wochentage = [];
foreach ($simpbook_wochentag_zeiten as $simpbook_tag_key => $simpbook_tag_settings) {
    if ($simpbook_tag_settings['aktiv'] !== '1') {
        $simpbook_deaktivierte_wochentage[] = $simpbook_tag_key;
    }
}

// Ausgeschlossene Tage in Array umwandeln
$simpbook_ausgeschlossene_tage_array = array();
$simpbook_ausgeschlossene_tage_formatiert = array();
if (!empty($simpbook_ausgeschlossene_tage)) {
    $simpbook_ausgeschlossene_tage_array = explode("\n", str_replace("\r", "", $simpbook_ausgeschlossene_tage));
    $simpbook_ausgeschlossene_tage_array = array_map('trim', $simpbook_ausgeschlossene_tage_array);
    $simpbook_ausgeschlossene_tage_array = array_filter($simpbook_ausgeschlossene_tage_array);

    // Daten formatieren für die Anzeige
    foreach ($simpbook_ausgeschlossene_tage_array as $simpbook_datum_raw) {
        $simpbook_datum_obj = DateTime::createFromFormat('Y-m-d', $simpbook_datum_raw);
        if ($simpbook_datum_obj !== false) {
            $simpbook_ausgeschlossene_tage_formatiert[] = date_i18n(get_option('date_format'), $simpbook_datum_obj->getTimestamp());
        } else {
            // Fallback: Wenn Format nicht passt, Original verwenden
            $simpbook_ausgeschlossene_tage_formatiert[] = $simpbook_datum_raw;
        }
    }
}

/**
 * Sendet eine Bestätigungsmail an den Gast
 *
 * @param array $daten Reservierungsdaten
 * @return bool True bei erfolgreicher E-Mail-Zustellung, ansonsten False
 */
function simpbook_sende_reservierungsbestaetigung($daten) {
    $name = $daten['name'];
    $email = $daten['simpbook_email'];
    $datum_obj = new DateTime($daten['simpbook_datum']);
    $datum = $datum_obj->format('d.m.Y');
    $uhrzeit = $daten['uhrzeit'];
    // E-Mail-Inhalt erstellen (wird nicht mehr verwendet, da E-Mail-Templates verwendet werden)
    $gast_betreff = 'Ihre Buchung wurde bestätigt';
    $gast_nachricht = "Sehr geehrte(r) $name,\n\n";
    $gast_nachricht .= "vielen Dank für Ihre Buchung.\n";
    $gast_nachricht .= "Wir freuen uns Sie am folgenden Tag bei uns begrüssen zu dürfen:\n\n";
    $gast_nachricht .= "Datum: $datum\n";
    $gast_nachricht .= "Uhrzeit: $uhrzeit\n";

    // Absender-Einstellungen
    $firmen_name = get_option('simpbook_firmen_name', get_bloginfo('name'));
    $headers = array(
        'Content-Type: text/plain; charset=UTF-8',
        'From: ' . $firmen_name . ' <' . get_option('admin_email') . '>'
    );

    // E-Mail senden
    return wp_mail($email, $gast_betreff, $gast_nachricht, $headers);
}

// Formular abgeschickt
if (isset($_POST['simpbook_reservierung_neu_submit'])) {
    // Nonce überprüfen
    check_admin_referer('simpbook_reservierung_neu');

    // Daten validieren und sanitizen
    $simpbook_name_val = isset($_POST['simpbook_name']) ? sanitize_text_field(wp_unslash($_POST['simpbook_name'])) : '';
    $simpbook_email_val = isset($_POST['simpbook_email']) ? sanitize_email(wp_unslash($_POST['simpbook_email'])) : '';
    $simpbook_telefon_val = isset($_POST['simpbook_telefon']) ? sanitize_text_field(wp_unslash($_POST['simpbook_telefon'])) : '';
    $simpbook_uhrzeit_val_raw = isset($_POST['simpbook_uhrzeit']) ? sanitize_text_field(wp_unslash($_POST['simpbook_uhrzeit'])) : '';
    // Konvertiere Zeit von 12h-Format (falls vorhanden) zu 24h-Format für DB
    $simpbook_uhrzeit_val = simpbook_parse_time_12h($simpbook_uhrzeit_val_raw);
    $simpbook_dienstleistung_id_val = isset($_POST['simpbook_dienstleistung_id']) ? intval($_POST['simpbook_dienstleistung_id']) : 0;
    $simpbook_mitarbeiter_id_val = isset($_POST['simpbook_mitarbeiter_id']) ? intval($_POST['simpbook_mitarbeiter_id']) : 0; // Optional
    $simpbook_nachricht_val = isset($_POST['simpbook_nachricht']) ? sanitize_textarea_field(wp_unslash($_POST['simpbook_nachricht'])) : '';
    $simpbook_status_val = isset($_POST['simpbook_status']) && in_array(sanitize_text_field(wp_unslash($_POST['simpbook_status'])), ['AUSSTEHEND', 'BESTÄTIGT', 'ABGELEHNT'], true)
                   ? sanitize_text_field(wp_unslash($_POST['simpbook_status']))
                   : 'AUSSTEHEND';
    $simpbook_email_senden_val = isset($_POST['simpbook_send_confirmation_email']) && sanitize_text_field(wp_unslash($_POST['simpbook_send_confirmation_email'])) === '1';

    // Validierung
    if ($simpbook_dienstleistung_id_val <= 0) {
        echo '<div class="notice notice-error"><p>' . esc_html__('Bitte wählen Sie eine Dienstleistung aus.', 'simple-appointment-booking') . '</p></div>';
        $simpbook_dienstleistung_id_val = 0;
    }

    // Datum aus dem Datepicker-Format (dd.mm.yyyy) in YYYY-MM-DD für die Datenbank umwandeln
    $simpbook_datum_eingabe_raw = isset($_POST['simpbook_datum']) ? sanitize_text_field(wp_unslash($_POST['simpbook_datum'])) : '';
    $simpbook_datum_mysql_format_val = '';

    if (!empty($simpbook_datum_eingabe_raw)) {
        // Der Datepicker ist auf 'dd.mm.yy' (europäisch) oder 'mm/dd/yy' (US) konfiguriert
        // Versuche verschiedene Formate
        $simpbook_current_lang = simpbook_get_current_language();
        $simpbook_dt_obj = DateTime::createFromFormat('d.m.Y', $simpbook_datum_eingabe_raw); // dd.mm.yyyy
        if ($simpbook_dt_obj === false) {
            $simpbook_dt_obj = DateTime::createFromFormat('d.m.y', $simpbook_datum_eingabe_raw); // dd.mm.yy
        }
        // US-Format: mm/dd/yyyy oder mm/dd/yy
        if ($simpbook_dt_obj === false && $simpbook_current_lang === 'en_US_AMPM') {
            $simpbook_dt_obj = DateTime::createFromFormat('m/d/Y', $simpbook_datum_eingabe_raw); // mm/dd/yyyy
        }
        if ($simpbook_dt_obj === false && $simpbook_current_lang === 'en_US_AMPM') {
            $simpbook_dt_obj = DateTime::createFromFormat('m/d/y', $simpbook_datum_eingabe_raw); // mm/dd/yy
        }
        if ($simpbook_dt_obj === false) {
            // Fallback: Alte Formate mit Bindestrichen
            $simpbook_dt_obj = DateTime::createFromFormat('d-m-y', $simpbook_datum_eingabe_raw);
        }
        if ($simpbook_dt_obj === false) {
            $simpbook_dt_obj = DateTime::createFromFormat('d-m-Y', $simpbook_datum_eingabe_raw);
        }
        if ($simpbook_dt_obj !== false) {
            $simpbook_datum_mysql_format_val = $simpbook_dt_obj->format('Y-m-d');
        } else {
            echo '<div class="notice notice-error"><p>' . sprintf(
                // translators: %s: Invalid date string that was received
                esc_html__('Ungültiges Datumsformat empfangen: %s. Bitte prüfen Sie Ihre Eingabe.', 'simple-appointment-booking'),
                esc_html($simpbook_datum_eingabe_raw)
            ) . '</p></div>';
            $simpbook_datum_mysql_format_val = current_time('Y-m-d'); // Fallback
        }
    } else {
        // Wenn kein Datum übergeben wurde, Fallback auf aktuelles Datum
        $simpbook_datum_mysql_format_val = current_time('Y-m-d');
        echo '<div class="notice notice-warning is-dismissible"><p>' . esc_html__('Kein Datum angegeben, aktuelles Datum wurde verwendet.', 'simple-appointment-booking') . '</p></div>';
    }

    // Stornierungs-Token generieren
    $simpbook_stornierungs_token = simpbook_generiere_stornierungs_token();

    $simpbook_daten = [
        'name' => $simpbook_name_val,
        'email' => $simpbook_email_val,
        'telefon' => $simpbook_telefon_val,
        'datum' => $simpbook_datum_mysql_format_val,
        'uhrzeit' => $simpbook_uhrzeit_val,
        'dienstleistung_id' => $simpbook_dienstleistung_id_val,
        'mitarbeiter_id' => $simpbook_mitarbeiter_id_val > 0 ? $simpbook_mitarbeiter_id_val : null,
        'nachricht' => $simpbook_nachricht_val,
        'status' => $simpbook_status_val,
        'storniert' => 0,
        'stornierungs_token' => $simpbook_stornierungs_token,
        'erinnerung_gesendet' => 0
    ];

    // In die Datenbank einfügen
    global $wpdb;
    $simpbook_erfolg = false;
    if (!empty($simpbook_daten['datum'])) {
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery -- Plugin-specific table
        $simpbook_erfolg = $wpdb->insert(
            $wpdb->prefix . 'reservierungen',
            $simpbook_daten,
            ['%s', '%s', '%s', '%s', '%s', '%d', '%d', '%s', '%s', '%d', '%s', '%d']
        );
    }

    // Rückmeldung an den Benutzer
    if ($simpbook_erfolg) {
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Reservierung erfolgreich erstellt.', 'simple-appointment-booking') . '</p></div>';

        if ($simpbook_daten['status'] === 'BESTÄTIGT' && $simpbook_email_senden_val) {
            // Verwende die Hauptfunktion aus simple-appointment-booking.php
            $simpbook_reservierung_id = $wpdb->insert_id;
            if ($simpbook_reservierung_id) {
                // Suche nach der Plugin-Instanz über globale Variable
                global $simpbook_db_reservierungen_instance;
                if (!isset($simpbook_db_reservierungen_instance)) {
                    $simpbook_db_reservierungen_instance = new simpbook_DB_Reservierungen();
                }
                // Verwende die Funktion für Statusänderung (sie sendet automatisch E-Mail bei BESTÄTIGT)
                $simpbook_email_gesendet = $simpbook_db_reservierungen_instance->simpbook_benachrichtige_gast_ueber_statusaenderung($simpbook_reservierung_id, 'BESTÄTIGT');
            } else {
                $simpbook_email_gesendet = false;
            }

            if ($simpbook_email_gesendet) {
                echo '<div class="notice notice-success is-dismissible"><p>' . sprintf(
                    // translators: %s: Email address
                    esc_html__('Bestätigungs-E-Mail wurde an %s gesendet.', 'simple-appointment-booking'),
                    esc_html($simpbook_daten['email'])
                ) . '</p></div>';
            } else {
                echo '<div class="notice notice-error"><p>' . esc_html__('Fehler beim Senden der Bestätigungs-E-Mail.', 'simple-appointment-booking') . '</p></div>';
            }
        } elseif ($simpbook_daten['status'] === 'BESTÄTIGT' && !$simpbook_email_senden_val) {
             echo '<div class="notice notice-info is-dismissible"><p>' . esc_html__('Reservierung als "Bestätigt" gespeichert, aber keine E-Mail gesendet (Option nicht ausgewählt).', 'simple-appointment-booking') . '</p></div>';
        }

        // Formular zurücksetzen
        unset($_POST);
    } else {
        if (empty($simpbook_daten['datum'])) {
             echo '<div class="notice notice-error"><p>' . esc_html__('Fehler beim Erstellen der Reservierung: Datum konnte nicht verarbeitet werden.', 'simple-appointment-booking') . '</p></div>';
        } else {
             echo '<div class="notice notice-error"><p>' . sprintf(
                 // translators: %s: Database error message
                 esc_html__('Fehler beim Erstellen der Reservierung: %s', 'simple-appointment-booking'),
                 esc_html($wpdb->last_error)
             ) . '</p></div>';
        }
    }
}
?>

<div class="wrap simpbook-admin-wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Neue Buchung anlegen', 'simple-appointment-booking'); ?></h1>
    <a href="<?php echo esc_url(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-reservierungen'))); ?>" class="page-title-action"><?php esc_html_e('Zurück zur Liste', 'simple-appointment-booking'); ?></a>

    <hr class="wp-header-end">

    <form method="post" action="<?php echo esc_attr(simpbook_get_form_action()); ?>">
        <?php wp_nonce_field('simpbook_reservierung_neu'); ?>

        <table class="form-table simpbook-neue-reservierung-form-table">
            <tr>
                <th scope="row"><label for="simpbook_name"><?php esc_html_e('Name *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_name" id="simpbook_name" type="text"
                           value="<?php echo esc_attr(isset($_POST['simpbook_name']) ? sanitize_text_field(wp_unslash($_POST['simpbook_name'])) : ''); ?>"
                           class="regular-text" required>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_email"><?php esc_html_e('E-Mail *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_email" id="simpbook_email" type="email"
                           value="<?php echo esc_attr(isset($_POST['simpbook_email']) ? sanitize_email(wp_unslash($_POST['simpbook_email'])) : ''); ?>"
                           class="regular-text" required>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_telefon"><?php esc_html_e('Telefon *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_telefon" id="simpbook_telefon" type="text"
                           value="<?php echo esc_attr(isset($_POST['simpbook_telefon']) ? sanitize_text_field(wp_unslash($_POST['simpbook_telefon'])) : ''); ?>"
                           class="regular-text" required>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_dienstleistung_id"><?php esc_html_e('Dienstleistung *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <select name="simpbook_dienstleistung_id" id="simpbook_dienstleistung_id" required>
                        <option value="">-- <?php esc_html_e('Dienstleistung wählen', 'simple-appointment-booking'); ?> --</option>
                        <?php
                        $simpbook_selected_dienstleistung = isset($_POST['simpbook_dienstleistung_id']) ? intval($_POST['simpbook_dienstleistung_id']) : 0;
                        foreach ($simpbook_alle_dienstleistungen as $simpbook_dl) {
                            // Kategorie-Name aus dem JOIN verwenden
                            $simpbook_kategorie_name = $simpbook_dl->kategorie_name ?? '';
                            
                            // Option-Text zusammensetzen
                            $simpbook_option_text = $simpbook_dl->name . ' (' . $simpbook_dl->dauer_minuten . ' Min.)';
                            if (!empty($simpbook_kategorie_name)) {
                                $simpbook_option_text .= ' - ' . $simpbook_kategorie_name;
                            } else {
                                $simpbook_option_text .= ' - ' . __('Keine Gruppe', 'simple-appointment-booking');
                            }
                            
                            echo '<option value="' . esc_attr($simpbook_dl->id) . '"'
                                . selected($simpbook_selected_dienstleistung, $simpbook_dl->id, false) . '>'
                                . esc_html($simpbook_option_text) . '</option>';
                        }
                        ?>
                    </select>
                    <p class="description"><?php esc_html_e('Bitte wählen Sie zuerst eine Dienstleistung aus.', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_datum"><?php esc_html_e('Datum *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <?php
                    // Determine initial date value based on language
                    $simpbook_initial_date_value = current_time('d.m.Y');
                    if (simpbook_get_current_language() === 'en_US_AMPM') {
                        $simpbook_initial_date_value = current_time('m/d/Y');
                    }
                    ?>
                    <input name="simpbook_datum" id="simpbook_datum" type="text" class="datepicker"
                           value="<?php echo esc_attr(isset($_POST['simpbook_datum']) ? sanitize_text_field(wp_unslash($_POST['simpbook_datum'])) : $simpbook_initial_date_value); ?>"
                           required autocomplete="off">
                    <p class="description" id="available-days-info" style="display:none;"></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_mitarbeiter_id"><?php esc_html_e('Mitarbeiter', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <select name="simpbook_mitarbeiter_id" id="simpbook_mitarbeiter_id">
                        <option value="0">-- <?php esc_html_e('Kein bestimmter Mitarbeiter', 'simple-appointment-booking'); ?> --</option>
                        <option value="" disabled>-- <?php esc_html_e('Bitte Datum und Dienstleistung auswählen', 'simple-appointment-booking'); ?> --</option>
                    </select>
                    <p class="description"><?php esc_html_e('Optional: Wählen Sie einen bestimmten Mitarbeiter aus. Lassen Sie das Feld leer, um den ersten verfügbaren Mitarbeiter zu verwenden.', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_uhrzeit"><?php esc_html_e('Uhrzeit *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <select name="simpbook_uhrzeit" id="simpbook_uhrzeit" required>
                        <option value="">-- <?php esc_html_e('Uhrzeit wählen', 'simple-appointment-booking'); ?> --</option>
                    </select>
                    <p class="description"><?php esc_html_e('Bitte wählen Sie zuerst Datum und Dienstleistung aus.', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_nachricht"><?php esc_html_e('Nachricht', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <textarea name="simpbook_nachricht" id="simpbook_nachricht" rows="5" cols="50"><?php
                        echo esc_textarea(isset($_POST['simpbook_nachricht']) ? sanitize_textarea_field(wp_unslash($_POST['simpbook_nachricht'])) : '');
                    ?></textarea>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_status"><?php esc_html_e('Status', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <select name="simpbook_status" id="simpbook_status">
                        <?php $simpbook_status_value = isset($_POST['simpbook_status']) ? sanitize_text_field(wp_unslash($_POST['simpbook_status'])) : ''; ?>
                        <option value="AUSSTEHEND" <?php selected($simpbook_status_value, 'AUSSTEHEND'); ?>><?php esc_html_e('Ausstehend', 'simple-appointment-booking'); ?></option>
                        <option value="BESTÄTIGT" <?php selected($simpbook_status_value, 'BESTÄTIGT'); ?>><?php esc_html_e('Bestätigt', 'simple-appointment-booking'); ?></option>
                        <option value="ABGELEHNT" <?php selected($simpbook_status_value, 'ABGELEHNT'); ?>><?php esc_html_e('Abgelehnt', 'simple-appointment-booking'); ?></option>
                    </select>
                </td>
            </tr>
            <tr id="send_email_row"> <th scope="row"><label for="simpbook_send_confirmation_email"><?php esc_html_e('Bestätigungs-E-Mail an Gast senden?', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input type="checkbox" name="simpbook_send_confirmation_email" id="simpbook_send_confirmation_email" value="1" <?php checked(true); ?>>
                    <span class="description"><?php esc_html_e('Nur relevant, wenn Status "Bestätigt" ist.', 'simple-appointment-booking'); ?></span>
                </td>
            </tr>
        </table>

        <input type="submit" name="simpbook_reservierung_neu_submit" class="button button-primary" value="<?php esc_attr_e('Reservierung erstellen', 'simple-appointment-booking'); ?>">
    </form>
</div>







