<?php
// admin/mitarbeiter.php
// Direkten Zugriff verhindern
if (!defined('ABSPATH')) {
    exit;
}

// Testphase-Hinweis anzeigen
simpbook_display_trial_notice_on_admin_pages();

// CSS wird bereits in admin_skripte_laden() geladen - NICHT hier, da zu spät!

global $wpdb;
$simpbook_table_name = $wpdb->prefix . 'mitarbeiter';

// Löschen
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for action check only
if (isset($_GET['simpbook_aktion']) && $_GET['simpbook_aktion'] === 'loeschen' && isset($_GET['simpbook_id'])) {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for action check only
    $simpbook_id = intval($_GET['simpbook_id']);
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for nonce check only
    if (isset($_GET['simpbook_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['simpbook_nonce'])), 'simpbook_delete_mitarbeiter_' . $simpbook_id)) {
        // Profilfoto löschen wenn vorhanden
        $simpbook_mitarbeiter = $wpdb->get_row($wpdb->prepare("SELECT profilfoto_url FROM %i WHERE id = %d", $simpbook_table_name, $simpbook_id)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data
        if ($simpbook_mitarbeiter && !empty($simpbook_mitarbeiter->profilfoto_url)) {
            $simpbook_attachment_id = attachment_url_to_postid($simpbook_mitarbeiter->profilfoto_url);
            if ($simpbook_attachment_id) {
                wp_delete_attachment($simpbook_attachment_id, true);
            }
        }
        $wpdb->delete($simpbook_table_name, ['id' => $simpbook_id], ['%d']); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data
        $wpdb->delete($wpdb->prefix . 'mitarbeiter_dienstleistungen', ['mitarbeiter_id' => $simpbook_id], ['%d']); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data
        wp_safe_redirect(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-mitarbeiter&simpbook_nachricht=geloescht')));
        exit;
    }
}

// Aktivieren/Deaktivieren
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for action check only
if (isset($_GET['simpbook_aktion']) && in_array($_GET['simpbook_aktion'], ['aktivieren', 'deaktivieren']) && isset($_GET['simpbook_id'])) {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for action check only
    $simpbook_id = intval($_GET['simpbook_id']);
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for nonce check only
    if (isset($_GET['simpbook_nonce']) && wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['simpbook_nonce'])), 'simpbook_toggle_mitarbeiter_' . $simpbook_id)) {
        $simpbook_aktiv = $_GET['simpbook_aktion'] === 'aktivieren' ? 1 : 0;
        $wpdb->update($simpbook_table_name, ['aktiv' => $simpbook_aktiv], ['id' => $simpbook_id], ['%d'], ['%d']); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data
        wp_safe_redirect(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-mitarbeiter&simpbook_nachricht=aktualisiert')));
        exit;
    }
}

// Alle Mitarbeiter laden
$simpbook_mitarbeiter = $wpdb->get_results($wpdb->prepare("SELECT * FROM %i ORDER BY sortierung ASC, name ASC", $simpbook_table_name)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data

// Nachrichten
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for display message only
if (isset($_GET['simpbook_nachricht'])) {
    $simpbook_nachricht_key = sanitize_text_field(wp_unslash($_GET['simpbook_nachricht']));
    $simpbook_messages = [
        'gespeichert' => esc_html__('Mitarbeiter erfolgreich gespeichert.', 'simple-appointment-booking'),
        'geloescht' => esc_html__('Mitarbeiter erfolgreich gelöscht.', 'simple-appointment-booking'),
        'aktualisiert' => esc_html__('Mitarbeiter erfolgreich aktualisiert.', 'simple-appointment-booking'),
    ];
    if (isset($simpbook_messages[$simpbook_nachricht_key])) {
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html($simpbook_messages[$simpbook_nachricht_key]) . '</p></div>';
    }
}
?>

<div class="wrap simpbook-admin-wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Mitarbeiter', 'simple-appointment-booking'); ?></h1>
    <hr class="wp-header-end">

    <!-- Action Buttons Container - Always visible -->
    <div class="view-toggle-container">
        <a href="<?php echo esc_url(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-mitarbeiter&simpbook_aktion=bearbeiten'))); ?>" class="page-title-action"><?php esc_html_e('Neuen Mitarbeiter hinzufügen', 'simple-appointment-booking'); ?></a>
        
        <?php if (!empty($simpbook_mitarbeiter)) : ?>
            <div class="reservierungen-search-container">
                <span class="dashicons dashicons-search"></span>
                <input type="text" 
                       id="mitarbeiter-search-input" 
                       placeholder="<?php esc_attr_e('Nach Mitarbeiter suchen...', 'simple-appointment-booking'); ?>"
                       aria-label="<?php esc_attr_e('Mitarbeiter durchsuchen', 'simple-appointment-booking'); ?>">
                <button type="button" id="clear-search-btn-mitarbeiter" class="dashicons dashicons-no-alt" style="display: none;" aria-label="<?php esc_attr_e('Suche löschen', 'simple-appointment-booking'); ?>"></button>
            </div>
            
            <button type="button" id="toggle-view-btn" class="button button-secondary">
                <span class="dashicons dashicons-grid-view" style="margin-right: 5px; vertical-align: middle;"></span>
                <span id="toggle-view-text"><?php esc_html_e('Kartenansicht', 'simple-appointment-booking'); ?></span>
            </button>
        <?php endif; ?>
    </div>

    <?php if (empty($simpbook_mitarbeiter)) : ?>
        <div class="notice notice-info"><p><?php esc_html_e('Noch keine Mitarbeiter vorhanden.', 'simple-appointment-booking'); ?></p></div>
    <?php else : ?>

        <div class="simpbook-list-container">
            <!-- Desktop-Tabelle -->
            <div class="desktop-mitarbeiter-tabelle">
            <div style="overflow-x: auto; width: 100%;">
                <table class="wp-list-table widefat fixed striped mitarbeiter-haupttabelle">
                    <thead>
                        <tr>
                            <th><?php esc_html_e('Foto', 'simple-appointment-booking'); ?></th>
                            <th><?php esc_html_e('Name', 'simple-appointment-booking'); ?></th>
                            <th><?php esc_html_e('E-Mail', 'simple-appointment-booking'); ?></th>
                            <th><?php esc_html_e('Telefon', 'simple-appointment-booking'); ?></th>
                            <th><?php esc_html_e('Status', 'simple-appointment-booking'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($simpbook_mitarbeiter as $simpbook_mit) : ?>
                            <tr class="mitarbeiter-row-clickable"
                                data-mitarbeiter-id="<?php echo esc_attr($simpbook_mit->id); ?>"
                                data-bearbeiten-url="<?php echo esc_url(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-mitarbeiter&simpbook_aktion=bearbeiten&simpbook_id=' . $simpbook_mit->id))); ?>"
                                style="cursor: pointer;">
                                <td>
                                    <?php if (!empty($simpbook_mit->profilfoto_url)) : ?>
                                        <img src="<?php echo esc_url($simpbook_mit->profilfoto_url); ?>" alt="<?php echo esc_attr($simpbook_mit->name); ?>" style="width: 40px; height: 40px; border-radius: 50%; object-fit: cover;">
                                    <?php else : ?>
                                        <div style="width: 40px; height: 40px; border-radius: 50%; background: #ddd; display: flex; align-items: center; justify-content: center; font-weight: bold;">
                                            <span><?php echo esc_html(mb_substr($simpbook_mit->name, 0, 1)); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td><strong><?php echo esc_html($simpbook_mit->name); ?></strong></td>
                                <td><?php echo esc_html($simpbook_mit->email ?: '-'); ?></td>
                                <td><?php echo esc_html($simpbook_mit->telefon ?: '-'); ?></td>
                                <td>
                                    <?php if ($simpbook_mit->aktiv) : ?>
                                        <span class="status-aktiv"><?php esc_html_e('Aktiv', 'simple-appointment-booking'); ?></span>
                                    <?php else : ?>
                                        <span class="status-inaktiv"><?php esc_html_e('Inaktiv', 'simple-appointment-booking'); ?></span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Mobile/Tablet Kartenansicht -->
        <div class="mobile-mitarbeiter-karten">
            <?php foreach ($simpbook_mitarbeiter as $simpbook_mit) : ?>
                <div class="mitarbeiter-karte mitarbeiter-karte-clickable"
                    data-mitarbeiter-id="<?php echo esc_attr($simpbook_mit->id); ?>"
                    data-bearbeiten-url="<?php echo esc_url(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-mitarbeiter&simpbook_aktion=bearbeiten&simpbook_id=' . $simpbook_mit->id))); ?>"
                    style="cursor: pointer;">
                    <div class="mitarbeiter-karte-header">
                        <div class="mitarbeiter-foto">
                            <?php if (!empty($simpbook_mit->profilfoto_url)) : ?>
                                <img src="<?php echo esc_url($simpbook_mit->profilfoto_url); ?>" alt="<?php echo esc_attr($simpbook_mit->name); ?>">
                            <?php else : ?>
                                <div class="mitarbeiter-avatar">
                                    <span><?php echo esc_html(mb_substr($simpbook_mit->name, 0, 1)); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="mitarbeiter-header-info">
                            <div class="mitarbeiter-name"><?php echo esc_html($simpbook_mit->name); ?></div>
                            <div class="mitarbeiter-id"><?php esc_html_e('ID:', 'simple-appointment-booking'); ?> <?php echo esc_html($simpbook_mit->id); ?></div>
                        </div>
                    </div>

                    <div class="mitarbeiter-karte-body">
                        <div class="mitarbeiter-info-gruppe">
                            <?php if (!empty($simpbook_mit->email)) : ?>
                                <div class="mitarbeiter-info-zeile">
                                    <span class="info-label"><?php esc_html_e('E-Mail:', 'simple-appointment-booking'); ?></span>
                                    <span class="info-value"><?php echo esc_html($simpbook_mit->email); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($simpbook_mit->telefon)) : ?>
                                <div class="mitarbeiter-info-zeile">
                                    <span class="info-label"><?php esc_html_e('Telefon:', 'simple-appointment-booking'); ?></span>
                                    <span class="info-value"><?php echo esc_html($simpbook_mit->telefon); ?></span>
                                </div>
                            <?php endif; ?>
                            <div class="mitarbeiter-info-zeile">
                                <span class="info-label"><?php esc_html_e('Status:', 'simple-appointment-booking'); ?></span>
                                <span class="info-value">
                                    <?php if ($simpbook_mit->aktiv) : ?>
                                        <span class="status-aktiv"><?php esc_html_e('Aktiv', 'simple-appointment-booking'); ?></span>
                                    <?php else : ?>
                                        <span class="status-inaktiv"><?php esc_html_e('Inaktiv', 'simple-appointment-booking'); ?></span>
                                    <?php endif; ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        </div> <!-- Ende simpbook-list-container -->
    <?php endif; ?>
</div>







