<?php
// admin/mitarbeiter-bearbeiten.php
// Direkten Zugriff verhindern
if (!defined('ABSPATH')) {
    exit;
}

// Testphase-Hinweis anzeigen
simpbook_display_trial_notice_on_admin_pages();

// CSS und JS werden bereits in admin_skripte_laden() geladen - NICHT hier, da zu spät!

global $wpdb;
$simpbook_mitarbeiter_table = $wpdb->prefix . 'mitarbeiter';
$simpbook_relation_table = $wpdb->prefix . 'mitarbeiter_dienstleistungen';

// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for ID check only
$simpbook_mitarbeiter_id = isset($_GET['simpbook_id']) ? intval($_GET['simpbook_id']) : 0;
$simpbook_mitarbeiter = null;
$simpbook_zugewiesene_dienstleistungen = [];
if ($simpbook_mitarbeiter_id > 0) {
    $simpbook_mitarbeiter = $wpdb->get_row($wpdb->prepare("SELECT * FROM %i WHERE id = %d", $simpbook_mitarbeiter_table, $simpbook_mitarbeiter_id)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data
    if ($simpbook_mitarbeiter) {
        $simpbook_zugewiesene = $wpdb->get_col($wpdb->prepare("SELECT dienstleistung_id FROM %i WHERE mitarbeiter_id = %d", $simpbook_relation_table, $simpbook_mitarbeiter_id)); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data
        $simpbook_zugewiesene_dienstleistungen = array_map('intval', $simpbook_zugewiesene);
    }
}

// Wochentage für Arbeitszeiten
$simpbook_wochentage = [
    'montag' => __('Montag', 'simple-appointment-booking'),
    'dienstag' => __('Dienstag', 'simple-appointment-booking'),
    'mittwoch' => __('Mittwoch', 'simple-appointment-booking'),
    'donnerstag' => __('Donnerstag', 'simple-appointment-booking'),
    'freitag' => __('Freitag', 'simple-appointment-booking'),
    'samstag' => __('Samstag', 'simple-appointment-booking'),
    'sonntag' => __('Sonntag', 'simple-appointment-booking')
];

// Arbeitszeiten laden oder Standardwerte
$simpbook_arbeitszeiten = [];
if ($simpbook_mitarbeiter && !empty($simpbook_mitarbeiter->arbeitszeiten)) {
    $simpbook_arbeitszeiten = json_decode($simpbook_mitarbeiter->arbeitszeiten, true);
    if (!is_array($simpbook_arbeitszeiten)) {
        $simpbook_arbeitszeiten = [];
    }
}
$simpbook_standard_beginn = '09:00';
$simpbook_standard_ende = '18:00';
foreach ($simpbook_wochentage as $simpbook_tag_key => $simpbook_tag_name) {
    if (!isset($simpbook_arbeitszeiten[$simpbook_tag_key])) {
        $simpbook_arbeitszeiten[$simpbook_tag_key] = [
            'aktiv' => '1',
            'beginn' => $simpbook_standard_beginn,
            'ende' => $simpbook_standard_ende
        ];
    }
}

// Formular-Verarbeitung erfolgt jetzt im admin_init Hook (handle_mitarbeiter_submit)
// in simple-appointment-booking.php, damit Redirects funktionieren, bevor Header gesendet werden

// Werte für Formular
$simpbook_name_value = $simpbook_mitarbeiter ? $simpbook_mitarbeiter->name : '';
$simpbook_email_value = $simpbook_mitarbeiter ? $simpbook_mitarbeiter->email : '';
$simpbook_telefon_value = $simpbook_mitarbeiter ? $simpbook_mitarbeiter->telefon : '';
$simpbook_profilfoto_url_value = $simpbook_mitarbeiter ? $simpbook_mitarbeiter->profilfoto_url : '';
$simpbook_aktiv_checked = $simpbook_mitarbeiter ? $simpbook_mitarbeiter->aktiv : 1;
$simpbook_sortierung_value = $simpbook_mitarbeiter ? $simpbook_mitarbeiter->sortierung : 0;
// Checkbox für individuelle Arbeitszeiten: aktiviert, wenn bereits Arbeitszeiten vorhanden sind
$simpbook_individuelle_arbeitszeiten_aktiv = ($simpbook_mitarbeiter && !empty($simpbook_mitarbeiter->arbeitszeiten)) ? 1 : 0;

// PWA App-Zugang Werte
$simpbook_app_zugang_aktiv = 0;
$simpbook_wp_user_id = 0;
$simpbook_wp_user = null;

// Prüfen ob neue Spalten existieren
// phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, PluginCheck.Security.DirectDB.UnescapedDBParameter
$simpbook_app_columns_exist = $wpdb->get_results("SHOW COLUMNS FROM $simpbook_mitarbeiter_table LIKE 'app_zugang_aktiv'");
if (!empty($simpbook_app_columns_exist) && $simpbook_mitarbeiter) {
    $simpbook_app_zugang_aktiv = isset($simpbook_mitarbeiter->app_zugang_aktiv) ? (int) $simpbook_mitarbeiter->app_zugang_aktiv : 0;
    $simpbook_wp_user_id = isset($simpbook_mitarbeiter->wp_user_id) ? (int) $simpbook_mitarbeiter->wp_user_id : 0;
    
    if ($simpbook_wp_user_id > 0) {
        $simpbook_wp_user = get_user_by('ID', $simpbook_wp_user_id);
    }
}

// Alle Dienstleistungen für Checkbox-Liste
$simpbook_alle_dienstleistungen = simpbook_get_all_dienstleistungen(false);

// Kategorien für Gruppierung laden
$simpbook_alle_kategorien = simpbook_get_all_kategorien();
$simpbook_kategorien_map = [];
foreach ($simpbook_alle_kategorien as $simpbook_kat) {
    $simpbook_kategorien_map[$simpbook_kat->id] = $simpbook_kat->name;
}

// Nachrichten anzeigen
// 1. Wert sicher abrufen und bereinigen
// phpcs:ignore WordPress.Security.NonceVerification.Recommended
$simpbook_nachricht_key = isset( $_GET['simpbook_nachricht'] ) ? sanitize_key( wp_unslash( $_GET['simpbook_nachricht'] ) ) : '';

$simpbook_success_message = '';
$simpbook_error_message   = '';

if ( ! empty( $simpbook_nachricht_key ) ) {
    $simpbook_messages = [
        'gespeichert'  => esc_html__( 'Mitarbeiter erfolgreich gespeichert.', 'simple-appointment-booking' ),
        'aktualisiert' => esc_html__( 'Mitarbeiter erfolgreich aktualisiert.', 'simple-appointment-booking' ),
        'fehler_name'  => esc_html__( 'Bitte geben Sie einen Namen ein.', 'simple-appointment-booking' ),
        'fehler_email_app_zugang' => esc_html__( 'Für den App-Zugang ist eine E-Mail-Adresse erforderlich.', 'simple-appointment-booking' ),
    ];

    if ( array_key_exists( $simpbook_nachricht_key, $simpbook_messages ) ) {
        if ( 'fehler_name' === $simpbook_nachricht_key ) {
            $simpbook_error_message = $simpbook_messages[ $simpbook_nachricht_key ];
        } elseif ( 'fehler_email_app_zugang' === $simpbook_nachricht_key ) {
            $simpbook_error_message = $simpbook_messages[ $simpbook_nachricht_key ];
        } else {
            $simpbook_success_message = $simpbook_messages[ $simpbook_nachricht_key ];
        }
    }
}

// Aktuelle Sprache laden (für sprachspezifische Zeitformat-Konvertierung im Frontend)
$simpbook_current_language = simpbook_get_current_language();
$simpbook_month_names = simpbook_get_datepicker_month_names($simpbook_current_language);
$simpbook_day_names = simpbook_get_datepicker_day_names($simpbook_current_language);
?>

<div class="wrap simpbook-admin-wrap">
    <?php if (!empty($simpbook_success_message)) : ?>
        <div class="notice notice-success is-dismissible">
            <p><?php echo esc_html($simpbook_success_message); ?></p>
        </div>
    <?php endif; ?>
    <?php if (!empty($simpbook_error_message)) : ?>
        <div class="notice notice-error is-dismissible">
            <p><?php echo esc_html($simpbook_error_message); ?></p>
        </div>
    <?php endif; ?>
    <h1 class="wp-heading-inline"><?php echo $simpbook_mitarbeiter_id > 0 ? esc_html__('Mitarbeiter bearbeiten', 'simple-appointment-booking') : esc_html__('Neuen Mitarbeiter hinzufügen', 'simple-appointment-booking'); ?></h1>
    <a href="<?php echo esc_url(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-mitarbeiter'))); ?>" class="page-title-action"><?php esc_html_e('Zurück zur Liste', 'simple-appointment-booking'); ?></a>
    <hr class="wp-header-end">

    <form method="post" action="<?php echo esc_attr(simpbook_get_form_action()); ?>" class="mitarbeiter-edit-form">
        <?php wp_nonce_field('simpbook_mitarbeiter_speichern'); ?>

        <!-- Desktop Ansicht: Tabellenformat -->
        <table class="form-table desktop-mitarbeiter-form">
            <tr>
                <th scope="row"><label for="simpbook_name"><?php esc_html_e('Name *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_name" type="text" id="simpbook_name"
                           value="<?php echo esc_attr($simpbook_name_value); ?>"
                           class="regular-text">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_email"><?php esc_html_e('E-Mail', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_email" type="email" id="simpbook_email"
                           value="<?php echo esc_attr($simpbook_email_value); ?>"
                           class="regular-text">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_telefon"><?php esc_html_e('Telefon', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_telefon" type="text" id="simpbook_telefon"
                           value="<?php echo esc_attr($simpbook_telefon_value); ?>"
                           class="regular-text">
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_profilfoto_url"><?php esc_html_e('Profilfoto', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_profilfoto_url" type="text" id="simpbook_profilfoto_url"
                           value="<?php echo esc_attr($simpbook_profilfoto_url_value); ?>"
                           class="regular-text">
                    <button type="button" class="button" id="upload_foto_button"><?php esc_html_e('Foto auswählen', 'simple-appointment-booking'); ?></button>
                    <button type="button" class="button" id="remove_foto_button" style="<?php echo empty($simpbook_profilfoto_url_value) ? 'display:none;' : ''; ?>"><?php esc_html_e('Foto entfernen', 'simple-appointment-booking'); ?></button>
                    <div id="foto_preview" style="margin-top: 10px;">
                        <?php if (!empty($simpbook_profilfoto_url_value)) : ?>
                            <img src="<?php echo esc_url($simpbook_profilfoto_url_value); ?>" alt="Profilfoto" style="max-width: 200px; max-height: 200px; border-radius: 4px;">
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_dienstleistungen"><?php esc_html_e('Dienstleistungen', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <?php if (empty($simpbook_alle_dienstleistungen)) : ?>
                        <p><?php esc_html_e('Noch keine Dienstleistungen vorhanden. Bitte erstellen Sie zuerst Dienstleistungen.', 'simple-appointment-booking'); ?></p>
                    <?php else : ?>
                        <div class="dienstleistungen-checkboxes">
                            <?php foreach ($simpbook_alle_dienstleistungen as $simpbook_dienstleistung) : 
                                $simpbook_kategorie_name = '';
                                if (!empty($simpbook_dienstleistung->kategorie_id) && isset($simpbook_kategorien_map[$simpbook_dienstleistung->kategorie_id])) {
                                    $simpbook_kategorie_name = $simpbook_kategorien_map[$simpbook_dienstleistung->kategorie_id];
                                }
                            ?>
                                <label style="display: block; margin-bottom: 5px;">
                                    <input type="checkbox" name="simpbook_dienstleistungen[]" value="<?php echo esc_attr($simpbook_dienstleistung->id); ?>"
                                           <?php checked(in_array($simpbook_dienstleistung->id, $simpbook_zugewiesene_dienstleistungen)); ?>>
                                    <?php echo esc_html($simpbook_dienstleistung->name); ?>
                                    <span style="color: #999;">(<?php echo esc_html($simpbook_dienstleistung->dauer_minuten); ?> Min.)</span>
                                    <?php if (!empty($simpbook_kategorie_name)) : ?>
                                        <span style="color: #666;"> - <?php echo esc_html($simpbook_kategorie_name); ?></span>
                                    <?php else : ?>
                                        <span style="color: #999; font-style: italic;"> - <?php esc_html_e('Keine Gruppe', 'simple-appointment-booking'); ?></span>
                                    <?php endif; ?>
                                </label>
                            <?php endforeach; ?>
                        </div>
                        <p class="description"><?php esc_html_e('Wählen Sie die Dienstleistungen aus, die dieser Mitarbeiter anbietet.', 'simple-appointment-booking'); ?></p>
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th scope="row"><label><?php esc_html_e('Individuelle Arbeitszeiten', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <label for="simpbook_individuelle_arbeitszeiten_aktiv">
                        <input name="simpbook_individuelle_arbeitszeiten_aktiv" type="checkbox"
                               id="simpbook_individuelle_arbeitszeiten_aktiv" value="1"
                               <?php checked($simpbook_individuelle_arbeitszeiten_aktiv, 1); ?>>
                        <strong><?php esc_html_e('Individuelle Arbeitszeiten aktivieren', 'simple-appointment-booking'); ?></strong>
                    </label>
                    <p class="description"><?php esc_html_e('Wenn aktiviert, verwendet dieser Mitarbeiter individuelle Arbeitszeiten statt der globalen Öffnungszeiten.', 'simple-appointment-booking'); ?></p>
                    <div id="arbeitszeiten-container" style="margin-top: 15px; <?php echo $simpbook_individuelle_arbeitszeiten_aktiv ? '' : 'display:none;'; ?>">
                    <table class="form-table" style="margin-top: 10px;">
                        <?php foreach ($simpbook_wochentage as $simpbook_tag_key => $simpbook_tag_name) : ?>
                            <tr>
                                <th scope="row" style="width: 150px;"><?php echo esc_html($simpbook_tag_name); ?></th>
                                <td>
                                    <div class="arbeitszeit-td-container">
                                        <label for="arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv">
                                            <input name="simpbook_arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv" type="checkbox"
                                                   id="arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv" value="1"
                                                   <?php checked($simpbook_arbeitszeiten[$simpbook_tag_key]['aktiv'] ?? '0', '1'); ?>>
                                            <?php esc_html_e('Aktiv', 'simple-appointment-booking'); ?>
                                        </label>
                                        <div class="arbeitszeit-times-group">
                                            <span class="time-input-group">
                                                <span class="time-label"><?php esc_html_e('Von:', 'simple-appointment-booking'); ?></span>
                                                <input name="simpbook_arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_beginn" type="time"
                                                       value="<?php echo esc_attr($simpbook_arbeitszeiten[$simpbook_tag_key]['beginn'] ?? $simpbook_standard_beginn); ?>" class="time-input">
                                            </span>
                                            <span class="time-input-group">
                                                <span class="time-label"><?php esc_html_e('Bis:', 'simple-appointment-booking'); ?></span>
                                                <input name="simpbook_arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_ende" type="time"
                                                       value="<?php echo esc_attr($simpbook_arbeitszeiten[$simpbook_tag_key]['ende'] ?? $simpbook_standard_ende); ?>" class="time-input">
                                            </span>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                    </div>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_sortierung"><?php esc_html_e('Sortierung', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_sortierung" type="number" id="simpbook_sortierung"
                           value="<?php echo esc_attr($simpbook_sortierung_value); ?>"
                           min="0" step="1" class="small-text">
                    <p class="description"><?php esc_html_e('Niedrigere Zahlen werden zuerst angezeigt.', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e('Status', 'simple-appointment-booking'); ?></th>
                <td>
                    <label for="simpbook_aktiv">
                        <input name="simpbook_aktiv" type="checkbox" id="simpbook_aktiv" value="1" <?php checked($simpbook_aktiv_checked, 1); ?>>
                        <?php esc_html_e('Aktiv (wird im Frontend angezeigt)', 'simple-appointment-booking'); ?>
                    </label>
                    <p class="description"><?php esc_html_e('Ein aktiver Mitarbeiter wird automatisch im Frontend-Buchungsformular angezeigt.', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <?php if (!empty($simpbook_app_columns_exist)) : ?>
            <tr>
                <th scope="row"><?php esc_html_e('App-Zugang', 'simple-appointment-booking'); ?></th>
                <td>
                    <div class="simpbook-app-zugang-section">
                        <label for="simpbook_app_zugang_aktiv" style="display: block; margin-bottom: 10px;">
                            <input name="simpbook_app_zugang_aktiv" type="checkbox" id="simpbook_app_zugang_aktiv" value="1" <?php checked($simpbook_app_zugang_aktiv, 1); ?>>
                            <strong><?php esc_html_e('App-Zugang aktivieren', 'simple-appointment-booking'); ?></strong>
                        </label>
                        <p class="description" style="margin-bottom: 15px;"><?php esc_html_e('Wenn aktiviert, kann dieser Mitarbeiter die Buchungs-App auf dem Smartphone nutzen.', 'simple-appointment-booking'); ?></p>
                        
                        <?php if ($simpbook_mitarbeiter_id > 0) : ?>
                            <div id="simpbook-app-zugang-details" style="margin-top: 15px; padding: 15px; background: #f9f9f9; border-radius: 8px; <?php echo $simpbook_app_zugang_aktiv ? '' : 'display:none;'; ?>">
                                <?php if ($simpbook_wp_user) : ?>
                                    <div class="simpbook-app-user-info" style="margin-bottom: 15px;">
                                        <p><strong><?php esc_html_e('WordPress-Benutzer:', 'simple-appointment-booking'); ?></strong></p>
                                        <p>
                                            <?php echo esc_html($simpbook_wp_user->display_name); ?> 
                                            (<code><?php echo esc_html($simpbook_wp_user->user_login); ?></code>)
                                            - <?php echo esc_html($simpbook_wp_user->user_email); ?>
                                        </p>
                                        <p>
                                            <span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
                                            <?php esc_html_e('Benutzer ist verknüpft', 'simple-appointment-booking'); ?>
                                        </p>
                                    </div>
                                    <button type="button" class="button simpbook-send-app-email" data-mitarbeiter-id="<?php echo esc_attr($simpbook_mitarbeiter_id); ?>">
                                        <span class="dashicons dashicons-email-alt" style="margin-top: 4px;"></span>
                                        <?php esc_html_e('Zugangsdaten erneut senden', 'simple-appointment-booking'); ?>
                                    </button>
                                <?php else : ?>
                                    <p style="margin-bottom: 10px;">
                                        <span class="dashicons dashicons-warning" style="color: #f0ad4e;"></span>
                                        <?php esc_html_e('Noch kein WordPress-Benutzer verknüpft.', 'simple-appointment-booking'); ?>
                                    </p>
                                    <?php if (!empty($simpbook_email_value)) : ?>
                                        <p class="description" style="margin-bottom: 15px;">
                                            <?php esc_html_e('Beim Speichern mit aktiviertem App-Zugang wird automatisch ein WordPress-Benutzer erstellt und eine E-Mail mit den Zugangsdaten versendet.', 'simple-appointment-booking'); ?>
                                        </p>
                                    <?php else : ?>
                                        <p class="description" style="color: #d32f2f; margin-bottom: 15px;">
                                            <span class="dashicons dashicons-no" style="color: #d32f2f;"></span>
                                            <?php esc_html_e('Bitte geben Sie eine E-Mail-Adresse ein, um den App-Zugang zu aktivieren.', 'simple-appointment-booking'); ?>
                                        </p>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        <?php else : ?>
                            <p class="description" style="font-style: italic;">
                                <?php esc_html_e('Speichern Sie den Mitarbeiter zuerst, um den App-Zugang zu konfigurieren.', 'simple-appointment-booking'); ?>
                            </p>
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
            <?php endif; ?>
        </table>

        <!-- Mobile/Tablet Ansicht: Kartenformat -->
        <div class="mobile-mitarbeiter-form-card">
            <div class="mitarbeiter-form-card">
                <div class="mitarbeiter-form-card-header">
                    <h2><?php echo $simpbook_mitarbeiter_id > 0 ? esc_html__('Mitarbeiter bearbeiten', 'simple-appointment-booking') : esc_html__('Neuen Mitarbeiter hinzufügen', 'simple-appointment-booking'); ?></h2>
                </div>

                <div class="mitarbeiter-form-card-body">
                    <!-- Name -->
                    <div class="form-field-group">
                        <label for="name-mobile" class="form-field-label"><?php esc_html_e('Name *', 'simple-appointment-booking'); ?></label>
                        <input name="simpbook_name" type="text" id="name-mobile"
                               value="<?php echo esc_attr($simpbook_name_value); ?>"
                               class="form-field-input">
                    </div>

                    <!-- E-Mail -->
                    <div class="form-field-group">
                        <label for="email-mobile" class="form-field-label"><?php esc_html_e('E-Mail', 'simple-appointment-booking'); ?></label>
                        <input name="simpbook_email" type="email" id="email-mobile"
                               value="<?php echo esc_attr($simpbook_email_value); ?>"
                               class="form-field-input">
                    </div>

                    <!-- Telefon -->
                    <div class="form-field-group">
                        <label for="telefon-mobile" class="form-field-label"><?php esc_html_e('Telefon', 'simple-appointment-booking'); ?></label>
                        <input name="simpbook_telefon" type="text" id="telefon-mobile"
                               value="<?php echo esc_attr($simpbook_telefon_value); ?>"
                               class="form-field-input">
                    </div>

                    <!-- Profilfoto -->
                    <div class="form-field-group">
                        <label class="form-field-label"><?php esc_html_e('Profilfoto', 'simple-appointment-booking'); ?></label>
                        <div id="foto-preview-mobile" style="margin-bottom: 10px; text-align: center;">
                            <?php if (!empty($simpbook_profilfoto_url_value)) : ?>
                                <img src="<?php echo esc_url($simpbook_profilfoto_url_value); ?>" alt="Profilfoto" style="max-width: 150px; max-height: 150px; border-radius: 8px; border: 2px solid #ddd;">
                            <?php endif; ?>
                        </div>
                        <input name="simpbook_profilfoto_url" type="hidden" id="profilfoto_url-mobile"
                               value="<?php echo esc_attr($simpbook_profilfoto_url_value); ?>">
                        <button type="button" class="button" id="upload_foto_button-mobile"><?php esc_html_e('Foto auswählen', 'simple-appointment-booking'); ?></button>
                        <button type="button" class="button" id="remove_foto_button-mobile" style="<?php echo empty($simpbook_profilfoto_url_value) ? 'display:none;' : ''; ?>"><?php esc_html_e('Foto entfernen', 'simple-appointment-booking'); ?></button>
                    </div>

                    <!-- Dienstleistungen -->
                    <div class="form-field-group">
                        <label class="form-field-label"><?php esc_html_e('Dienstleistungen', 'simple-appointment-booking'); ?></label>
                        <p class="description"><?php esc_html_e('Die Dienstleistungen werden oben in der Desktop-Ansicht verwaltet.', 'simple-appointment-booking'); ?></p>
                    </div>

                    <!-- Individuelle Arbeitszeiten -->
                    <div class="form-field-group">
                        <label for="individuelle_arbeitszeiten_aktiv-mobile" class="checkbox-label">
                            <input name="simpbook_individuelle_arbeitszeiten_aktiv" type="checkbox"
                                   id="individuelle_arbeitszeiten_aktiv-mobile" value="1"
                                   <?php checked($simpbook_individuelle_arbeitszeiten_aktiv, 1); ?>>
                            <span><?php esc_html_e('Individuelle Arbeitszeiten aktivieren', 'simple-appointment-booking'); ?></span>
                        </label>
                        <p class="form-field-description"><?php esc_html_e('Wenn aktiviert, verwendet dieser Mitarbeiter individuelle Arbeitszeiten.', 'simple-appointment-booking'); ?></p>

                        <div id="arbeitszeiten-container-mobile" style="margin-top: 15px; <?php echo $simpbook_individuelle_arbeitszeiten_aktiv ? '' : 'display:none;'; ?>">
                            <div class="mobile-arbeitszeiten-liste">
                                <?php foreach ($simpbook_wochentage as $simpbook_tag_key => $simpbook_tag_name) : ?>
                                    <div class="arbeitszeit-card">
                                        <div class="arbeitszeit-card-header">
                                            <label class="checkbox-label">
                                                <input name="arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv_mobile" type="checkbox"
                                                       id="arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv-mobile" value="1"
                                                       <?php checked($simpbook_arbeitszeiten[$simpbook_tag_key]['aktiv'] ?? '0', '1'); ?>>
                                                <span><?php echo esc_html($simpbook_tag_name); ?></span>
                                            </label>
                                        </div>
                                        <div class="arbeitszeit-card-body">
                                            <div class="time-input-group-mobile">
                                                <label class="time-label"><?php esc_html_e('Von:', 'simple-appointment-booking'); ?></label>
                                                <input name="arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_beginn_mobile" type="time"
                                                       value="<?php echo esc_attr($simpbook_arbeitszeiten[$simpbook_tag_key]['beginn'] ?? $simpbook_standard_beginn); ?>" class="time-input">
                                            </div>
                                            <div class="time-input-group-mobile">
                                                <label class="time-label"><?php esc_html_e('Bis:', 'simple-appointment-booking'); ?></label>
                                                <input name="arbeitszeit_<?php echo esc_attr($simpbook_tag_key); ?>_ende_mobile" type="time"
                                                       value="<?php echo esc_attr($simpbook_arbeitszeiten[$simpbook_tag_key]['ende'] ?? $simpbook_standard_ende); ?>" class="time-input">
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Sortierung -->
                    <div class="form-field-group">
                        <label for="sortierung-mobile" class="form-field-label"><?php esc_html_e('Sortierung', 'simple-appointment-booking'); ?></label>
                        <input name="simpbook_sortierung" type="number" id="sortierung-mobile"
                               value="<?php echo esc_attr($simpbook_sortierung_value); ?>"
                               min="0" step="1" class="form-field-input">
                        <p class="form-field-description"><?php esc_html_e('Niedrigere Zahlen werden zuerst angezeigt.', 'simple-appointment-booking'); ?></p>
                    </div>

                    <!-- Status -->
                    <div class="form-field-group">
                        <label for="aktiv-mobile" class="checkbox-label">
                            <input name="simpbook_aktiv" type="checkbox" id="aktiv-mobile" value="1" <?php checked($simpbook_aktiv_checked, 1); ?>>
                            <span><?php esc_html_e('Aktiv (wird im Frontend angezeigt)', 'simple-appointment-booking'); ?></span>
                        </label>
                    </div>
                    
                    <?php if (!empty($simpbook_app_columns_exist)) : ?>
                    <!-- App-Zugang -->
                    <div class="form-field-group">
                        <label for="app_zugang_aktiv-mobile" class="checkbox-label">
                            <input name="simpbook_app_zugang_aktiv" type="checkbox" id="app_zugang_aktiv-mobile" value="1" <?php checked($simpbook_app_zugang_aktiv, 1); ?>>
                            <span><strong><?php esc_html_e('App-Zugang aktivieren', 'simple-appointment-booking'); ?></strong></span>
                        </label>
                        <p class="form-field-description"><?php esc_html_e('Ermöglicht die Nutzung der Buchungs-App auf dem Smartphone.', 'simple-appointment-booking'); ?></p>
                        
                        <?php if ($simpbook_mitarbeiter_id > 0 && $simpbook_wp_user) : ?>
                            <div class="simpbook-app-user-info-mobile" style="margin-top: 10px; padding: 12px; background: #e8f5e9; border-radius: 8px;">
                                <p style="margin: 0;">
                                    <span class="dashicons dashicons-yes-alt" style="color: #46b450;"></span>
                                    <?php echo esc_html($simpbook_wp_user->user_email); ?>
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <p class="submit">
            <?php if ($simpbook_mitarbeiter_id > 0) : ?>
                <button type="button" id="mitarbeiter-delete" class="button button-small button-link-delete" style="margin-right: 10px;">
                    <span class="dashicons dashicons-trash"></span> <?php esc_html_e('Löschen', 'simple-appointment-booking'); ?>
                </button>
            <?php endif; ?>
            <input type="submit" name="simpbook_mitarbeiter_speichern" class="button button-primary" value="<?php esc_attr_e('Speichern', 'simple-appointment-booking'); ?>">
        </p>
    </form>
</div>





