<?php
// admin/kalender.php
// Direkten Zugriff verhindern
if (!defined('ABSPATH')) {
    exit;
}

// Testphase-Hinweis anzeigen
simpbook_display_trial_notice_on_admin_pages();

// Nachrichten anzeigen (wie in reservierungen-liste.php)
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for display message only
if (isset($_GET['simpbook_nachricht'])) {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for display message only, sanitized
    $simpbook_nachricht_key = sanitize_text_field(wp_unslash($_GET['simpbook_nachricht']));
    $simpbook_messages = [
        'geloescht' => esc_html__('Reservierung erfolgreich gelöscht.', 'simple-appointment-booking'),
        'aktualisiert' => esc_html__('Reservierung erfolgreich aktualisiert.', 'simple-appointment-booking'),
        'bestaetigt' => esc_html__('Buchung wurde bestätigt.', 'simple-appointment-booking'),
        'abgelehnt' => esc_html__('Buchung wurde abgelehnt.', 'simple-appointment-booking'),
        'storniert' => esc_html__('Buchung wurde storniert.', 'simple-appointment-booking'),
    ];
    if (isset($simpbook_messages[$simpbook_nachricht_key])) {
        echo '<div class="notice notice-success is-dismissible"><p>' . esc_html($simpbook_messages[$simpbook_nachricht_key]) . '</p></div>';
    }
}

// Aktuelle Filter aus GET-Parameters
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Filter parameters for display only
$simpbook_filter_mitarbeiter = isset($_GET['simpbook_filter_mitarbeiter']) ? intval($_GET['simpbook_filter_mitarbeiter']) : 0;
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Filter parameters for display only
$simpbook_filter_dienstleistung = isset($_GET['simpbook_filter_dienstleistung']) ? intval($_GET['simpbook_filter_dienstleistung']) : 0;

// Wenn Mitarbeiter eingeloggt ist und kein Filter explizit gesetzt wurde, Filter auf den Mitarbeiter setzen
$simpbook_current_mitarbeiter = simpbook_get_current_mitarbeiter();
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Check for display filter only
if ($simpbook_current_mitarbeiter && $simpbook_filter_mitarbeiter === 0 && !isset($_GET['simpbook_filter_mitarbeiter'])) {
    $simpbook_filter_mitarbeiter = $simpbook_current_mitarbeiter->id;
}

// Alle Mitarbeiter und Dienstleistungen für Filter laden
$simpbook_alle_mitarbeiter = simpbook_get_all_mitarbeiter(false, false);
$simpbook_alle_dienstleistungen = simpbook_get_all_dienstleistungen(false);
?>

<div class="wrap simpbook-admin-wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Kalender', 'simple-appointment-booking'); ?></h1>
    <a href="<?php echo esc_url(simpbook_is_pwa_mode() ? simpbook_pwa_url('simpbook-reservierungen') : admin_url('admin.php?page=simpbook-reservierungen')); ?>" class="page-title-action"><?php esc_html_e('Zurück zur Liste', 'simple-appointment-booking'); ?></a>
    <hr class="wp-header-end">

    <div class="simpbook-calendar-filters">
        <button class="filter-toggle-button" id="simpbook-calendar-filter-toggle" aria-expanded="false">
            <span class="dashicons dashicons-filter"></span>
            <span class="filter-toggle-text"><?php esc_html_e('Filter', 'simple-appointment-booking'); ?></span>
            <span class="dashicons dashicons-arrow-down-alt2 filter-toggle-icon"></span>
        </button>
        <div class="filter-options" id="simpbook-calendar-filter-panel">
        <label for="simpbook_filter_mitarbeiter"><?php esc_html_e('Mitarbeiter:', 'simple-appointment-booking'); ?></label>
        <select id="simpbook_filter_mitarbeiter" name="simpbook_filter_mitarbeiter">
            <option value="0"><?php esc_html_e('Alle Mitarbeiter', 'simple-appointment-booking'); ?></option>
            <?php foreach ($simpbook_alle_mitarbeiter as $simpbook_mitarbeiter) : ?>
                <option value="<?php echo esc_attr($simpbook_mitarbeiter->id); ?>" <?php selected($simpbook_filter_mitarbeiter, $simpbook_mitarbeiter->id); ?>>
                    <?php echo esc_html($simpbook_mitarbeiter->name); ?>
                </option>
            <?php endforeach; ?>
        </select>

        <label for="simpbook_filter_dienstleistung"><?php esc_html_e('Dienstleistung:', 'simple-appointment-booking'); ?></label>
        <select id="simpbook_filter_dienstleistung" name="simpbook_filter_dienstleistung">
            <option value="0"><?php esc_html_e('Alle Dienstleistungen', 'simple-appointment-booking'); ?></option>
            <?php foreach ($simpbook_alle_dienstleistungen as $simpbook_dienstleistung) : ?>
                <option value="<?php echo esc_attr($simpbook_dienstleistung->id); ?>" <?php selected($simpbook_filter_dienstleistung, $simpbook_dienstleistung->id); ?>>
                    <?php echo esc_html(simpbook_format_dienstleistung_with_kategorie($simpbook_dienstleistung)); ?>
                </option>
            <?php endforeach; ?>
        </select>

        <button type="button" id="apply-filters" class="button button-primary"><?php esc_html_e('Filter anwenden', 'simple-appointment-booking'); ?></button>
        <a href="<?php echo esc_url(simpbook_is_pwa_mode() ? simpbook_pwa_url('simpbook-kalender') : admin_url('admin.php?page=simpbook-kalender')); ?>" class="button"><?php esc_html_e('Filter zurücksetzen', 'simple-appointment-booking'); ?></a>
        </div>
    </div>

    <div class="simpbook-calendar-container">
        <div id="calendar"></div>
    </div>

    <!-- Kalender-Abonnement Sektion -->
    <div class="simpbook-calendar-subscribe-section">
        <input type="checkbox" id="simpbook-calendar-subscribe-toggle" class="simpbook-toggle-checkbox" style="display: none;">
        <label for="simpbook-calendar-subscribe-toggle" class="simpbook-toggle-label" style="cursor: pointer; display: flex; align-items: center; justify-content: space-between;">
            <h2 style="margin: 0;"><?php esc_html_e('Kalender abonnieren', 'simple-appointment-booking'); ?></h2>
            <span class="dashicons dashicons-arrow-down-alt2" style="color: white; font-size: 30px; width: 30px; height: 30px; transition: transform 0.3s ease;"></span>
        </label>

        <div class="simpbook-calendar-subscribe-content">
            <div class="simpbook-calendar-subscribe-info">
                <p>
                    <?php esc_html_e('Hier kannst du deine Buchungen mit einem Kalenderprogramm deiner Wahl verknüpfen. Damit können automatisch all deine Termine in deinem Kalender eingetragen werden.', 'simple-appointment-booking'); ?>
                </p>
                <p style="color: #d63638; font-weight: 600;">
                    <?php esc_html_e('Halte Kalender-Links unbedingt geheim. Sie enthalten ein Token, mit dem ohne Passwort auf die Daten deiner Buchungen zugegriffen werden kann. Du kannst dein aktuelles Token jederzeit löschen, womit früher erstellte Kalender-Links ungültig werden.', 'simple-appointment-booking'); ?>
                </p>
                <p style="font-size: 13px; color: #666;">
                    <?php esc_html_e('Dein Kalenderprogramm muss diesen Kalender regelmäßig synchronisieren. Nur dann tauchen neue Termine auf und abgesagte Termine nicht mehr. Wenn du stattdessen deinen aktuellen Kalender herunterlädst, enthält dieser nur deine jetzigen Termine und wird nicht automatisch aktualisiert.', 'simple-appointment-booking'); ?>
                </p>
            </div>

            <form id="simpbook-calendar-subscribe-form">
                <?php wp_nonce_field('simpbook_calendar_token', 'simpbook_calendar_token_nonce'); ?>

                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600;">
                        <input type="checkbox" id="simpbook_include_past" name="simpbook_include_past" value="1" style="margin-right: 8px;">
                        <?php esc_html_e('Sollen vergangene Termine der letzten zwei Wochen enthalten sein?', 'simple-appointment-booking'); ?>
                    </label>
                </div>

                <div style="margin-bottom: 20px;">
                    <label style="display: block; margin-bottom: 8px; font-weight: 600;">
                        <?php esc_html_e('Welches Kalenderprogramm nutzt du?', 'simple-appointment-booking'); ?>
                    </label>
                    <select id="simpbook_calendar_app" name="simpbook_calendar_app" style="width: 100%; max-width: 400px; padding: 8px;">
                        <option value="google"><?php esc_html_e('Google', 'simple-appointment-booking'); ?></option>
                        <option value="outlook"><?php esc_html_e('Outlook', 'simple-appointment-booking'); ?></option>
                        <option value="thunderbird"><?php esc_html_e('Thunderbird', 'simple-appointment-booking'); ?></option>
                        <option value="apple"><?php esc_html_e('Apple / Etar Kalender', 'simple-appointment-booking'); ?></option>
                    </select>
                </div>

                <button type="submit" class="button button-primary" id="generate-calendar-url">
                    <?php esc_html_e('Kalender-URL generieren', 'simple-appointment-booking'); ?>
                </button>
                <button type="button" class="button" id="delete-calendar-token" style="display: none; margin-left: 10px;">
                    <?php esc_html_e('Token löschen', 'simple-appointment-booking'); ?>
                </button>
            </form>

            <div id="calendar-url-result" style="display: none;">
                <h3><?php esc_html_e('Deine Kalender-URL:', 'simple-appointment-booking'); ?></h3>
                <div id="calendar-url-display"></div>
                <p>
                    <?php esc_html_e('Kopiere diese URL und füge sie in dein Kalenderprogramm ein:', 'simple-appointment-booking'); ?>
                </p>
                <div id="calendar-app-instructions"></div>
            </div>
        </div>
    </div>
</div>

<!-- Modal für Reservierungsdetails -->
<div id="reservierung-details-modal" class="reservierung-modal" style="display: none;">
    <div class="reservierung-modal-overlay"></div>
    <div class="reservierung-modal-content">
        <div class="reservierung-modal-header">
            <h2><?php esc_html_e('Buchungsdetails', 'simple-appointment-booking'); ?></h2>
            <button class="reservierung-modal-close" aria-label="<?php esc_attr_e('Schließen', 'simple-appointment-booking'); ?>">
                <span class="dashicons dashicons-no-alt"></span>
            </button>
        </div>
        <div class="reservierung-modal-body">
            <div id="reservierung-details-content"></div>
        </div>
    </div>
</div>

<div id="nachrichten-modal" class="modal" style="display:none;">
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2><?php esc_html_e('Nachricht an', 'simple-appointment-booking'); ?> <span id="empfaenger-name"></span></h2>
        <form id="nachrichten-form">
            <input type="hidden" id="empfaenger-email" name="simpbook_email">
            <?php wp_nonce_field('simpbook_sende_nachricht_action', 'nachricht_nonce'); ?>
            <div class="form-field">
                <label for="nachricht-betreff"><?php esc_html_e('Betreff:', 'simple-appointment-booking'); ?></label>
                <input type="text" id="nachricht-betreff" name="betreff" required>
            </div>
            <div class="form-field">
                <label for="nachricht-text"><?php esc_html_e('Nachricht:', 'simple-appointment-booking'); ?></label>
                <textarea id="nachricht-text" name="nachricht" rows="10" required></textarea>
            </div>
            <button type="submit" class="button button-primary"><?php esc_html_e('Nachricht senden', 'simple-appointment-booking'); ?></button>
        </form>
    </div>
</div>








