<?php
// admin/einstellungen.php
// Direkten Zugriff verhindern
if (!defined('ABSPATH')) {
    exit;
}

// Testphase-Hinweis anzeigen
simpbook_display_trial_notice_on_admin_pages();

// Formular-Verarbeitung erfolgt jetzt im admin_init Hook (simpbook_einstellungen_formular_verarbeiten)
// in simple-appointment-booking.php, damit Redirects funktionieren, bevor Header gesendet werden

/**
 * Gibt die übersetzten Wochentage zurück.
 */
function simpbook_get_wochentage() {
    return [
        'montag' => esc_html__('Montag', 'simple-appointment-booking'),
        'dienstag' => esc_html__('Dienstag', 'simple-appointment-booking'),
        'mittwoch' => esc_html__('Mittwoch', 'simple-appointment-booking'),
        'donnerstag' => esc_html__('Donnerstag', 'simple-appointment-booking'),
        'freitag' => esc_html__('Freitag', 'simple-appointment-booking'),
        'samstag' => esc_html__('Samstag', 'simple-appointment-booking'),
        'sonntag' => esc_html__('Sonntag', 'simple-appointment-booking')
    ];
}

// Wochentage für die Anzeige (übersetzt)
$simpbook_wochentage = simpbook_get_wochentage();

// Formular-Verarbeitung erfolgt jetzt im admin_init Hook (simpbook_einstellungen_formular_verarbeiten)
// in simple-appointment-booking.php, damit Redirects funktionieren, bevor Header gesendet werden

// Aktuelle Einstellungen laden
$simpbook_benachrichtigungen = get_option('simpbook_email_benachrichtigungen', '1');
$simpbook_benachrichtigungs_email = get_option('simpbook_benachrichtigungs_email', get_option('admin_email'));
$simpbook_intervall = get_option('simpbook_intervall', 30);
$simpbook_stornierung_aktiviert = get_option('simpbook_stornierung_aktiviert', '1');
$simpbook_stornierung_mindeststunden = get_option('simpbook_stornierung_mindeststunden', 24);
$simpbook_stornierung_telefonnummer = get_option('simpbook_stornierung_telefonnummer', '');

$simpbook_spezielle_tage_konfiguration = get_option('simpbook_spezielle_tage_konfiguration', []);

$simpbook_button_color = get_option('simpbook_button_color', '#2271b1');
$simpbook_container_background = get_option('simpbook_container_background', '#8bbce4');
$simpbook_text_color = get_option('simpbook_text_color', '#000000');
$simpbook_tile_background = get_option('simpbook_tile_background', '#ffffff');
$simpbook_border_radius = get_option('simpbook_border_radius', '8');
$simpbook_tile_border_radius = get_option('simpbook_tile_border_radius', '12');
// Formular-Überschriften laden (mit sprachspezifischen Standardwerten)
$simpbook_current_language = simpbook_get_current_language();
$simpbook_form_header_date = simpbook_get_form_header('date', $simpbook_current_language);
$simpbook_form_header_service = simpbook_get_form_header('service', $simpbook_current_language);
$simpbook_form_header_employee = simpbook_get_form_header('employee', $simpbook_current_language);
$simpbook_form_header_time = simpbook_get_form_header('time', $simpbook_current_language);
$simpbook_form_header_contact = simpbook_get_form_header('contact', $simpbook_current_language);
// Wochentag-Zeiten laden oder Standardwerte setzen
$simpbook_wochentag_zeiten = get_option('simpbook_wochentag_zeiten', []);
$simpbook_standard_beginn = '11:00';
$simpbook_standard_ende = '22:00';
foreach ($simpbook_wochentage as $simpbook_tag_key => $simpbook_tag_name) {
    if (!isset($simpbook_wochentag_zeiten[$simpbook_tag_key])) {
        $simpbook_wochentag_zeiten[$simpbook_tag_key] = [
            'aktiv' => '1',
            'beginn' => $simpbook_standard_beginn,
            'ende' => $simpbook_standard_ende
        ];
    }
}

// Aktive Tab aus URL oder Standard
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for tab selection only, validated against whitelist
$simpbook_active_tab = isset($_GET['simpbook_tab']) ? sanitize_text_field(wp_unslash($_GET['simpbook_tab'])) : 'general';
$simpbook_valid_tabs = array('general', 'opening-hours', 'cancellations', 'emails', 'design', 'language', 'app');
if (!in_array($simpbook_active_tab, $simpbook_valid_tabs, true)) {
    $simpbook_active_tab = 'general';
}

// Sicherstellen, dass der erste Tab standardmäßig gecheckt ist
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter check only, no data processing
if (!isset($_GET['simpbook_tab'])) {
    $simpbook_active_tab = 'general';
}

// Textdomain sicherstellen, dass sie korrekt geladen ist (besonders nach Sprachwechsel)
// Dies ist wichtig, damit nach einem Redirect die neue Sprache korrekt angezeigt wird
simpbook_DB_Reservierungen::reload_plugin_textdomain();

// Aktuelle Sprache laden - NACH dem Speichern, damit die neue Sprache verwendet wird
$simpbook_current_language = simpbook_get_current_language();
// Verwende leere Strings als Fallback, da simpbook_get_email_template() automatisch sprachspezifische Standardwerte verwendet
$simpbook_email_bestaetigungs_betreff = simpbook_get_email_template('simpbook_email_bestaetigungs_betreff', '', $simpbook_current_language);
$simpbook_email_bestaetigungs_nachricht = simpbook_get_email_template('simpbook_email_bestaetigungs_nachricht', '', $simpbook_current_language);

// Erfolgsmeldung anzeigen, wenn Einstellungen gespeichert wurden (auch nach Redirect)
// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for display message only
if (isset($_GET['simpbook_settings_updated']) && $_GET['simpbook_settings_updated'] === 'true') {
    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Einstellungen gespeichert.', 'simple-appointment-booking') . '</p></div>';
}
?>
<div class="wrap simpbook-admin-wrap">
    <h1 class="wp-heading-inline"><?php esc_html_e('Buchungs-Einstellungen', 'simple-appointment-booking'); ?></h1>

    <hr class="wp-header-end">

    <form method="post" action="<?php echo esc_attr(simpbook_get_form_action()); ?>">
        <?php wp_nonce_field('simpbook_einstellungen'); ?>
        <input type="hidden" name="simpbook_active_tab" id="simpbook-active-tab" value="<?php echo esc_attr($simpbook_active_tab); ?>" />

        <div class="simpbook-tabs">
            <input type="radio" id="tab-general" name="simpbook-tab" <?php checked($simpbook_active_tab, 'general'); ?>>
            <label for="tab-general"><?php esc_html_e('Allgemein', 'simple-appointment-booking'); ?></label>

            <input type="radio" id="tab-opening-hours" name="simpbook-tab" <?php checked($simpbook_active_tab, 'opening-hours'); ?>>
            <label for="tab-opening-hours"><?php esc_html_e('Öffnungszeiten', 'simple-appointment-booking'); ?></label>

            <input type="radio" id="tab-cancellations" name="simpbook-tab" <?php checked($simpbook_active_tab, 'cancellations'); ?>>
            <label for="tab-cancellations"><?php esc_html_e('Stornierungen', 'simple-appointment-booking'); ?></label>

            <input type="radio" id="tab-emails" name="simpbook-tab" <?php checked($simpbook_active_tab, 'emails'); ?>>
            <label for="tab-emails"><?php esc_html_e('E-Mails', 'simple-appointment-booking'); ?></label>

            <input type="radio" id="tab-design" name="simpbook-tab" <?php checked($simpbook_active_tab, 'design'); ?>>
            <label for="tab-design"><?php esc_html_e('Design', 'simple-appointment-booking'); ?></label>

            <input type="radio" id="tab-language" name="simpbook-tab" <?php checked($simpbook_active_tab, 'language'); ?>>
            <label for="tab-language"><?php esc_html_e('Sprache', 'simple-appointment-booking'); ?></label>

            <input type="radio" id="tab-app" name="simpbook-tab" <?php checked($simpbook_active_tab, 'app'); ?>>
            <label for="tab-app"><span class="dashicons dashicons-smartphone" style="margin-right: 4px;"></span><?php esc_html_e('App', 'simple-appointment-booking'); ?></label>

            <div class="simpbook-tab-content" id="content-general">
                <h2><?php esc_html_e('Allgemeine Einstellungen', 'simple-appointment-booking'); ?></h2>
                <div class="simpbook-settings-grid">
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Shortcode für das Formular im Frontend', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <code style="font-size: 16px; padding: 10px; background: #f5f5f5; border-radius: 4px; display: inline-block;">[simpbook_bookingform]</code>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Firmenname', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_firmen_name" type="text" id="simpbook_firmen_name"
                                   value="<?php echo esc_attr(get_option('simpbook_firmen_name', get_bloginfo('name'))); ?>"
                                   class="regular-text" style="width: 100%; max-width: 500px;">
                            <p class="description"><?php esc_html_e('Dieser Name wird in allen E-Mails verwendet.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Einrichtungsassistent', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <p class="description"><?php esc_html_e('Starten Sie den Einrichtungsassistenten erneut, um die Grundkonfiguration Ihres Buchungssystems durchzuführen.', 'simple-appointment-booking'); ?></p>
                            <a href="<?php echo esc_url(admin_url('admin.php?page=simpbook-reservierungen-einstellungen&simpbook_wizard_reset=1&simpbook_nonce=' . wp_create_nonce('simpbook_wizard_reset'))); ?>" class="button button-secondary" style="margin-top: 10px;">
                                <span class="dashicons dashicons-update"></span>
                                <?php esc_html_e('Einrichtungsassistent zurücksetzen', 'simple-appointment-booking'); ?>
                            </a>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Plugin-Updates', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <p><strong><?php esc_html_e('Aktuelle Version:', 'simple-appointment-booking'); ?></strong> <?php echo esc_html(defined('SIMPBOOK_VERSION') ? SIMPBOOK_VERSION : '1.1.5'); ?></p>
                            <?php
                            $update_info = SIMPBOOK_Plugin_Updater::get_cached_update_info();
                            
                            if ($update_info && isset($update_info->update_available)):
                                if ($update_info->update_available && isset($update_info->latest_version)):
                                    if (isset($update_info->license_valid) && $update_info->license_valid && 
                                        isset($update_info->support_active) && $update_info->support_active): ?>
                                        <p style="color: #d63638; font-weight: 500;">
                                            <?php 
                                            // translators: %s: Version number
                                            printf(esc_html__('Update verfügbar: Version %s', 'simple-appointment-booking'), esc_html($update_info->latest_version)); 
                                            ?>
                                        </p>
                                        <p class="description"><?php esc_html_e('Gehen Sie zu "Plugins", um das Update zu installieren.', 'simple-appointment-booking'); ?></p>
                                    <?php elseif (!isset($update_info->license_valid) || !$update_info->license_valid): ?>
                                        <p style="color: #d63638;">
                                            <?php esc_html_e('Ihre Lizenz ist ungültig. Bitte überprüfen Sie Ihre Lizenzeinstellungen.', 'simple-appointment-booking'); ?>
                                        </p>
                                    <?php else: ?>
                                        <p style="color: #d63638;">
                                            <?php esc_html_e('Ihr Support-Zeitraum ist abgelaufen. Bitte erneuern Sie Ihre Lizenz für Updates.', 'simple-appointment-booking'); ?>
                                        </p>
                                    <?php endif;
                                else: ?>
                                    <p style="color: #00a32a;">✓ <?php esc_html_e('Sie verwenden die neueste Version', 'simple-appointment-booking'); ?></p>
                                <?php endif;
                            else: ?>
                                <p class="description"><?php esc_html_e('Update-Status unbekannt. Klicken Sie auf "Jetzt prüfen", um nach Updates zu suchen.', 'simple-appointment-booking'); ?></p>
                            <?php endif; ?>
                            <a href="<?php echo esc_url(wp_nonce_url(admin_url('admin.php?page=simpbook-reservierungen-einstellungen&simpbook_check_updates=1'), 'simpbook_check_updates', 'simpbook_nonce')); ?>" 
                               class="button button-secondary" style="margin-top: 10px;">
                                <span class="dashicons dashicons-update"></span>
                                <?php esc_html_e('Jetzt auf Updates prüfen', 'simple-appointment-booking'); ?>
                            </a>
                        </div>
                    </div>
                </div>

                <h2 style="margin-top: 30px;"><?php esc_html_e('Buchungseinstellungen', 'simple-appointment-booking'); ?></h2>
                <div class="simpbook-settings-grid">
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Mindestvorlaufzeit (Stunden)', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_mindestvorlauf_stunden" type="number" id="simpbook_mindestvorlauf_stunden"
                                   value="<?php echo esc_attr(get_option('simpbook_mindestvorlauf_stunden', 2)); ?>"
                                   min="0" max="168" step="1" class="small-text">
                            <p class="description"><?php esc_html_e('Wie viele Stunden vor dem Termin muss mindestens gebucht werden? (0 = keine Einschränkung)', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Maximale Buchungsvorlauf (Tage)', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_maximale_vorlauf_tage" type="number" id="simpbook_maximale_vorlauf_tage"
                                   value="<?php echo esc_attr(get_option('simpbook_maximale_vorlauf_tage', 30)); ?>"
                                   min="0" max="365" step="1" class="small-text">
                            <p class="description"><?php esc_html_e('Wie viele Tage im Voraus können Termine gebucht werden? (0 = keine Einschränkung)', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Buchungen automatisch annehmen', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <label for="simpbook_auto_bestaetigung">
                                <input name="simpbook_auto_bestaetigung" type="checkbox" id="simpbook_auto_bestaetigung" value="1" <?php checked(get_option('simpbook_auto_bestaetigung', '0'), '1'); ?>>
                                <?php esc_html_e('Neue Buchungen automatisch bestätigen (Kunde erhält sofort Bestätigungs-E-Mail)', 'simple-appointment-booking'); ?>
                            </label>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Dienstleistungsdauer anzeigen', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <label for="simpbook_dauer_anzeigen">
                                <input name="simpbook_dauer_anzeigen" type="checkbox" id="simpbook_dauer_anzeigen" value="1" <?php checked(get_option('simpbook_dauer_anzeigen', '1'), '1'); ?>>
                                <?php esc_html_e('Dauer der Dienstleistungen im Frontend-Formular anzeigen', 'simple-appointment-booking'); ?>
                            </label>
                            <p class="description"><?php esc_html_e('Wenn aktiviert, wird die Dauer jeder Dienstleistung im Buchungsformular angezeigt.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>

                <h2 style="margin-top: 30px;"><?php esc_html_e('E-Mail-Benachrichtigungen', 'simple-appointment-booking'); ?></h2>
                <div class="simpbook-settings-grid">
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('E-Mail-Benachrichtigungen aktivieren', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <label for="simpbook_email_benachrichtigungen">
                                <input name="simpbook_email_benachrichtigungen" type="checkbox" id="simpbook_email_benachrichtigungen" value="1" <?php checked($simpbook_benachrichtigungen, '1'); ?>>
                                <?php esc_html_e('Bei neuen Reservierungen eine E-Mail senden', 'simple-appointment-booking'); ?>
                            </label>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('E-Mail-Adresse for Benachrichtigungen', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_benachrichtigungs_email" type="email" id="simpbook_benachrichtigungs_email" value="<?php echo esc_attr($simpbook_benachrichtigungs_email); ?>" class="regular-text" style="width: 100%; max-width: 500px;">
                            <p class="description"><?php
                            // translators: %s: Admin email address
                            printf(esc_html__('Leer lassen, um die Admin-E-Mail zu verwenden (%s).', 'simple-appointment-booking'), esc_html(get_option('admin_email'))); ?></p>
                        </div>
                    </div>
                </div>

                <h2 style="margin-top: 30px;"><?php esc_html_e('Termin-Erinnerungen', 'simple-appointment-booking'); ?></h2>
                <div class="simpbook-settings-grid">
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Termin-Erinnerungen aktivieren', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <label for="simpbook_erinnerung_aktiv">
                                <input name="simpbook_erinnerung_aktiv" type="checkbox" id="simpbook_erinnerung_aktiv" value="1" <?php checked(get_option('simpbook_erinnerung_aktiv', 1), 1); ?>>
                                <?php esc_html_e('Kunden automatisch per E-Mail an ihre Termine erinnern', 'simple-appointment-booking'); ?>
                            </label>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Erinnerung X Stunden vor Termin', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_erinnerung_vor_stunden" type="number" id="simpbook_erinnerung_vor_stunden"
                                   value="<?php echo esc_attr(get_option('simpbook_erinnerung_vor_stunden', 24)); ?>"
                                   min="1" max="168" step="1" class="small-text">
                            <p class="description"><?php esc_html_e('Wie viele Stunden vor dem Termin soll die Erinnerungs-E-Mail gesendet werden? (1-168 Stunden)', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="simpbook-tab-content" id="content-opening-hours">
                <h2><?php esc_html_e('Öffnungszeiten', 'simple-appointment-booking'); ?></h2>
                <p class="description"><?php esc_html_e('Stellen Sie hier die allgemeinen Optionen und die regulären Reservierungszeiten für jeden Wochentag individuell ein.', 'simple-appointment-booking'); ?></p>

                <div class="simpbook-settings-grid">
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Zeitintervall (Minuten)', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <select name="simpbook_intervall" id="simpbook_intervall" style="width: 100%; max-width: 300px;">
                                <option value="5" <?php selected($simpbook_intervall, 5); ?>>5 <?php esc_html_e('Minuten', 'simple-appointment-booking'); ?></option>
                                <option value="10" <?php selected($simpbook_intervall, 10); ?>>10 <?php esc_html_e('Minuten', 'simple-appointment-booking'); ?></option>
                                <option value="15" <?php selected($simpbook_intervall, 15); ?>>15 <?php esc_html_e('Minuten', 'simple-appointment-booking'); ?></option>
                                <option value="30" <?php selected($simpbook_intervall, 30); ?>>30 <?php esc_html_e('Minuten', 'simple-appointment-booking'); ?></option>
                                <option value="60" <?php selected($simpbook_intervall, 60); ?>>60 <?php esc_html_e('Minuten', 'simple-appointment-booking'); ?></option>
                            </select>
                            <p class="description"><?php esc_html_e('In welchen Intervallen können Termine gebucht werden (z.B. alle 30 Minuten).', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>

                <h2 style="margin-top: 30px;"><?php esc_html_e('Reguläre wöchentliche Öffnungszeiten', 'simple-appointment-booking'); ?></h2>
                <div class="simpbook-settings-grid">
                <?php
                foreach ($simpbook_wochentage as $simpbook_tag_key => $simpbook_tag_name): ?>
                    <div class="simpbook-setting-card">
                        <h3><?php echo esc_html($simpbook_tag_name); ?></h3>
                        <div>
                            <label for="simpbook_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv">
                                <input name="simpbook_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv" type="checkbox" id="simpbook_<?php echo esc_attr($simpbook_tag_key); ?>_aktiv" value="1" <?php checked($simpbook_wochentag_zeiten[$simpbook_tag_key]['aktiv'] ?? '0', '1'); ?>>
                                <?php esc_html_e('Reservierungen an diesem Tag erlauben', 'simple-appointment-booking'); ?>
                            </label>
                            <div style="margin-top: 15px; <?php if(!($simpbook_wochentag_zeiten[$simpbook_tag_key]['aktiv'] ?? false)) echo 'display:none;'; ?>" class="wochentag-zeiten-inputs">
                                <div class="time-input-row">
                                    <span class="time-input-group">
                                        <span class="time-label"><?php esc_html_e('Von:', 'simple-appointment-booking'); ?></span>
                                        <input name="simpbook_<?php echo esc_attr($simpbook_tag_key); ?>_beginn" type="time" value="<?php echo esc_attr($simpbook_wochentag_zeiten[$simpbook_tag_key]['beginn'] ?? '11:00'); ?>" class="time-input" autocomplete="off">
                                    </span>
                                    <span class="time-input-group">
                                        <span class="time-label"><?php esc_html_e('Bis:', 'simple-appointment-booking'); ?></span>
                                        <input name="simpbook_<?php echo esc_attr($simpbook_tag_key); ?>_ende" type="time" value="<?php echo esc_attr($simpbook_wochentag_zeiten[$simpbook_tag_key]['ende'] ?? '22:00'); ?>" class="time-input" autocomplete="off">
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
                </div>

                <h2 style="margin-top: 30px;"><?php esc_html_e('Feiertage & Spezielle Öffnungszeiten', 'simple-appointment-booking'); ?></h2>
                <p class="description"><?php esc_html_e('Definieren Sie hier Tage, an denen Ihr Restaurant komplett geschlossen ist oder abweichende Öffnungszeiten von den regulären Wochentagseinstellungen hat.', 'simple-appointment-booking'); ?></p>
                <div class="simpbook-settings-grid">
                    <div class="simpbook-setting-card simpbook-setting-full-width">
                        <h3><?php esc_html_e('Datum hinzufügen', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <div style="margin-bottom: 15px; display: flex; gap: 10px; flex-wrap: wrap; align-items: center;">
                                <input type="text" id="datepicker_speziell" class="regular-text"
                                       placeholder="<?php esc_attr_e('Datum auswählen...', 'simple-appointment-booking'); ?>" autocomplete="off" style="flex: 1; min-width: 200px;">
                                <button type="button" id="add-speziellen-tag-btn" class="button"><?php esc_html_e('Ausgewähltes Datum konfigurieren', 'simple-appointment-booking'); ?></button>
                            </div>
                            <div id="spezielle-tage-liste">
                            <?php
                            if (!empty($simpbook_spezielle_tage_konfiguration)) {
                                // phpcs:disable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Loop variables
                                foreach ($simpbook_spezielle_tage_konfiguration as $datum_str => $einstellungen) {
                                    $status = $einstellungen['status'] ?? 'geschlossen';
                                    $beginn = $einstellungen['beginn'] ?? '';
                                    $ende = $einstellungen['ende'] ?? '';
                                    ?>
                                    <div class="spezieller-tag-eintrag" data-datum="<?php echo esc_attr($datum_str); ?>">
                                        <strong><?php echo esc_html(simpbook_format_date($datum_str)); ?></strong>
                                        <input type="hidden" name="simpbook_spezielle_tage_daten[<?php echo esc_attr($datum_str); ?>][datum_hidden]" value="<?php echo esc_attr($datum_str); ?>">
                                        <select name="simpbook_spezielle_tage_daten[<?php echo esc_attr($datum_str); ?>][status]" class="spezieller-tag-status">
                                            <option value="geschlossen" <?php selected($status, 'geschlossen'); ?>><?php esc_html_e('Ganzen Tag schließen', 'simple-appointment-booking'); ?></option>
                                            <option value="speziell" <?php selected($status, 'speziell'); ?>><?php esc_html_e('Spezielle Öffnungszeiten', 'simple-appointment-booking'); ?></option>
                                        </select>
                                        <span class="spezielle-zeiten-inputs" style="<?php if ($status !== 'speziell') echo 'display:none;'; ?>">
                                            <div class="time-input-row">
                                                <span class="time-input-group">
                                                    <span class="time-label"><?php esc_html_e('Von:', 'simple-appointment-booking'); ?></span>
                                                    <input type="time" name="simpbook_spezielle_tage_daten[<?php echo esc_attr($datum_str); ?>][beginn]" value="<?php echo esc_attr($beginn); ?>" class="spezieller-tag-beginn time-input" autocomplete="off">
                                                </span>
                                                <span class="time-input-group">
                                                    <span class="time-label"><?php esc_html_e('Bis:', 'simple-appointment-booking'); ?></span>
                                                    <input type="time" name="simpbook_spezielle_tage_daten[<?php echo esc_attr($datum_str); ?>][ende]" value="<?php echo esc_attr($ende); ?>" class="spezieller-tag-ende time-input" autocomplete="off">
                                                </span>
                                            </div>
                                        </span>
                                        <button type="button" class="button button-link-delete remove-speziellen-tag-btn"><?php esc_html_e('Entfernen', 'simple-appointment-booking'); ?></button>
                                    </div>
                                    <?php
                                }
                                // phpcs:enable WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
                            }
                            ?>
                            </div>
                            <p class="description"><?php esc_html_e('Hinzugefügte Tage überschreiben die regulären wöchentlichen Öffnungszeiten für das jeweilige Datum.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="simpbook-tab-content" id="content-cancellations">
                <h2><?php esc_html_e('Stornierungen', 'simple-appointment-booking'); ?></h2>
                <p class="description"><?php esc_html_e('Konfigurieren Sie die Einstellungen für Stornierungen durch Gäste.', 'simple-appointment-booking'); ?></p>
                <div class="simpbook-settings-grid">
                    <!-- Buchungen stornieren -->
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Buchungen stornieren', 'simple-appointment-booking'); ?></h3>
                        
                        <div>
                            <label for="simpbook_stornierung_aktiviert">
                                <input name="simpbook_stornierung_aktiviert" type="checkbox" id="simpbook_stornierung_aktiviert" value="1" <?php checked($simpbook_stornierung_aktiviert, '1'); ?>>
                                <?php esc_html_e('Stornierung aktivieren', 'simple-appointment-booking'); ?>
                                <p class="description"><?php esc_html_e('Der Gast kann die Buchungen vor einem Termin stornieren', 'simple-appointment-booking'); ?></p>
                            </label>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Mindeststunden vor Termin', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_stornierung_mindeststunden" type="number" id="simpbook_stornierung_mindeststunden" value="<?php echo esc_attr($simpbook_stornierung_mindeststunden); ?>" min="0" step="1" class="small-text">
                            <p class="description"><?php esc_html_e('Gäste können Reservierungen nur stornieren, wenn noch mindestens diese Anzahl Stunden bis zum Termin verbleiben.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Telefonnummer für Stornierungen', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_stornierung_telefonnummer" type="text" id="simpbook_stornierung_telefonnummer" value="<?php echo esc_attr($simpbook_stornierung_telefonnummer); ?>" class="regular-text" style="width: 100%; max-width: 500px;">
                            <p class="description"><?php esc_html_e('Diese Telefonnummer wird angezeigt, wenn eine Stornierung zu spät ist (unter der Mindeststunden-Grenze).', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="simpbook-tab-content" id="content-emails">
                <h2><?php esc_html_e('E-Mail-Vorlagen', 'simple-appointment-booking'); ?></h2>
                <p class="description"><?php esc_html_e('Passen Sie die E-Mail-Vorlagen an, die an Gäste gesendet werden.', 'simple-appointment-booking'); ?></p>

                <div class="simpbook-settings-grid-2col">
                    <!-- Buchungsbestätigung (Automatisch nach Buchung) -->
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Buchungsbestätigung (Automatisch nach Buchung)', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <label for="email_bestaetigungs_betreff" style="display: block; margin-bottom: 8px; font-weight: 600;"><?php esc_html_e('Betreff', 'simple-appointment-booking'); ?></label>
                            <input name="simpbook_email_bestaetigungs_betreff" type="text" id="email_bestaetigungs_betreff"
                                   value="<?php echo esc_attr($simpbook_email_bestaetigungs_betreff); ?>"
                                   class="regular-text" style="width: 100%; max-width: 100%;">
                            <label for="email_bestaetigungs_nachricht" style="display: block; margin: 20px 0 8px 0; font-weight: 600; width: 50%;"><?php esc_html_e('Nachricht', 'simple-appointment-booking'); ?></label>
                            <textarea name="simpbook_email_bestaetigungs_nachricht" id="email_bestaetigungs_nachricht" rows="8" class="large-text" style="width: 100%;"><?php echo esc_textarea($simpbook_email_bestaetigungs_nachricht); ?></textarea>
                            <p class="description"><?php esc_html_e('Verfügbare Platzhalter: {name}, {email}, {phone}, {date}, {time}, {service_name}, {employee_name}, {employee_name_label}, {message}, {company_name}, {cancellation_link}', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <!-- Bestätigt Status -->
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Buchung bestätigt (Manuell durch Admin)', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <?php
                            $simpbook_email_bestaetigt_betreff_val = simpbook_get_email_template('simpbook_email_bestaetigt_betreff', '', $simpbook_current_language);
                            ?>
                            <label for="email_bestaetigt_betreff" style="display: block; margin-bottom: 8px; font-weight: 600;"><?php esc_html_e('Betreff', 'simple-appointment-booking'); ?></label>
                            <input name="simpbook_email_bestaetigt_betreff" type="text" id="email_bestaetigt_betreff"
                                   value="<?php echo esc_attr($simpbook_email_bestaetigt_betreff_val); ?>"
                                   class="regular-text" style="width: 100%; max-width: 100%;">
                            <?php
                            $simpbook_email_bestaetigt_nachricht_val = simpbook_get_email_template('simpbook_email_bestaetigt_nachricht', '', $simpbook_current_language);
                            ?>
                            <label for="email_bestaetigt_nachricht" style="display: block; margin: 20px 0 8px 0; font-weight: 600; width: 50%;"><?php esc_html_e('Nachricht', 'simple-appointment-booking'); ?></label>
                            <textarea name="simpbook_email_bestaetigt_nachricht" id="email_bestaetigt_nachricht" rows="8" class="large-text" style="width: 100%;"><?php echo esc_textarea($simpbook_email_bestaetigt_nachricht_val); ?></textarea>
                            <p class="description"><?php esc_html_e('Verfügbare Platzhalter: {name}, {date}, {time}, {service_name}, {employee_name}, {employee_name_label}, {company_name}, {cancellation_link}', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>

                    <!-- Abgelehnt Status -->
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Buchung abgelehnt (Manuell durch Admin)', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <?php
                            $simpbook_email_abgelehnt_betreff_val = simpbook_get_email_template('simpbook_email_abgelehnt_betreff', '', $simpbook_current_language);
                            ?>
                            <label for="email_abgelehnt_betreff" style="display: block; margin-bottom: 8px; font-weight: 600;"><?php esc_html_e('Betreff', 'simple-appointment-booking'); ?></label>
                            <input name="simpbook_email_abgelehnt_betreff" type="text" id="email_abgelehnt_betreff"
                                   value="<?php echo esc_attr($simpbook_email_abgelehnt_betreff_val); ?>"
                                   class="regular-text" style="width: 100%; max-width: 100%;">
                            <?php
                            $simpbook_email_abgelehnt_nachricht_val = simpbook_get_email_template('simpbook_email_abgelehnt_nachricht', '', $simpbook_current_language);
                            ?>
                            <label for="email_abgelehnt_nachricht" style="display: block; margin: 20px 0 8px 0; font-weight: 600; width: 50%;"><?php esc_html_e('Nachricht', 'simple-appointment-booking'); ?></label>
                            <textarea name="simpbook_email_abgelehnt_nachricht" id="email_abgelehnt_nachricht" rows="8" class="large-text" style="width: 100%;"><?php echo esc_textarea($simpbook_email_abgelehnt_nachricht_val); ?></textarea>
                            <p class="description"><?php esc_html_e('Verfügbare Platzhalter: {name}, {date}, {time}, {service_name}, {employee_name}, {employee_name_label}, {company_name}, {cancellation_link}', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <!-- Erinnerung -->
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Termin-Erinnerung (Automatisch X Stunden vor Termin)', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <?php
                            $simpbook_email_erinnerung_betreff_val = simpbook_get_email_template('simpbook_email_erinnerung_betreff', '', $simpbook_current_language);
                            ?>
                            <label for="email_erinnerung_betreff" style="display: block; margin-bottom: 8px; font-weight: 600;"><?php esc_html_e('Betreff', 'simple-appointment-booking'); ?></label>
                            <input name="simpbook_email_erinnerung_betreff" type="text" id="email_erinnerung_betreff"
                                   value="<?php echo esc_attr($simpbook_email_erinnerung_betreff_val); ?>"
                                   class="regular-text" style="width: 100%; max-width: 100%;">
                            <?php
                            $simpbook_email_erinnerung_nachricht_val = simpbook_get_email_template('simpbook_email_erinnerung_nachricht', '', $simpbook_current_language);
                            ?>
                            <label for="email_erinnerung_nachricht" style="display: block; margin: 20px 0 8px 0; font-weight: 600; width: 50%;"><?php esc_html_e('Nachricht', 'simple-appointment-booking'); ?></label>
                            <textarea name="simpbook_email_erinnerung_nachricht" id="email_erinnerung_nachricht" rows="8" class="large-text" style="width: 100%;"><?php echo esc_textarea($simpbook_email_erinnerung_nachricht_val); ?></textarea>
                            <p class="description"><?php esc_html_e('Verfügbare Platzhalter: {name}, {date}, {time}, {service_name}, {employee_name}, {employee_name_label}, {company_name}, {cancellation_link}', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <!-- Storniert Status -->
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Buchung storniert (Automatisch bei Stornierung)', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <?php
                            $simpbook_email_storniert_betreff_val = simpbook_get_email_template('simpbook_email_storniert_betreff', '', $simpbook_current_language);
                            ?>
                            <label for="email_storniert_betreff" style="display: block; margin-bottom: 8px; font-weight: 600;"><?php esc_html_e('Betreff', 'simple-appointment-booking'); ?></label>
                            <input name="simpbook_email_storniert_betreff" type="text" id="email_storniert_betreff"
                                   value="<?php echo esc_attr($simpbook_email_storniert_betreff_val); ?>"
                                   class="regular-text" style="width: 100%; max-width: 100%;">
                            <?php
                            $simpbook_email_storniert_nachricht_val = simpbook_get_email_template('simpbook_email_storniert_nachricht', '', $simpbook_current_language);
                            ?>
                            <label for="email_storniert_nachricht" style="display: block; margin: 20px 0 8px 0; font-weight: 600; width: 50%;"><?php esc_html_e('Nachricht', 'simple-appointment-booking'); ?></label>
                            <textarea name="simpbook_email_storniert_nachricht" id="email_storniert_nachricht" rows="8" class="large-text" style="width: 100%;"><?php echo esc_textarea($simpbook_email_storniert_nachricht_val); ?></textarea>
                            <p class="description"><?php esc_html_e('Verfügbare Platzhalter: {name}, {date}, {time}, {service_name}, {employee_name}, {company_name}', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="simpbook-tab-content" id="content-design">
                <h2><?php esc_html_e('Design-Einstellungen', 'simple-appointment-booking'); ?></h2>
                <div class="simpbook-settings-grid">
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Haupt-Hintergrundfarbe', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <div style="display: flex; gap: 10px; align-items: center; margin-bottom: 10px;">
                                <input name="simpbook_container_background" type="color" id="container_color_picker"
                                       value="<?php echo esc_attr($simpbook_container_background); ?>">
                                <input name="container_background_text" type="text" id="container_background_input"
                                       value="<?php echo esc_attr($simpbook_container_background); ?>"
                                       pattern="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$"
                                       placeholder="#FFFFFF"
                                       style="width: 100px;">
                                <button type="button" id="apply_container_color_btn" class="button"><?php esc_html_e('Übernehmen', 'simple-appointment-booking'); ?></button>
                            </div>
                            <p class="description"><?php esc_html_e('Wählen Sie die Hintergrundfarbe für das Reservierungsformular und Hauptfarbe der App (Header, Buttons, etc.)', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Kachel-Hintergrundfarbe', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <div style="display: flex; gap: 10px; align-items: center; margin-bottom: 10px;">
                                <input name="simpbook_tile_background" type="color" id="tile_color_picker"
                                       value="<?php echo esc_attr($simpbook_tile_background); ?>">
                                <input name="tile_background_text" type="text" id="tile_background_input"
                                       value="<?php echo esc_attr($simpbook_tile_background); ?>"
                                       pattern="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$"
                                       placeholder="#FFFFFF"
                                       style="width: 100px;">
                                <button type="button" id="apply_tile_color_btn" class="button"><?php esc_html_e('Übernehmen', 'simple-appointment-booking'); ?></button>
                            </div>
                            <p class="description"><?php esc_html_e('Wählen Sie die Hintergrundfarbe für die Kacheln (Datum, Dienstleistung, Mitarbeiter, etc.).', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Textfarbe', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <div style="display: flex; gap: 10px; align-items: center; margin-bottom: 10px;">
                                <input name="simpbook_text_color" type="color" id="text_color_picker"
                                       value="<?php echo esc_attr($simpbook_text_color); ?>">
                                <input name="text_color_text" type="text" id="text_color_input"
                                       value="<?php echo esc_attr($simpbook_text_color); ?>"
                                       pattern="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$"
                                       placeholder="#000000"
                                       style="width: 100px;">
                                <button type="button" id="apply_text_color_btn" class="button"><?php esc_html_e('Übernehmen', 'simple-appointment-booking'); ?></button>
                            </div>
                            <p class="description"><?php esc_html_e('Wählen Sie die Textfarbe für das Reservierungsformular.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Button-Farbe', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <div style="display: flex; gap: 10px; align-items: center; margin-bottom: 10px;">
                                <input name="simpbook_button_color" type="color" id="button_color_picker"
                                       value="<?php echo esc_attr($simpbook_button_color); ?>">
                                <input name="button_color_text" type="text" id="button_color_input"
                                       value="<?php echo esc_attr($simpbook_button_color); ?>"
                                       pattern="^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$"
                                       placeholder="#2271b1"
                                       style="width: 100px;">
                                <button type="button" id="apply_button_color_btn" class="button"><?php esc_html_e('Übernehmen', 'simple-appointment-booking'); ?></button>
                            </div>
                            <p class="description"><?php esc_html_e('Wählen Sie die Farbe für die Buttons im Reservierungsformular.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Eckenradius', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <div style="display: flex; align-items: center; gap: 5px; margin-bottom: 10px;">
                                <input name="simpbook_border_radius" type="number" id="border_radius_input"
                                       value="<?php echo esc_attr($simpbook_border_radius); ?>"
                                       min="0" max="50" step="1"
                                       style="width: 100px;">
                                <span>px</span>
                            </div>
                            <p class="description"><?php esc_html_e('Geben Sie den Eckenradius für das Reservierungsformular in Pixel an (0 = eckig, höhere Werte = runder).', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Eckenradius-Kacheln', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <div style="display: flex; align-items: center; gap: 5px; margin-bottom: 10px;">
                                <input name="simpbook_tile_border_radius" type="number" id="tile_border_radius_input"
                                       value="<?php echo esc_attr($simpbook_tile_border_radius); ?>"
                                       min="0" max="50" step="1"
                                       style="width: 100px;">
                                <span>px</span>
                            </div>
                            <p class="description"><?php esc_html_e('Geben Sie den Eckenradius für die Kacheln (Datum, Dienstleistung, Mitarbeiter, Zeit) in Pixel an (0 = eckig, höhere Werte = runder).', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>

                <h2><?php esc_html_e('Formular-Überschriften', 'simple-appointment-booking'); ?></h2>
                <p class="description" style="margin-bottom: 20px;"><?php esc_html_e('Passen Sie die Texte der Überschriften im Frontend-Formular an.', 'simple-appointment-booking'); ?></p>
                <div class="simpbook-settings-grid">
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Datums-Überschrift', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_form_header_date" type="text" id="form_header_date_input"
                                   value="<?php echo esc_attr($simpbook_form_header_date); ?>"
                                   style="width: 100%;">
                            <p class="description"><?php esc_html_e('Überschrift für die Datumsauswahl im Formular.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Dienstleistungs-Überschrift', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_form_header_service" type="text" id="form_header_service_input"
                                   value="<?php echo esc_attr($simpbook_form_header_service); ?>"
                                   style="width: 100%;">
                            <p class="description"><?php esc_html_e('Überschrift für die Dienstleistungsauswahl im Formular.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Mitarbeiter-Überschrift', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_form_header_employee" type="text" id="form_header_employee_input"
                                   value="<?php echo esc_attr($simpbook_form_header_employee); ?>"
                                   style="width: 100%;">
                            <p class="description"><?php esc_html_e('Überschrift für die Mitarbeiterauswahl im Formular.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Uhrzeit-Überschrift', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_form_header_time" type="text" id="form_header_time_input"
                                   value="<?php echo esc_attr($simpbook_form_header_time); ?>"
                                   style="width: 100%;">
                            <p class="description"><?php esc_html_e('Überschrift für die Uhrzeitauswahl im Formular.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Kontaktdaten-Überschrift', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input name="simpbook_form_header_contact" type="text" id="form_header_contact_input"
                                   value="<?php echo esc_attr($simpbook_form_header_contact); ?>"
                                   style="width: 100%;">
                            <p class="description"><?php esc_html_e('Überschrift für den Kontaktdaten-Bereich im Formular.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="simpbook-tab-content" id="content-language">
                <h2><?php esc_html_e('Spracheinstellungen', 'simple-appointment-booking'); ?></h2>
                <div class="simpbook-settings-grid">
                    <?php
                    $simpbook_wp_language = simpbook_get_wordpress_language();
                    $simpbook_language_override = simpbook_get_option('simpbook_language_override', '');
                    $simpbook_active_language = simpbook_get_current_language();
                    $simpbook_language_override_nonce = wp_create_nonce('simpbook_language_override_nonce');
                    ?>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Aktuelle WordPress-Sprache', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <strong style="font-size: 16px; color: #2271b1;"><?php echo esc_html(simpbook_get_language_name($simpbook_wp_language)); ?></strong>
                            <p class="description"><?php esc_html_e('Das Plugin verwendet automatisch Ihre WordPress-Sprache. Wenn Ihre WordPress-Sprache nicht verfügbar ist, wird Englisch verwendet.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Sprache überschreiben', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <input type="hidden" id="simpbook_language_override_nonce" value="<?php echo esc_attr($simpbook_language_override_nonce); ?>">
                            <select name="simpbook_language_override" id="simpbook_language_override" style="width: 100%; max-width: 300px;">
                                <option value="auto" <?php selected($simpbook_language_override, ''); selected($simpbook_language_override, 'auto'); ?>><?php esc_html_e('Automatisch (WordPress-Sprache)', 'simple-appointment-booking'); ?></option>
                                <option value="de_DE" <?php selected($simpbook_language_override, 'de_DE'); ?>><?php echo esc_html(simpbook_get_language_native_name('de_DE')); ?></option>
                                <option value="en_US" <?php selected($simpbook_language_override, 'en_US'); ?>><?php echo esc_html(simpbook_get_language_native_name('en_US')); ?></option>
                                <option value="en_US_AMPM" <?php selected($simpbook_language_override, 'en_US_AMPM'); ?>><?php echo esc_html(simpbook_get_language_native_name('en_US_AMPM')); ?></option>
                                <option value="en_GB" <?php selected($simpbook_language_override, 'en_GB'); ?>><?php echo esc_html(simpbook_get_language_native_name('en_GB')); ?></option>
                                <option value="it_IT" <?php selected($simpbook_language_override, 'it_IT'); ?>><?php echo esc_html(simpbook_get_language_native_name('it_IT')); ?></option>
                                <option value="es_ES" <?php selected($simpbook_language_override, 'es_ES'); ?>><?php echo esc_html(simpbook_get_language_native_name('es_ES')); ?></option>
                                <option value="fr_FR" <?php selected($simpbook_language_override, 'fr_FR'); ?>><?php echo esc_html(simpbook_get_language_native_name('fr_FR')); ?></option>
                                <option value="pl_PL" <?php selected($simpbook_language_override, 'pl_PL'); ?>><?php echo esc_html(simpbook_get_language_native_name('pl_PL')); ?></option>
                                <option value="ru_RU" <?php selected($simpbook_language_override, 'ru_RU'); ?>><?php echo esc_html(simpbook_get_language_native_name('ru_RU')); ?></option>
                                <option value="sv_SE" <?php selected($simpbook_language_override, 'sv_SE'); ?>><?php echo esc_html(simpbook_get_language_native_name('sv_SE')); ?></option>
                            </select>
                            <p class="description"><?php esc_html_e('Überschreiben Sie die automatische Spracherkennung. Lassen Sie es auf "Automatisch", um WordPress-Sprachänderungen automatisch zu folgen.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                    <div class="simpbook-setting-card">
                        <h3><?php esc_html_e('Aktive Sprache', 'simple-appointment-booking'); ?></h3>
                        <div>
                            <strong style="font-size: 16px; color: #46b450;"><?php echo esc_html(simpbook_get_language_name($simpbook_active_language)); ?></strong>
                            <p class="description"><?php esc_html_e('Dies ist die Sprache, die das Plugin derzeit für E-Mail-Vorlagen und andere Funktionen verwendet.', 'simple-appointment-booking'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- App Tab Content -->
            <div class="simpbook-tab-content" id="content-app">
                <?php
                // App-Settings Tab Content wird vom PWA Controller gerendert
                if (class_exists('Simpbook_PWA_Controller')) {
                    $simpbook_pwa_controller = Simpbook_PWA_Controller::get_instance();
                    $simpbook_pwa_controller->render_app_settings_tab();
                } else {
                    echo '<p>' . esc_html__('PWA-Modul nicht verfügbar.', 'simple-appointment-booking') . '</p>';
                }
                ?>
            </div>
        </div>

        <p class="submit">
            <input type="submit" name="simpbook_einstellungen_submit" class="button button-primary" value="<?php esc_attr_e('Einstellungen speichern', 'simple-appointment-booking'); ?>">
        </p>
    </form>

    <script>
    jQuery(document).ready(function($) {
        // Sprach-Dropdown: Bei Änderung Seite neu laden, damit sprachspezifische Werte geladen werden
        $('#simpbook_language_override').on('change', function() {
            var selectedLanguage = $(this).val();
            var currentLanguage = '<?php echo esc_js($simpbook_active_language); ?>';
            var $select = $(this);
            
            // Nur neu laden, wenn sich die Sprache wirklich ändert
            if (selectedLanguage !== currentLanguage && selectedLanguage !== 'auto') {
                // Zeige benutzerdefinierten Confirm-Dialog (rotes Design)
                simpbookConfirm(
                    '<?php esc_html_e('Die Seite wird neu geladen, um die sprachspezifischen Einstellungen zu laden. Nicht gespeicherte Änderungen gehen verloren. Fortfahren?', 'simple-appointment-booking'); ?>',
                    '<?php esc_html_e('Sprache ändern', 'simple-appointment-booking'); ?>'
                ).then(function(confirmed) {
                    if (confirmed) {
                        // Speichere Sprache via AJAX und lade dann neu
                        $.post(ajaxurl, {
                            action: 'simpbook_save_language_override',
                            language: selectedLanguage,
                            nonce: $('#simpbook_language_override_nonce').val()
                        }, function() {
                            location.reload();
                        });
                    } else {
                        // Setze Dropdown zurück
                        $select.val(currentLanguage);
                    }
                });
            } else if (selectedLanguage === 'auto') {
                // Bei 'auto' auch neu laden
                simpbookConfirm(
                    '<?php esc_html_e('Die Seite wird neu geladen, um die sprachspezifischen Einstellungen zu laden. Nicht gespeicherte Änderungen gehen verloren. Fortfahren?', 'simple-appointment-booking'); ?>',
                    '<?php esc_html_e('Sprache ändern', 'simple-appointment-booking'); ?>'
                ).then(function(confirmed) {
                    if (confirmed) {
                        $.post(ajaxurl, {
                            action: 'simpbook_save_language_override',
                            language: 'auto',
                            nonce: $('#simpbook_language_override_nonce').val()
                        }, function() {
                            location.reload();
                        });
                    } else {
                        $select.val(currentLanguage);
                    }
                });
            }
        });
    });
    </script>

</div>






