<?php
// admin/dienstleistung-bearbeiten.php
// Direkten Zugriff verhindern
if (!defined('ABSPATH')) {
    exit;
}

// Testphase-Hinweis anzeigen
simpbook_display_trial_notice_on_admin_pages();

// CSS wird bereits in admin_skripte_laden() geladen - NICHT hier, da zu spät!

global $wpdb;
$simpbook_table_name = $wpdb->prefix . 'dienstleistungen';

// phpcs:ignore WordPress.Security.NonceVerification.Recommended -- GET parameter for ID check only
$simpbook_dienstleistung_id = isset($_GET['simpbook_id']) ? intval($_GET['simpbook_id']) : 0;
$simpbook_dienstleistung = null;
if ($simpbook_dienstleistung_id > 0) {
    // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data
    $simpbook_dienstleistung = $wpdb->get_row($wpdb->prepare("SELECT * FROM %i WHERE id = %d", $simpbook_table_name, $simpbook_dienstleistung_id));
}
// Formular verarbeiten
// phpcs:ignore WordPress.Security.NonceVerification.Missing -- Nonce wird geprüft
if (isset($_POST['simpbook_dienstleistung_speichern']) && check_admin_referer('simpbook_dienstleistung_speichern')) {
    $simpbook_name = isset($_POST['simpbook_name']) ? sanitize_text_field(wp_unslash($_POST['simpbook_name'])) : '';
    $simpbook_dauer_minuten = isset($_POST['simpbook_dauer_minuten']) ? intval($_POST['simpbook_dauer_minuten']) : 30;
    $simpbook_pufferzeit_minuten = isset($_POST['simpbook_pufferzeit_minuten']) ? intval($_POST['simpbook_pufferzeit_minuten']) : 0;
    $simpbook_beschreibung = isset($_POST['simpbook_beschreibung']) ? wp_kses_post(wp_unslash($_POST['simpbook_beschreibung'])) : '';
    $simpbook_aktiv = isset($_POST['simpbook_aktiv']) ? 1 : 0;
    $simpbook_sortierung = isset($_POST['simpbook_sortierung']) ? intval($_POST['simpbook_sortierung']) : 0;

    if (empty($simpbook_name)) {
        echo '<div class="notice notice-error"><p>' . esc_html__('Bitte geben Sie einen Namen ein.', 'simple-appointment-booking') . '</p></div>';
    } else {
        $simpbook_data = [
            'name' => $simpbook_name,
            'dauer_minuten' => $simpbook_dauer_minuten,
            'pufferzeit_minuten' => $simpbook_pufferzeit_minuten,
            'beschreibung' => $simpbook_beschreibung,
            'aktiv' => $simpbook_aktiv,
            'sortierung' => $simpbook_sortierung,
        ];

        if ($simpbook_dienstleistung_id > 0 && $simpbook_dienstleistung) {
            // Aktualisieren
            $wpdb->update($simpbook_table_name, $simpbook_data, ['id' => $simpbook_dienstleistung_id], ['%s', '%d', '%d', '%s', '%d', '%d'], ['%d']); // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Booking system requires direct DB access for real-time data
            wp_safe_redirect(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-dienstleistungen&simpbook_nachricht=aktualisiert')));
            
            exit;
        } else {
            // Neu erstellen
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery
            $wpdb->insert($simpbook_table_name, $simpbook_data, ['%s', '%d', '%d', '%s', '%d', '%d']);
            wp_safe_redirect(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-dienstleistungen&simpbook_nachricht=gespeichert')));
            exit;
        }
    }
}

// Werte für Formular
$simpbook_name_value = $simpbook_dienstleistung ? $simpbook_dienstleistung->name : '';
$simpbook_dauer_value = $simpbook_dienstleistung ? $simpbook_dienstleistung->dauer_minuten : 30;
$simpbook_pufferzeit_value = $simpbook_dienstleistung ? $simpbook_dienstleistung->pufferzeit_minuten : 0;
$simpbook_beschreibung_value = $simpbook_dienstleistung ? $simpbook_dienstleistung->beschreibung : '';
$simpbook_aktiv_checked = $simpbook_dienstleistung ? $simpbook_dienstleistung->aktiv : 1;
$simpbook_sortierung_value = $simpbook_dienstleistung ? $simpbook_dienstleistung->sortierung : 0;
?>

<div class="wrap simpbook-admin-wrap">
    <h1 class="wp-heading-inline"><?php echo $simpbook_dienstleistung_id > 0 ? esc_html__('Dienstleistung bearbeiten', 'simple-appointment-booking') : esc_html__('Neue Dienstleistung hinzufügen', 'simple-appointment-booking'); ?></h1>
    <a href="<?php echo esc_url(simpbook_maybe_add_pwa_param(admin_url('admin.php?page=simpbook-dienstleistungen'))); ?>" class="page-title-action"><?php esc_html_e('Zurück zur Liste', 'simple-appointment-booking'); ?></a>
    <hr class="wp-header-end">

    <form method="post" action="<?php echo esc_attr(simpbook_get_form_action()); ?>">
        <?php wp_nonce_field('simpbook_dienstleistung_speichern'); ?>

        <table class="form-table">
            <tr>
                <th scope="row"><label for="simpbook_name"><?php esc_html_e('Name *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_name" type="text" id="simpbook_name"
                           value="<?php echo esc_attr($simpbook_name_value); ?>"
                           class="regular-text" required>
                    <p class="description"><?php esc_html_e('Name der Dienstleistung (z.B. "Haarschnitt", "Massage")', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_dauer_minuten"><?php esc_html_e('Dauer (Minuten) *', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_dauer_minuten" type="number" id="simpbook_dauer_minuten"
                           value="<?php echo esc_attr($simpbook_dauer_value); ?>"
                           min="5" max="480" step="5" class="small-text" required>
                    <p class="description"><?php esc_html_e('Dauer der Dienstleistung in Minuten', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_pufferzeit_minuten"><?php esc_html_e('Pufferzeit (Minuten)', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_pufferzeit_minuten" type="number" id="simpbook_pufferzeit_minuten"
                           value="<?php echo esc_attr($simpbook_pufferzeit_value); ?>"
                           min="0" max="60" step="5" class="small-text">
                    <p class="description"><?php esc_html_e('Pufferzeit nach der Dienstleistung (z.B. für Reinigung, Vorbereitung). Diese Zeit wird zusätzlich zur Dauer für die Blockierung verwendet.', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_beschreibung"><?php esc_html_e('Beschreibung', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <textarea name="simpbook_beschreibung" id="simpbook_beschreibung" rows="5" cols="50" class="large-text"><?php echo esc_textarea($simpbook_beschreibung_value); ?></textarea>
                    <p class="description"><?php esc_html_e('Optionale Beschreibung der Dienstleistung', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><label for="simpbook_sortierung"><?php esc_html_e('Sortierung', 'simple-appointment-booking'); ?></label></th>
                <td>
                    <input name="simpbook_sortierung" type="number" id="simpbook_sortierung"
                           value="<?php echo esc_attr($simpbook_sortierung_value); ?>"
                           min="0" step="1" class="small-text">
                    <p class="description"><?php esc_html_e('Niedrigere Zahlen werden zuerst angezeigt. Bei gleicher Zahl wird alphabetisch sortiert.', 'simple-appointment-booking'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php esc_html_e('Status', 'simple-appointment-booking'); ?></th>
                <td>
                    <label for="simpbook_aktiv">
                        <input name="simpbook_aktiv" type="checkbox" id="simpbook_aktiv" value="1" <?php checked($simpbook_aktiv_checked, 1); ?>>
                        <?php esc_html_e('Aktiv (wird im Frontend angezeigt)', 'simple-appointment-booking'); ?>
                    </label>
                </td>
            </tr>
        </table>

        <p class="submit">
            <input type="submit" name="simpbook_dienstleistung_speichern" class="button button-primary" value="<?php esc_attr_e('Speichern', 'simple-appointment-booking'); ?>">
        </p>
    </form>
</div>






